/***************************************************************************
    file	         : tkc_pytracelist.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYTRACELIST_H
#define	__TKC_PYTRACELIST_H

#include	"kb_python.h"

#include	"tkc_pydebugbase.h"
#include	"tkc_pyvaluelist.h"

/*  TKCPyTraceItem							*/
/*  --------------							*/
/*  Class used to display information about tracepoints (breakpoints	*/
/*  and watchpoints).							*/
/*									*/
/*  There are two cases:						*/
/*	(a) Function entry tracepoints, in which case the python object	*/
/*	    is a code object						*/
/*	(b) Line tracepoints, in which case the python object is a	*/
/*	    module							*/

class	TKCPyTraceItem : public TKCPyValueItem
{
	bool	enabled	;	/* Enabled as breakpoint		*/
	uint	count	;	/* Hit count				*/

	bool	online	;	/* Trace-point on a line		*/
	uint	lineno	;	/* Line number				*/

public	:

	TKCPyTraceItem (QListView *, const QString &, TKCPyValue *, bool) ;
	TKCPyTraceItem (QListView *, const QString &, TKCPyValue *, bool, uint) ;

	inline	void	enable
		(	bool	_enabled
		)
	{
		enabled	= _enabled	;
		setText (3, enabled ? "On" : "Off") ;
	}
 
	inline	bool	isEnabled ()
	{
		return	enabled	;
	}

	inline	void	increment ()
	{
		count	+= 1	;
		setText (4, QString("%1").arg(count)) ;
	}

	inline	uint	getLineno ()
	{
		return	lineno	;
	}
}	;

#endif	// __TKC_PYTRACELIST_H
