/***************************************************************************
    file	         : pysqlselect.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYSQLSELECT_H
#define	__KB_PYSQLSELECT_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"pybase.h"

class	PyKBSQLSelect : public PyKBBase
{
public	:

	inline	PyKBSQLSelect
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	~PyKBSQLSelect ()
	{
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		if (SQLSelect != 0) delete SQLSelect ;
	}

	inline	bool	execute
		(	uint		nVals,
			const KBValue	*values
		)
	{
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		if (SQLSelect == 0) return false ;

		return	SQLSelect->execute (nVals, values) ;
	}

	inline	uint	getNumRows ()
	{
		// KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		// return SQLSelect == 0 ? 0 : SQLSelect->getNumRows() ;
		return	0 ;
	}

	inline	uint	getNumFields ()
	{
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		return	SQLSelect == 0 ? 0 : SQLSelect->getNumFields() ;
	}

	inline	bool	rowExists
		(	uint	row
		)
	{
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		return	SQLSelect == 0 ? false : SQLSelect->rowExists(row) ;
	}

	inline	cchar	*getField
		(	uint	row,
			uint	col
		)
	{
		static	QString	aQString ;
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		if (SQLSelect == 0) return "" ;
		aQString = SQLSelect->getField(row, col).getRawText() ;
		return	aQString ;
	}

	inline	cchar 	*getFieldName
		(	uint	col
		)
	{
		static	QString	aQString ;
		KBSQLSelect *SQLSelect = (KBSQLSelect *)getPtr() ;
		if (SQLSelect == 0) return "" ;
		aQString = SQLSelect->getFieldName(col) ;
		return	aQString ;
	}

	inline	cchar	*lastError ()
	{
		return	PyKBBase::lastError ((KBSQLSelect *)getPtr()) ;
	}
}	;

#endif	// __KB_PYSQLSELECT_H
