#!/bin/sh

# installit - simple install script
# $Id: installit.sh,v 1.4 2002/05/28 15:54:50 remstats Exp $
# from remstats @@VERSION@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# - - -   Setup   - - -

if [ $# -lt 5 ] ; then
	echo >&2 "usage: `basename $0` owner group mode src destdir"
	exit 1
fi

owner=$1
group=$2
mode=$3
src=`echo $* | awk '{for (i=4; i<=NF-1; ++i) { out=out " " $i;} print out}'`
last="\$$#"
destdir=`eval echo $last`

if [ -z "$destdir" ] ; then
	echo >&2 "`basename $0`: missing destination"
	exit 2
fi

# - - -   Mainline   - - -

# copy them all
cp $src $destdir || (echo "can't copy $src to $destdir" && exit 3)

# Have to loop anyway, might as well fix them here
for f in $src ; do
	dest="$destdir/`basename $f`"

	if [ `id | cut -f2 -d\( | cut -f1 -d\)` = root ] ; then
		chown $owner $dest || (echo "can't chown for $dest" && exit 4)
		chgrp $group $dest || (echo "can't chgrp for $dest" && exit 5)
	fi
	chmod $mode $dest || (echo "can't chmod for $dest" && exit 6)
done

exit 0;
