\name{checkVers}
\alias{checkVers}
\title{A function to compare versions w/ operation string}
\description{
  Handles comparisons of VersionNumber objects when the operator
  is in string form (e.g. ">=", "==", etc).
}
\usage{
checkVers(x, op, y)
}
\arguments{
  \item{x}{The left side object}
  \item{op}{The operator to use for comparison, in string format}
  \item{y}{The right object to compare}
}
\details{
   Will handle the situation 'x op y' for any op that is a valid
   comparitor in the VersionNumber class.  The string 'op' is converted
   into the proper comparitor and then applied to the values x and y.
}
\value{
  TRUE or FALSE as appropriate
}
\author{ Jeff Gentry }
\examples{
   a <- buildVersionNumber("1.2.3")
   b <- buildVersionNumber("2.0")
   checkVers(a,"<=",b)    ## will see if a <= b
   checkVers(a,"==",b)
   checkVers(a,">",b)
}
\keyword{utilities}

