\name{getReposEntry}
\alias{getReposEntry}
\title{A function to retrieve a ReposEntry object from a repository}
\description{
  Will retrieve repository information from a specified repository, and
  pass back a ReposEntry object containing this information.
}
\usage{
getReposEntry(repURL, repFile = "replisting", rddFile =
"repdatadesc.rda", rtFile = "repThemes.rda", method="auto") 
}
\arguments{
  \item{repURL}{URL of the repository}
  \item{repFile}{Name of the remote replisting file}
  \item{rddFile}{Name of the remote dataframe RDA file.}
  \item{rtFile}{Name of the remote theme RDA file.}
  \item{method}{Method used for file downloads.  See \code{download.file}}
}
\details{
  More often then not, it will be more convenient for a user interacting
  with an \R session to use the function \code{\link{repositories}}.

  The symbolic names used to reference the URLs in the
  \code{repositories2} option can also be used for the \code{repURL}
  argument.  
  
  The latter three options should be left to the defaults in almost all
  cases.

  The remote replisting and (if available) repdatadesc.rda
  and repThemes.rda files are downloaded from the specified repository
  and combined to form a ReposEntry object.
}
\value{
  The constructed ReposEntry object, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{repositories}}, \code{\link{ReposEntry-class}}}
\examples{
  z <- getReposEntry("http://www.bioconductor.org/repository/sample/package")
  z

  a <- getReposEntry("BIOCcdf")
  repURL(a)
  a
}
\keyword{utilities}
