\name{syncLocalLibList}
\alias{syncLocalLibList}
\alias{checkImports}
\title{A function to synch the local library file}
\description{
  Will look for a file liblisting.Rda in specified R library directory,
  and synch any information that is not in the current liblisting into
  that file.  If no such file exists, will create one.
}
\usage{
syncLocalLibList(lib = reposToolsLibPaths(), quiet=TRUE)
}
\arguments{
  \item{lib}{A vector of library directories to synch.  Default is reposToolsLibPaths()}
  \item{quiet}{A verbosity argument.  More output is provided when \code{FALSE}}
}
\details{
  If there is not currently a liblisting.Rda file in the specified
  lib(s), one will be created.  Any new information (new packages,
  updated versions, etc) will be reflected into the liblisting.Rda
  file.  If multiple libs are specified, this procedure will be repeated
  across all libs.

  The liblisting.Rda file contains an object named \code{locLibList}.
  This object is a list of \code{localPkg} objects.  Each object in the
  list represents one installed package in that library directory.
}
\author{ Jeff Gentry }
\seealso{\code{\link{install.packages2}},
  \code{\link{update.packages2}}, \code{\link{remove.packages2}}, \code{\link{reposToolsLibPaths}}}
\examples{
    ## make a temporary directory for use in this example
    a <- tempfile()
    dir.create(a)
    syncLocalLibList(a)
    unlink(a,recursive=TRUE)
}
\keyword{utilities}

