\name{untgz}
\alias{untgz}
\title{Create a connection to a .tar.gz file}
\description{
    Return a connection to the contents of filename within the .tar.gz
    archive given in description.
    
    If checkExists, stop if filename isn't in the archive.  This
    requires reading a list of the entire archive contents.
    
    The idea is to provide a .tar.gz equivalent to the unz() built-in.
}
\usage{
untgz(description, filename, open = "", checkExists = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{description}{The filename of the .tar.gz}
  \item{filename}{The filename of the file in the .tar.gz archive that
    you want to access.}
  \item{open}{The returned connection will have use this value}
  \item{checkExists}{If TRUE, then a raise an error if \code{filename}
    is not found in \code{description}.  Otherwise, you'll just get such
    a message as the supposed contents of the file.  This costs an extra
    file open and read.}
}
\value{
  A connection to the contents of the specified file within the archive.
}
\author{S. Falcon}
\keyword{IO}

