\name{winConvertSourceRepos}
\alias{winConvertSourceRepos}
\title{A function to convert source repositories to Win32 repositories}
\description{
  This function will take source packages from a repository, convert
  them into Win32 binary packages.
}
\usage{
winConvertSourceRepos(repEntry, pkgs, destDir, recurse = TRUE,
searchOptions = TRUE, errorLog, origFileDir)
}
\arguments{
  \item{repEntry}{A repository URL to convert}
  \item{pkgs}{A set of packages to convert}
  \item{destDir}{Where to store the converted packages}
  \item{recurse}{Whether to convert any sub-repositories.  Default is TRUE}
  \item{searchOptions}{Whether to search the repositories listed in 
	options("repositories") for packages as well.  Default is TRUE.} 
  \item{errorLog}{An optional parameter specifying an output file for
    errors generated by this function}
  \item{origFileDir}{An optional parameter specifying where to store the
    source versions of the packages - if this is not specified, the
    system will store them in a temporary directory which will be
    removed at the end.}
}
\details{
  The user must specify at least one of \code{repEntry} or \code{pkgs}.
  If only the former is supplied, all packages from that repository will
  be converted.  If only the latter is supplied, then
  \code{searchOptions} must be TRUE and repositories listed in the
  user's options will be searched.  If both are used, then only the
  specified packages are converted from the specified repository.

  The system will convert the packages into a Win32 binary package,
  which is then suitable to be turned into a repository with \code{genRepos}.
}
\author{Jeff Gentry}
\seealso{\code{\link{genRepos}}}
\examples{
}
\keyword{utilities}
