\name{writeThemesXML}
\alias{writeThemesXML}
\title{A function to author repository theme XML files}
\description{
  This function is used to generate XML files for use with repository
  \code{\link{themes}}.  
}
\usage{
writeThemesXML(themeList, repTXML = "repThemes.xml")
}
\arguments{
  \item{themeList}{A list describing the set of themes for a repository.}
  \item{repTXML}{The XML output filename, defaults to \code{repThemes.xml}.}
}
\details{
  The \code{themeList} argument specifies the themes for a repository.
  The names of the elements correspond to the theme names, and the
  values of each element detail the structure of the theme.  Each
  element is another list which itself has three elements:
  \code{Description}, \code{Repository} and \code{Packages}.  The
  \code{Description} element is a character string describing the theme,
  and the \code{Repository} element is another character string giving
  the URL of the repository that this theme belongs to.  The
  \code{Packages} element is a third list with elements which are
  either \code{\link{pkgInfo}} objects or package names.

  Specifying a \code{\link{pkgInfo}} object as an entry is useful if the
  repository maintainer wishes to use a particular version of a package
  in their theme.  It a simple package name is given, then the highest
  version of that particular package in the repository is the one that
  is used.
}
\value{
  An XML file, name specified by \code{repTXML}, which contains a
  description of the repository themes specified by \code{themeList}.
}
\author{Jeff Gentry}
\seealso{\code{\link{repositoryThemes}}, \code{\link{reposTheme-class}},
  \code{\link{pkgInfo}}}
\examples{
   z <- list(Theme1=list(Description="One simple test",
                         Repository="http://www.repURL.com/",
                         Packages=list("Biobase", "Ruuid", "ROC", "geneplotter")),
             Theme2=list(Description="Another simple test",
                         Repository="http://www.repURL.com",
                         Packages=list(buildPkgInfo("annotate", "1.3.0"),
                         "genefilter", buildPkgInfo("affy", "1.3.0"))))
   ## Using tempfile() instead of default filename for example
   writeThemesXML(z, tempfile())
}
\keyword{utilities}
