/*
 *  confirm-dialog.c     -
 *
 *  Created: 20011230
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: confirm-dialog.c,v 1.13 2002/03/19 21:51:26 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <confirm-dialog.h>

#include <gdk/gdkkeysyms.h>
#include <intl.h>

/* Struktura suaca do przechowywania danych okienka dialogowego. */
typedef struct
{
    GtkWidget          *confirm_dialog;
    confirm_value_type confirm_value;
} confirm_dialog_data;

/* Funkcja obsugujca wcinicie przycisku okienka dialogowego. */
static void button_clicked(GtkWidget *button, confirm_value_type confirm_value)
{
    confirm_dialog_data *data;

    g_assert(button != NULL);
    
    /* Pobieranie wskanika do struktury danych okienka dialogowego. */
    data = (confirm_dialog_data *)gtk_object_get_data(GTK_OBJECT(button), "data");
    g_assert(data != NULL);

    data->confirm_value = confirm_value;
}

/* Funkcja obsugujca sygna "delete_event" okienka potwierdzenia. */
static gboolean delete_event(GtkWidget *widget, GdkEvent *event, confirm_dialog_data *data)
{
    g_assert(data != NULL);
    
    data->confirm_value = G_CONFIRM_CANCEL;
    
    return FALSE;
}

/* Funkcja obsugujca sygna "key_press_event" okienka potwierdzenia. */
static gboolean key_pressed(GtkWidget *widget, GdkEventKey *event, confirm_dialog_data *data)
{
    g_assert(data != NULL);
    
    /* Zamykanie okienka dialogowego w przypadku nacinicia klawisza Esc. */
    if (event && event->keyval == GDK_Escape)
        data->confirm_value = G_CONFIRM_CANCEL;
    
    return TRUE;
}

/* Funkcja tworzca i wykonujca okienko potwierdzenia. */
confirm_value_type confirm_dialog(GtkWidget *parent, gchar *message, guint buttons)
{
    GtkWidget *dialog_vbox;
    GtkWidget *label;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;
    
    confirm_dialog_data *data;
    
    guint i;

    /* Utworzenie zmiennej suacej do przechowywania danych okienka dialogowego. */
    data = (confirm_dialog_data *)g_malloc(sizeof(confirm_dialog_data));
    data->confirm_value = G_CONFIRM_WAIT;
    
    /* Utworzenie okienka dialogowego. */
    data->confirm_dialog = gtk_dialog_new();
    
    /* Obsuga sygnaw. */
    gtk_signal_connect(GTK_OBJECT(data->confirm_dialog), "delete_event",
                       GTK_SIGNAL_FUNC(delete_event), data);
    gtk_signal_connect(GTK_OBJECT(data->confirm_dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(key_pressed), data);
    
    /* Ustalenie tytuu i rozmiarw. */
    gtk_window_set_title(GTK_WINDOW(data->confirm_dialog), _("Confirmation"));
    gtk_widget_set_usize(GTK_WIDGET(data->confirm_dialog), 300, 120);
    
        /* Obszar wntrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(data->confirm_dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Etykieta z tekstem potwierdzenia. */
	    label = gtk_label_new(message);
	    gtk_widget_show(label);
	    
	gtk_box_pack_start(GTK_BOX(dialog_vbox), label, TRUE, FALSE, 0);
	
	/* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(data->confirm_dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox,
	                   TRUE, TRUE, 0);
	
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
	                              GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
		for (i = 0; i < 3; i++)
		{
	            if ((buttons & (1 << i)) != 0)
		    {
		        switch (1 << i)
		        {
		            case G_CONFIRM_YES:
		                button = gtk_button_new_with_label(_("Yes"));
				break;
		            case G_CONFIRM_NO:
		                button = gtk_button_new_with_label(_("No"));
				break;
		            case G_CONFIRM_CANCEL:
		                button = gtk_button_new_with_label(_("Cancel"));
				break;
			    default:
			        g_assert_not_reached();
		        }
		        gtk_widget_show(button);
		
		        gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                           GTK_SIGNAL_FUNC(button_clicked),
				           GUINT_TO_POINTER(1 << i));
		    
		        gtk_object_set_data(GTK_OBJECT(button), "data", data);
		
	                gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	    
	                GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		    }
		}
		
    /* Wyswietlenie okienka dialogowego. */
    gtk_widget_show(data->confirm_dialog);
    
    /* Ustalenie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(data->confirm_dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(data->confirm_dialog), GTK_WINDOW(parent));

    /* Petla obsugi komunikatw czekajca na
       zmian wartoci zmiennej value. */
    while (data->confirm_value == G_CONFIRM_WAIT)
        gtk_main_iteration();

    /* Zniszczenie okienka potwierszenia. */	
    gtk_widget_destroy(data->confirm_dialog);
#if 0
    GTK_EVENTS_FLUSH();
#endif

    return data->confirm_value;
}
