#include "colourentry.h"

static void colourChanged(GtkColorSelection* widget, guint, guint, guint, guint, ColourEntry* data)
{
        data->changed();
}

ColourEntry::ColourEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        valueWidget = gnome_color_picker_new();
        gtk_signal_connect(GTK_OBJECT(valueWidget), "color-set", GTK_SIGNAL_FUNC(colourChanged), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), valueWidget, false, false, 3);
        gtk_widget_show(valueWidget);;
}

DataSet ColourEntry::getValue()
{
        guint8 rb, gb, bb, ab;
        gnome_color_picker_get_i8(GNOME_COLOR_PICKER(valueWidget), &rb, &gb, &bb, &ab);
        int r = int(rb);
        int g = int(gb);
        int b = int(bb);
        
        string newValue("#");
        char tmp[20];
        
        sprintf(tmp, "%x", r);
        if (strlen(tmp) == 1)
                newValue += '0';
        newValue += tmp;
        
        sprintf(tmp, "%x", g);
        if (strlen(tmp) == 1)
                newValue += '0';
        newValue += tmp;

        sprintf(tmp, "%x", b);
        if (strlen(tmp) == 1)
                newValue += '0';
        newValue += tmp;

        return DataSet(newValue);
}

void ColourEntry::setValue(const DataSet& value)
{
        bool cSet = false;
        if (value.count() > 0) {
                string v = value.getString();
                if (v.length() == 7)
                        if (v[0] == '#') {
                                string rs(v, 1, 2);
                                string gs(v, 3, 2);
                                string bs(v, 5, 2);
                                guint8 r = strtol(rs.c_str(), 0, 16);
                                guint8 g = strtol(gs.c_str(), 0, 16);
                                guint8 b = strtol(bs.c_str(), 0, 16);
                                gnome_color_picker_set_i8(GNOME_COLOR_PICKER(valueWidget), r, g, b, 255);
                                cSet = true;
                        }
        }
        if (!cSet)
                gnome_color_picker_set_i8(GNOME_COLOR_PICKER(valueWidget), 255, 255, 255, 255);
}
