#include "modifierentry.h"

#include <gnome.h>

#include "../module_tree.h"
#include "stringentry.h"
#include "fileentry.h"
#include "fontentry.h"
#include "intentry.h"
#include "boolentry.h"
#include "imageentry.h"
#include "tableentry.h"
#include "childvarentry.h"
#include "enumentry.h"
#include "colourentry.h"

static void delClicked(GtkButton* widget, ModifierEntry* data)
{
        data->getParent().removeEntry(data);
}


ModifierEntry::ModifierEntry(const string& varName, const Path& mod_,
                             ModifierEntryListener& parent_, bool owner)
        : name(varName),
          mod(mod_),
          parent(parent_)
{
        vbox = gtk_vbox_new(false, 0);
        hbox = gtk_hbox_new(false, 0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox, false, false, 3);
        if (!owner) {
                GtkWidget* delButton = gtk_button_new_with_label("Remove Override");
                gtk_box_pack_start(GTK_BOX(hbox), delButton, false, false, 3);
                gtk_signal_connect(GTK_OBJECT(delButton), "clicked", GTK_SIGNAL_FUNC(delClicked), this);
        }
        GtkWidget* varNameLabel = gtk_label_new(const_cast<gchar*> (varName.c_str()));
        gtk_box_pack_start(GTK_BOX(hbox), varNameLabel, false, false, 3);
}

void ModifierEntry::cancel()
{
        reload();
}

void ModifierEntry::changed()
{
        parent.setChanged(true);
}

ModifierEntry* ModifierEntry::createByTypeName(const string& typeName, const string& varName,
                                               const Path& mod_, ModifierEntryListener& parent_,
                                               bool owner)
{
        if (typeName == "string")
                return new StringEntry(varName, mod_, parent_, owner);
        else if (typeName == "file")
                return new FileEntry(varName, mod_, parent_, owner);
        else if (typeName == "font")
                return new FontEntry(varName, mod_, parent_, owner);
        else if (typeName == "int")
                return new IntEntry(varName, mod_, parent_, owner);
        else if (typeName == "bool")
                return new BoolEntry(varName, mod_, parent_, owner);
        else if (typeName == "image")
                return new ImageEntry(varName, mod_, parent_, owner);
        else if (typeName == "table")
                return new TableEntry(varName, mod_, parent_, owner);
        else if (typeName == "childoutput")
                return new ChildVarEntry(varName, mod_, parent_, owner);
        else if (typeName == "enum")
                return new EnumEntry(varName, mod_, parent_, owner);
        else if (typeName == "colour")
                return new ColourEntry(varName, mod_, parent_, owner);
        
        assert(false); // unknown variable type
        
        return 0;
}

void ModifierEntry::apply()
{
        try {
                ModuleTree::instance()->set_value(mod, name, getValue());
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void ModifierEntry::reload()
{
        try {
                DataSet value = ModuleTree::instance()->get_value(mod, name);
                setValue(value);
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}
