/* This has been more or less re-written a few times, but it may contain code from
 * roottail by Mike Baker <mbm@linux.com>
 */

#include "filetail.h"
#include "../../module_registry.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <cstring>
using namespace std;

DataSetMap *FileTail::moduleInfo = 0;

Module* filetail_constructor()
{
        return new FileTail();
}

const DataSetMap& FileTail::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Monitor the end of a file"));
                moduleInfo->set("supported_vars", DataSet("filename,readbuffer"));
                moduleInfo->set("supported_var_types", DataSet("file,int"));
                moduleInfo->set("supported_var_defaults", DataSet(",10"));
                moduleInfo->set("overridable", DataSet("false,false"));
                moduleInfo->set("output_variables", DataSet("textline"));
        }
        return *moduleInfo;
}

extern "C" int filetail_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Filetail", &filetail_constructor, FileTail::get_module_info_instance());
        return 0;
}

extern "C" void filetail_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Filetail");
        FileTail::destroy_module_info();
}

FileTail::FileTail()
        : file(NULL)
{
}

FileTail::~FileTail()
{
        if (file != NULL) {
                if (verbose)
                        cout << "closing: \"" << filename << "\"" << endl;
                fclose(file);
        }
        rpdbgmsg(getName() << " module destroyed");
}

void FileTail::service()
{
        Module::service();
                
  	if (!openFile())
  	    	return;

        string text;
	while (true) {
		int tmp = fgetc(file);
		if (tmp <= 0 || tmp == 10 || tmp == 13 || tmp > 255 )
		    	break;
		text += char(tmp);
	}
        if (text.length() == 0)
                return;

        DataSet msg;
        msg.addString(text);
        addToOutput("textline", msg);
        sendOutput();
}

void FileTail::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "filename") {
                was_valid = false;
                if (file != NULL) {
                        fclose(file);
                        file = NULL;
                }
                filename = data.getString();
        }
	if (keyName == "readbuffer") {
	    	/* a read buffer only really counts if a file already exists */
		if (openFile()) {
		    	int backwards = 1, newlines = 0;
			fseek (file, -(backwards), SEEK_END);
			long filelength = ftell(file);
			int readbuffer_value = data.getInt() + 2;
			for (backwards = 1; backwards < filelength; backwards++) {
				if (fgetc(file) == 10) {
				    	newlines++;
					if (newlines >= readbuffer_value) {
					    	backwards = 0;
						break;
					}
				}
				fseek(file, -(backwards), SEEK_END);
			}
			if (backwards !=0)
			    	fseek(file, 0, SEEK_SET);
		}
	}
}

bool FileTail::openFile()
{
        if (filename == "")
                return false;
    	long fileposition = -1;
    	if (file != NULL) {
	    	fileposition = ftell(file);
		file = freopen(filename.c_str(), "rb", file);
	} else {
		file = fopen(filename.c_str(), "rb");
                if (file == NULL) {
                        if (!was_valid) {
                                DataSet msg;
                                msg.addString("Error");
                                msg.addString("Error opening file \"" + filename + "\": "
                                              + strerror(errno));
                                filename = "";
                                return_message(msg);
                        }
                } else {
                        was_valid = true;
                }
        }
        
	if (file == NULL)
		return false;
        
	if (fileposition != -1) {
                struct stat file_info;
                stat(filename.c_str(), &file_info);
                if (file_info.st_size >= fileposition)
                        fseek(file, fileposition, SEEK_SET);
                else
                        fseek(file, file_info.st_size, SEEK_SET);
        }
        
	return true;
}
