#ifndef __RMDBG_H__
#define __RMDBG_H__


/* It's nice to be able to see where the function was called from too,
 * so we go through the trouble to see if we're using GNU C compiler
 * and set PRETTY_FUNCTION appropriately */
#ifdef __GNUC__
#define PRETTY_FUNCTION __PRETTY_FUNCTION__
#else
#define PRETTY_FUNCTION ""
#endif /* __GNUC__ */


#define RMDBG_ALLOC(function_name, free_function_name, size, real_alloc_function) \
    rmdbg_alloc__P (__FILE__, __LINE__, PRETTY_FUNCTION, \
                    function_name, free_function_name, size, \
                    real_alloc_function)


#define RMDBG_FREE(ptr, function_name, real_free_function, really_free) \
    do { \
        rmdbg_free__P (__FILE__, __LINE__, function_name, ptr, really_free); \
        real_free_function; \
    } while (0)


/* Set the filename to be used to output memory debugging information.
 * This can alternatively be set to 'NULL' to disable saving to
 * a file. */
void
rmdbg_set_outfile (char *filename);

void *
rmdbg_alloc__P (char *file__, int line__, char *pretty_function, 
                char *function_name, char *free_function_name, 
                unsigned int size, void *ptr);

void
rmdbg_free__P (char *file__, int line__, char *function_name, 
               void *ptr, int really_free);

/* Special case for rmem_realloc () */
void *
rmdbg_rmem_realloc__P (void *ptr, int size, char *file__, 
                       int line__, char *pretty_function);

int 
rmdbg_rxp_decode_rbuf__P (RXpDecoder *decoder, RBuf **value, char *file__,
                          int line__, char *pretty_function);

RList *
rmdbg_rbuf_split__P (const RBuf *string, char *separators, int max_splits,
                     char *file__, int line__, char *pretty_function);

void
rmdbg_rlist_of_rbufs_free__P (RList *list, char *file__, 
                              int line__, char *pretty_function);

void
rmdbg_nop (void);

#endif /* __RMDBG_H__ */


