
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#define RMDBG_ENABLED 1

#include <roy.h>


void
print_usage (char *progname);

void
foo1 (void);

void
foo2 (void);

void
print_usage (char *progname)
{
    printf ("%s [-g <debug domains>] [-h]\n", progname);
}

void
foo1 (void)
{
    foo2 ();
}

void
foo2 (void)
{
    char *bar;
    RBuf *buf;

    /* use rchunk_alloc for double free test as it won't segfault 
     * (I don't think) */
    bar = rchunk_alloc (200);
    rchunk_free (bar, 200);
    rchunk_free (bar, 200);
    bar = rmem_alloc0 (200);
    
    buf = rbuf_new ();
    rbuf_own (buf);
    rbuf_release (buf);
    rbuf_free (buf);
    
    buf = rbuf_new ();
    rbuf_own (buf);
    rbuf_release (buf);
    rbuf_release (buf);
    rbuf_free (buf);
    
    buf = rbuf_new ();
    rbuf_own (buf);
    rbuf_free (buf);
}

int main (int argc, char **argv)
{
    char *domains;
    RBuf *foo;
    char *bar;

    rinit ();

    RARGV_SWITCH {
        case 'h':
            print_usage (argv[0]);
            exit (0);
            break;

        case 'g':
            domains = RARGV_NEXT;
            if (domains == NULL) {
                printf ("Argument expected for -g\n");
                print_usage (argv[0]);
                exit (0);
            }
            rdebug_enable (domains);
            printf ("Enabled debug for domains: '%s'\n", domains);
            break;

        case '*':
            printf ("Unexpected argument: '%s'\n", RARGV_CURRENT);
            print_usage (argv[0]);
            exit (0);
            break;
            
        default:
            printf ("Unknown flag: -%c\n", RARGV_CURRENT_FLAG);
            print_usage (argv[0]);
            exit (0);
            break;

    } RARGV_CLOSE;


    foo = rbuf_new ();
    rbuf_free (foo);

    bar = rmem_alloc0 (100);
    rbuf_free ((RBuf *) bar);

    foo1 ();
   
    bar = rmem_alloc (128);
    bar = rmem_realloc (bar, 1024);
    rmem_free (bar);

    return (0);
}

