,(use paths
      graphics.script.manager ; implicitly builds graphics.script, too
      graphics.device)

(define (graphic-dest-file (file <file-name>) entry-point)
  (let ((fn (if (eq? entry-point 'draw)
                file
                (append-path
                 (file-directory file)
                 (string->file (~ "~a_~a" (filename file) entry-point))))))
    (extension-related-path fn "eps")))

(define (generate-graphic (file <file-name>) 
                          #key (entry-point default: 'draw)
                               (force default: #f parameter: force?)
                               (arguments default: '())
                               (print? default: #f))
                          
  (let* ((src (pathname->os-path file))
         (dstf (graphic-dest-file file entry-point))
         (dst (pathname->os-path dstf)))
    ;;
    (format #t "[~a" (filename file))
    (flush-output-port (current-output-port))
    ;;
    (if (and (not force?) (up-to-date? src dst))
        (begin
          (format #t " ok]")
          (flush-output-port (current-output-port))
          (get-eps-bbox dstf))
        (let ((s #f))
          (format #t " renew")
          (flush-output-port (current-output-port))
          ;;
          (set! s (load-graphic-script file))
          ;;
          (let (((proc <function>) (eval-in-graphic-script s entry-point)))
            ;;
            (if print?
                (begin
                  (with-graphics-file
                   (pathname->os-path (extension-related-path dstf "ps"))
                   (lambda ()
                     (startpage (current-graphics-device))
                     (apply proc arguments)
                     (endpage (current-graphics-device))))
                  (values))
                (let ((box (with-graphics-file
                            dst
                            (lambda ()
                              ;; draw them to PNGs 75% bigger
                              (scale (current-graphics-device) 1.75 1.75)
                              (apply proc arguments))
                            type: 'eps)))
                  (format #t "]")
                  (flush-output-port (current-output-port))
                  box)))))))


;;;

(define (tg #optional (src default: "pagesinmem.scm"))
  (generate-graphic
   (append-path (current-directory) (string->file src))
   force: #t))
   

(define (tgp #optional (src default: "pagesinmem.scm"))
  (generate-graphic
   (append-path (current-directory) (string->file src))
   force: #t
   print?: #t))
   

(define (gv name)
  (run "gv" "-watch" name))

