/*
*  Rubrica
*  file: import_int.c
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "import_int.h"
#include "import.h"
#include "ui.h"


GtkWidget *fileentry;

static RubricaOptionType import_options[] = {
  {"", N_("GnomeCard addressbook"),      IMPORT_GNOMECARD},
  {"", N_("Kde addressbook"),            IMPORT_KAB},
  {"", N_("Old Rubrica addressbook"),    IMPORT_RUBRICA},
  {"", N_("Csv (Mozilla) addressbook"),  IMPORT_CSV_MOZILLA},
  {"", N_("Csv (Netscape) addressbook"), IMPORT_CSV_NETSCAPE},
  {"", N_("VCard addressbook"),          IMPORT_VCARD},
  {"", N_("Pine addressbook"),           IMPORT_PINE},
  {NULL, NULL}
};


GtkWidget*
create_import_dialog (GtkWidget *parent)
{
  GtkWidget *import_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *frame;
  GtkWidget *frame2;
  GtkWidget *vbox;

  GtkWidget *pixbox;
  GtkWidget *pixmap;

  GtkWidget *option_box;
  GtkWidget *option_label;
  GtkWidget *option_menu;


  import_dialog = gtk_dialog_new();
  gtk_dialog_add_buttons(GTK_DIALOG(import_dialog), 			 
			 GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, 
			 GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,NULL);
  gtk_window_set_title(GTK_WINDOW(import_dialog), _("Import file"));
  gtk_window_set_resizable (GTK_WINDOW (import_dialog), FALSE);
  
  gtk_dialog_set_has_separator (GTK_DIALOG(import_dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (import_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (import_dialog), FALSE, FALSE, FALSE);

  dialog_vbox = GTK_DIALOG (import_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  frame = rubrica_ui_frame_new (_("Import"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame, TRUE, TRUE, 2);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  pixbox = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(vbox), pixbox, FALSE, FALSE, 2);

  pixmap = rubrica_ui_image_new("import.png");
  gtk_box_pack_start(GTK_BOX(pixbox), pixmap, FALSE, FALSE, 2);

  option_box = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(vbox), option_box, FALSE, FALSE, 2);

  option_label = gtk_label_new (_("Import from:"));
  gtk_widget_show(option_label);
  gtk_box_pack_start (GTK_BOX (option_box), option_label, FALSE, FALSE, 3);

  option_menu = rubrica_ui_option_menu_new(import_options);
  gtk_box_pack_start(GTK_BOX (option_box), option_menu, FALSE, FALSE, 3);
  gtk_option_menu_set_history(GTK_OPTION_MENU(option_menu), IMPORT_GNOMECARD); 
 

  /*  Gnome FileSelector
   */
  frame2 = rubrica_ui_frame_new (_("Import file"));
  gtk_box_pack_start (GTK_BOX (vbox), frame2, TRUE, TRUE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  fileentry = gnome_file_entry_new (NULL, _("Import file"));
  gtk_widget_show (fileentry);
  gtk_container_add (GTK_CONTAINER (frame2), fileentry);
  gtk_container_set_border_width (GTK_CONTAINER (fileentry), 5);
  gnome_file_entry_set_directory_entry (GNOME_FILE_ENTRY (fileentry), FALSE);
  gnome_file_entry_set_default_path(GNOME_FILE_ENTRY (fileentry), 
				    g_get_home_dir());
  gnome_file_entry_set_modal (GNOME_FILE_ENTRY (fileentry), TRUE);

  rubrica_import_init(fileentry, IMPORT_GNOMECARD);

  g_signal_connect(G_OBJECT(option_menu), "changed", 
		   G_CALLBACK(import_option_menu_changed), fileentry);

  return import_dialog;
}


GtkWidget *rubrica_import_get_file_entry(void)
{
  return (GtkWidget*) fileentry;
}


void import_option_menu_changed(GtkOptionMenu *menu, gpointer data)
{
  gint opt;

  opt = gtk_option_menu_get_history(GTK_OPTION_MENU(menu));

  if (opt == -1)
    return;
  
  rubrica_import_set(opt);

  switch(opt)
    {
    case IMPORT_KAB:    // kabc load only default addbook (std.vfc)
    case IMPORT_PINE:   // pine addressbook is ~/.addressbook
      gtk_widget_set_sensitive(GTK_WIDGET(data), FALSE);
      break;

    case IMPORT_GNOMECARD:    
    case IMPORT_RUBRICA:
    case IMPORT_CSV_MOZILLA:    
    case IMPORT_CSV_NETSCAPE:    
    case IMPORT_VCARD:
    default:
      gtk_widget_set_sensitive(GTK_WIDGET(data), TRUE);
      break;
    }
}

