/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: prefer.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf-schema.h>
#include <libxml/tree.h>
#include <time.h>

#include "main.h"
#include "dialog.h"
#include "rubrica.h"
#include "prefer.h"
#include "prefer_cb.h"
#include "prefer_int.h"
#include "prefer_configure.h"
#include "rubrica_type.h"




/****************** 
 *                *
 *  GET ROUTINES  *
 *                *
 ******************/

/*  return true is this is the first time that 
    rubrica is running after gconf "era"    
 */
gboolean rubrica_preferences_get_first_run(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_FIRST_RUN, NULL);

  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_FIRST_RUN, NULL); 

  if (value)
    return gconf_client_get_bool(client, RUBRICA_KEY_FIRST_RUN, NULL);   
  
  return TRUE;
}


/*  return user home directory
*/
gchar *rubrica_preferences_get_home(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_HOME, NULL);

  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_HOME, NULL); 

  if (value)
    return gconf_client_get_string(client, RUBRICA_KEY_HOME, NULL);    
  /* else */
  return NULL; 
}


gchar *rubrica_preferences_get_rubrica_home(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_RUBRICA_HOME, NULL);

  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client,
						 RUBRICA_KEY_RUBRICA_HOME, 
						 NULL); 

  if (value)
    return gconf_client_get_string(client, RUBRICA_KEY_RUBRICA_HOME, NULL);    
  /* else */
  return NULL; 
}


gboolean rubrica_preferences_get_show_path(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SHOW, NULL);

  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_SHOW, NULL); 

  if (value)
    return gconf_client_get_bool(client, RUBRICA_KEY_SHOW, NULL);   

  return TRUE;
}

/*
  return true if user wants that rubrica load an addressbook at start
  false otherwise
*/
gboolean rubrica_preferences_get_have_default_addressbook(void)
{
  GConfClient *client;
  GConfValue  *value;

  client  = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_HAVE_BOOK, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_HAVE_BOOK,
						 NULL); 

  if (value)
    return gconf_client_get_bool(client, RUBRICA_KEY_HAVE_BOOK, NULL);  

  return FALSE;
}

/* 
   is user wants start with an addressbook, this funcion returns  
   addressbook's path and file
*/
gchar *rubrica_preferences_get_book(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_BOOK, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_BOOK, 
						 NULL); 

  if (value)
    return gconf_client_get_string(client, RUBRICA_KEY_BOOK, NULL);   
  else
    rubrica_dialog_error_in_preferences_key("rubrica_preferences_get_book");

  return NULL;
}

/*
  return true if users wants to save all 
  addressbook in a default folder
*/
gboolean rubrica_preferences_get_have_default_folder(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_HAVE_FOLDER, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_HAVE_FOLDER,
						 NULL); 

  if (value)
    return gconf_client_get_bool(client, RUBRICA_KEY_HAVE_FOLDER, NULL);    

  return FALSE;
}

/* 
   if user wants to save addressbook in a 
   default folder, this function return the folder
*/
gchar* rubrica_preferences_get_default_folder(void)
{
  GConfClient *client;
  GConfValue  *value;
  gchar *buffer, *tmp, *str;
  gint len;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_FOLDER, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_FOLDER, 
						 NULL); 

  if (value)
    {
      str = gconf_client_get_string(client, RUBRICA_KEY_FOLDER, NULL);  
  
      tmp = g_locale_from_utf8(str, -1, NULL, NULL, NULL);
      len = strlen(tmp);
      if (tmp[len] != '/')
	{
	  buffer = g_strdup_printf("%s%s", tmp, G_DIR_SEPARATOR_S);
	  
	  return buffer;
	}
      else
	return g_strdup(str);
    }
  
  return NULL;
}

/*
  return true is user want to do backup
*/
gboolean rubrica_preferences_get_do_backup(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_BACKUP, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_BACKUP,
						 NULL); 
  
  if (value) 
    return gconf_client_get_bool(client, RUBRICA_KEY_BACKUP, NULL);  

  return FALSE;
}

/*
  return backup type value
*/
gboolean rubrica_preferences_get_backup_type(gchar *key)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, key, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, key, NULL);
  
  if (value) 
    return gconf_client_get_bool(client, key, NULL);  
  
  return FALSE;
}

gboolean rubrica_preferences_get_backup_is_increasing(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_BACKUP_TYPE_INC, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_BACKUP_TYPE_INC,
						 NULL);
  
  if (value) 
    return gconf_client_get_bool(client, RUBRICA_KEY_BACKUP_TYPE_INC, NULL);  
  else
    {
      value  = gconf_client_get(client, RUBRICA_KEY_BACKUP_TYPE_BAK, NULL);
      
      if (value == NULL || value->type != GCONF_VALUE_BOOL)
	value = gconf_client_get_default_from_schema(client, 
						     RUBRICA_KEY_BACKUP_TYPE_BAK, 
						     NULL);
      
      if (value) 
	return !gconf_client_get_bool(client, RUBRICA_KEY_BACKUP_TYPE_BAK, 
				      NULL);       
    }  
  
  return TRUE;  
}


/*
  return true if user want to compress his addressbooks
*/
gboolean rubrica_preferences_get_compress(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_COMPRESS, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_COMPRESS,
						 NULL); 

  if (value)  
    return gconf_client_get_bool(client, RUBRICA_KEY_COMPRESS, NULL);  

  return FALSE;
}

/* 
   if user wants compressed addressbooks. this funcion return 
   the compression rate
*/
gint rubrica_preferences_get_compress_rate(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_RATE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_RATE, 
						 NULL); 

  if (value)  
    return gconf_client_get_int(client, RUBRICA_KEY_RATE, NULL);  
  
  return 0;
}

/*
  return true if user wants autosave enable
*/
gboolean rubrica_preferences_get_autosave(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_AUTOSAVE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_AUTOSAVE,
						 NULL); 

  if (value)  
    return gconf_client_get_bool(client, RUBRICA_KEY_AUTOSAVE, NULL);  

  return FALSE;
}

/* 
   if user wants the autosave, this funcion return 
   the minutes between two saves
*/
gint rubrica_preferences_get_time_rate(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_WAIT_TIME, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_WAIT_TIME,
						 NULL); 

  if (value)  
    return gconf_client_get_int(client, RUBRICA_KEY_WAIT_TIME, NULL);  
  
  return 0;
}

/* 
   return true if cards's order is increasing
   return false if cards's order is decreasing
*/
gint rubrica_preferences_get_sort_direction(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SORT_DIRECTION, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_SORT_DIRECTION, 
						 NULL); 

  if (value)   
    return gconf_client_get_int(client, RUBRICA_KEY_SORT_DIRECTION, NULL);   

  /* else, all fail, return a value */
  return 0; // SORT_ASCENDING;
}

/*
  return true if cards order is alphabetic
*/
gint rubrica_preferences_get_sort_type(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SORT_TYPE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_SORT_TYPE,
						 NULL); 

  if (value)   
    return gconf_client_get_int(client, RUBRICA_KEY_SORT_TYPE, NULL);

  return 0;
}


gint rubrica_preferences_get_search_type(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SEARCH_TYPE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_SEARCH_TYPE, 
						 NULL); 

  if (value)   
    return gconf_client_get_int(client, RUBRICA_KEY_SEARCH_TYPE, NULL);

  /* if !value, return a default value*/
  return SEARCH_CARD;
}


gboolean rubrica_preferences_get_search_case(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SEARCH_SENSITIVE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_SEARCH_SENSITIVE,
						 NULL); 

  if (value)   
    return gconf_client_get_bool(client, RUBRICA_KEY_SEARCH_SENSITIVE, NULL);

  return TRUE; /* TRUE == case sensitive */
}

gboolean rubrica_preferences_get_search_mode(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_SEARCH_COMPLETE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_SEARCH_COMPLETE, 
						 NULL); 

  if (value)   
    return gconf_client_get_bool(client, RUBRICA_KEY_SEARCH_COMPLETE, NULL);

  return TRUE;  /* TRUE == complete string */
}


/*
  return true if user want to exit without confirm
*/
gboolean rubrica_preferences_get_exit(void)
{
  GConfClient* client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_EXIT, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_EXIT, 
						 NULL); 

  if (value)  
    return gconf_client_get_bool(client, RUBRICA_KEY_EXIT, NULL);

  return TRUE;
}


/*
  return true if user want to exit without confirm
*/
RubricaToolbarStyle rubrica_preferences_get_toolbarstyle(void)
{
  GConfClient* client;
  GConfValue  *value;
  RubricaToolbarStyle ret;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_TOOLBAR_STYLE, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_TOOLBAR_STYLE, 
						 NULL); 

  if (value)  
    ret = (RubricaToolbarStyle) gconf_client_get_int(client, RUBRICA_KEY_TOOLBAR_STYLE, NULL);
  else 
    ret = RTS_BOTH;
  
  g_object_unref(client);
  return (RubricaToolbarStyle) ret;
}

RubricaToolbarStyle rubrica_preferences_get_desktop_toolbarstyle(void)
{
  GConfClient* client;
  GConfValue  *value;
  RubricaToolbarStyle ret = RTS_BOTH;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, "/desktop/gnome/interface/toolbar_style",
			    NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, "/desktop/gnome/interface/toolbar_style", NULL); 

  if (value)  
    {
      gchar *style;
      
      style = gconf_client_get_string(client, 
				      "/desktop/gnome/interface/toolbar_style",
				      NULL);
      
      if (g_ascii_strcasecmp(style, "both") == 0)
	ret = (RubricaToolbarStyle) RTS_BOTH;
      else if  (g_ascii_strcasecmp(style, "both_horiz") == 0)
	ret = (RubricaToolbarStyle) RTS_BOTH_HORIZ;
      else  if (g_ascii_strcasecmp(style, "icon") == 0)
	ret = (RubricaToolbarStyle) RTS_ICONS;
      else  if (g_ascii_strcasecmp(style, "text") == 0)
	ret = (RubricaToolbarStyle) RTS_TEXT;      
    }
  else 
    ret = RTS_BOTH;
  
  g_object_unref(client);
  return (RubricaToolbarStyle) ret;
}


/*
  return true if user want to use one of  
  the default dictionary 
*/
gboolean rubrica_preferences_get_use_default_dictionary(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_DEFAULT, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_DEFAULT, 
						 NULL); 

  if (value)   
    return gconf_client_get_bool(client, RUBRICA_KEY_DEFAULT, NULL);

  return TRUE;
}

/*
  return true if user want to use an external 
  dictionary (personal dictionary)
*/
gboolean rubrica_preferences_get_use_user_dictionary(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_EXTERNAL, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_EXTERNAL,
						 NULL); 

  if (value)   
    return gconf_client_get_bool(client, RUBRICA_KEY_EXTERNAL, NULL);

  return FALSE;
}

/*
  return true if user want to use italian dictionary 
*/
gboolean rubrica_preferences_get_use_italian_dictionary(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_ITALIAN, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_BOOL)
    value = gconf_client_get_default_from_schema(client, RUBRICA_KEY_ITALIAN,
						 NULL); 

  if (value)   
    return gconf_client_get_bool(client, RUBRICA_KEY_ITALIAN, NULL);

  return TRUE;
}


gchar *rubrica_preferences_get_dictionary_home(void)
{
  GConfClient *client;
  GConfValue  *value;

  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_DICTIONARY_HOME, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_DICTIONARY_HOME, 
						 NULL); 

  if (value)   
    return gconf_client_get_string(client, RUBRICA_KEY_DICTIONARY_HOME, NULL);

  return NULL;
}


/*
  if user has dictionary, return dictionary filename
*/
gchar* rubrica_preferences_get_user_dictionary(void)
{
  GConfClient *client;
  GConfValue  *value;
  
  client = gconf_client_get_default(); 
  value  = gconf_client_get(client, RUBRICA_KEY_USER_DICTIONARY, NULL);
  
  if (value == NULL || value->type != GCONF_VALUE_STRING)
    value = gconf_client_get_default_from_schema(client, 
						 RUBRICA_KEY_USER_DICTIONARY, 
						 NULL); 
  
  if (value)   
    return gconf_client_get_string(client, RUBRICA_KEY_USER_DICTIONARY, NULL);
  
  return NULL;
}


/******************
 *                *
 *  SET ROUTINES  *
 *                *
 ******************/
void rubrica_preferences_set_first_run(gboolean bool)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_bool(client, RUBRICA_KEY_FIRST_RUN, bool, NULL);  
}
  
void rubrica_preferences_set_last_run(time_t last_run)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_int(client, RUBRICA_KEY_LAST_RUN, last_run, NULL);  
}

void rubrica_preferences_set_last_book(gchar *filename)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_string(client, RUBRICA_KEY_LAST_BOOK, filename, NULL);   
}

void rubrica_preferences_set_home(gchar *home)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_string(client, RUBRICA_KEY_HOME, home, NULL);   
}

void rubrica_preferences_set_rubrica_home(gchar *home)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_string(client, RUBRICA_KEY_RUBRICA_HOME, home, NULL);   
}


void rubrica_preferences_set_have_default_book(gboolean bool)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_bool(client, RUBRICA_KEY_HAVE_BOOK, bool, NULL);  
}

void rubrica_preferences_set_have_default_folder(gboolean bool)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_bool(client, RUBRICA_KEY_HAVE_FOLDER, bool, NULL);  
}

void rubrica_preferences_set_book(gchar *str)
{

  GConfClient *client;

  client = gconf_client_get_default();

  gconf_client_set_string(client, RUBRICA_KEY_BOOK, str, NULL);  
}

void rubrica_preferences_set_folder(gchar *str)
{
  GConfClient *client;

  client  = gconf_client_get_default(); 
  
  gconf_client_set_string(client, RUBRICA_KEY_FOLDER, str, NULL);  
}


void rubrica_preferences_set_user_dictionary(gchar *dict)
{
  GConfClient *client;
  
  client  = gconf_client_get_default(); 
  gconf_client_set_string(client, RUBRICA_KEY_USER_DICTIONARY, dict, NULL);   
}

void rubrica_preferences_set_dictionary_home(gchar *homedict)
{
  GConfClient *client;
  
  client  = gconf_client_get_default(); 
  gconf_client_set_string(client, RUBRICA_KEY_DICTIONARY_HOME, homedict, NULL);
}
