/*
*  Rubrica
*  file: prefer.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_PREFERENCES_H
#define __RUBRICA_PREFERENCES_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "rubrica_type.h"

/* 
 *   /apps/rubrica keys 
 */
#define RUBRICA_KEY_VERSION_MAJOR     "/apps/rubrica/version_major"
#define RUBRICA_KEY_VERSION_MINOR     "/apps/rubrica/version_minor"
#define RUBRICA_KEY_FIRST_RUN         "/apps/rubrica/first_run" 
#define RUBRICA_KEY_LAST_RUN          "/apps/rubrica/last_run"
#define RUBRICA_KEY_LAST_BOOK         "/apps/rubrica/last_book"
#define RUBRICA_KEY_HOME              "/apps/rubrica/home"
#define RUBRICA_KEY_RUBRICA_HOME      "/apps/rubrica/rubrica_home"
#define RUBRICA_KEY_ENABLE_RESIZE     "/apps/rubrica/enable_resize"
#define RUBRICA_KEY_WIDTH             "/apps/rubrica/width"     // altezza
#define RUBRICA_KEY_LENGTH            "/apps/rubrica/length"    // lunghezza



/*
 *   /apps/rubrica/file keys
 */
#define RUBRICA_KEY_SHOW              "/apps/rubrica/file/show_path"
#define RUBRICA_KEY_HAVE_BOOK         "/apps/rubrica/file/load_addressbook"
#define RUBRICA_KEY_BOOK              "/apps/rubrica/file/addressbook"
#define RUBRICA_KEY_HAVE_FOLDER       "/apps/rubrica/file/have_default_folder"
#define RUBRICA_KEY_FOLDER            "/apps/rubrica/file/folder"
#define RUBRICA_KEY_BACKUP            "/apps/rubrica/file/do_backup"
#define RUBRICA_KEY_BACKUP_TYPE_INC   "/apps/rubrica/file/backup_type_inc"
#define RUBRICA_KEY_BACKUP_TYPE_BAK   "/apps/rubrica/file/backup_type_bak"
#define RUBRICA_KEY_COMPRESS          "/apps/rubrica/file/compress_addressbook"
#define RUBRICA_KEY_RATE              "/apps/rubrica/file/compression_rate"
#define RUBRICA_KEY_AUTOSAVE          "/apps/rubrica/file/autosave"
#define RUBRICA_KEY_WAIT_TIME         "/apps/rubrica/file/wait_time"

/*
 *   /apps/rubrica/general keys
 */
#define RUBRICA_KEY_SORT_TYPE         "/apps/rubrica/general/sort_type"
#define RUBRICA_KEY_SORT_DIRECTION    "/apps/rubrica/general/sort_direction"
#define RUBRICA_KEY_SEARCH_TYPE       "/apps/rubrica/general/search_type"
#define RUBRICA_KEY_SEARCH_SENSITIVE  "/apps/rubrica/general/search_case_sensitive"
#define RUBRICA_KEY_SEARCH_COMPLETE   "/apps/rubrica/general/search_complete_string"
#define RUBRICA_KEY_EXIT              "/apps/rubrica/general/confirm_exit"
#define RUBRICA_KEY_TOOLTIPS          "/apps/rubrica/general/enable_tooltips"
#define RUBRICA_KEY_TOOLBAR_STYLE     "/apps/rubrica/general/toolbar_style"


/*
 *   /apps/rubrica/translation keys
 */
#define RUBRICA_KEY_DEFAULT           "/apps/rubrica/translation/use_default_dictionary"
#define RUBRICA_KEY_EXTERNAL          "/apps/rubrica/translation/use_external_dictionary"
#define RUBRICA_KEY_ITALIAN           "/apps/rubrica/translation/use_italian_dictionary"
#define RUBRICA_KEY_ENGLISH           "/apps/rubrica/translation/use_english_dictionary" 
#define RUBRICA_KEY_HAS_DICTIONARY    "/apps/rubrica/translation/user_has_dictionary"
#define RUBRICA_KEY_DICTIONARY_HOME   "/apps/rubrica/translation/dictionary_home"
#define RUBRICA_KEY_USER_DICTIONARY   "/apps/rubrica/translation/dictionary_name"  

/*
 *   /apps/rubrica/show keys
 */
#define RUBRICA_KEY_SHOW_CARD_COLUMN_PIXMAP     "/apps/rubrica/show/card_column/pixmap"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_CARD       "/apps/rubrica/show/card_column/card"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_FIRST_NAME "/apps/rubrica/show/card_column/first_name"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_LAST_NAME  "/apps/rubrica/show/card_column/last_name"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_PROFESSION "/apps/rubrica/show/card_column/profession"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_CITY       "/apps/rubrica/show/card_column/city"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_COUNTRY    "/apps/rubrica/show/card_column/country"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_WEB        "/apps/rubrica/show/card_column/web"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_EMAIL      "/apps/rubrica/show/card_column/email"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_TELEPHONE  "/apps/rubrica/show/card_column/telephone"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_COMPANY    "/apps/rubrica/show/card_column/company"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_ASSIGMENT  "/apps/rubrica/show/card_column/assigment"
#define RUBRICA_KEY_SHOW_CARD_COLUMN_CATEGORIES "/apps/rubrica/show/card_column/categories"

#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_SITE    "/apps/rubrica/show/account_column/site"
#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_WEB     "/apps/rubrica/show/account_column/web"
#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_EMAIL   "/apps/rubrica/show/account_column/email"
#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_LOGIN   "/apps/rubrica/show/account_column/login"
#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_PWORD   "/apps/rubrica/show/account_column/password"
#define RUBRICA_KEY_SHOW_ACCOUNT_COLUMN_DESC    "/apps/rubrica/show/account_column/description"


#define RUBRICA_KEY_SHOW_DATA_FIRST_NAME     "/apps/rubrica/show/personal/first_name"
#define RUBRICA_KEY_SHOW_DATA_MIDDLE_NAME    "/apps/rubrica/show/personal/middle_name"
#define RUBRICA_KEY_SHOW_DATA_LAST_NAME "/apps/rubrica/show/personal/last_name"
#define RUBRICA_KEY_SHOW_DATA_NICKNAME  "/apps/rubrica/show/personal/nickname"
#define RUBRICA_KEY_SHOW_DATA_PROFESSION     "/apps/rubrica/show/personal/profession"
#define RUBRICA_KEY_SHOW_DATA_NAME_PREFIX    "/apps/rubrica/show/personal/name_prefix"
#define RUBRICA_KEY_SHOW_DATA_TITLE      "/apps/rubrica/show/personal/title"
#define RUBRICA_KEY_SHOW_DATA_BIRTHKNOW "/apps/rubrica/show/personal/birthknow"
#define RUBRICA_KEY_SHOW_DATA_BIRTHDAY   "/apps/rubrica/show/personal/birthday"

#define RUBRICA_KEY_SHOW_DATA_STREET     "/apps/rubrica/show/personal/street"
#define RUBRICA_KEY_SHOW_DATA_STREET_NUM "/apps/rubrica/show/personal/street_number"
#define RUBRICA_KEY_SHOW_DATA_ZIP_CODE   "/apps/rubrica/show/personal/zip_code"
#define RUBRICA_KEY_SHOW_DATA_CITY       "/apps/rubrica/show/personal/city"
#define RUBRICA_KEY_SHOW_DATA_PROVINCE   "/apps/rubrica/show/personal/province"
#define RUBRICA_KEY_SHOW_DATA_STATE      "/apps/rubrica/show/personal/state"
#define RUBRICA_KEY_SHOW_DATA_COUNTRY    "/apps/rubrica/show/personal/country"

#define RUBRICA_KEY_SHOW_DATA_WEB        "/apps/rubrica/show/communicate/web"
#define RUBRICA_KEY_SHOW_DATA_EMAIL      "/apps/rubrica/show/communicate/email"
#define RUBRICA_KEY_SHOW_DATA_TELEPHONE  "/apps/rubrica/show/communicate/telephone"


#define RUBRICA_KEY_SHOW_DATA_COMPANY        "/apps/rubrica/show/job/company"
#define RUBRICA_KEY_SHOW_DATA_JOB_STREET     "/apps/rubrica/show/job/street"
#define RUBRICA_KEY_SHOW_DATA_JOB_STREET_NUM "/apps/rubrica/show/job/street_number"
#define RUBRICA_KEY_SHOW_DATA_JOB_ZIP_CODE   "/apps/rubrica/show/job/zip_code"
#define RUBRICA_KEY_SHOW_DATA_JOB_CITY       "/apps/rubrica/show/job/city"
#define RUBRICA_KEY_SHOW_DATA_JOB_PROVINCE   "/apps/rubrica/show/job/province"
#define RUBRICA_KEY_SHOW_DATA_JOB_COUNTRY    "/apps/rubrica/show/job/country"
#define RUBRICA_KEY_SHOW_DATA_JOB_WEB        "/apps/rubrica/show/job/web"
#define RUBRICA_KEY_SHOW_DATA_JOB_EMAIL      "/apps/rubrica/show/job/email"
#define RUBRICA_KEY_SHOW_DATA_OPERATOR       "/apps/rubrica/show/job/operator"
#define RUBRICA_KEY_SHOW_DATA_FAX            "/apps/rubrica/show/job/fax"
#define RUBRICA_KEY_SHOW_DATA_GREEN          "/apps/rubrica/show/job/green"
#define RUBRICA_KEY_SHOW_DATA_CUSTOMER_CARE  "/apps/rubrica/show/job/customer_care"
#define RUBRICA_KEY_SHOW_DATA_JOB_NOTE  "/apps/rubrica/show/job/note"

#define RUBRICA_KEY_SHOW_DATA_ASSIGMENT "/apps/rubrica/show/job/assigment"
#define RUBRICA_KEY_SHOW_DATA_ORG       "/apps/rubrica/show/job/organization"
#define RUBRICA_KEY_SHOW_DATA_DEP       "/apps/rubrica/show/job/department"
#define RUBRICA_KEY_SHOW_DATA_SUB_DEP   "/apps/rubrica/show/job/sub_department"
#define RUBRICA_KEY_SHOW_DATA_SECRETARY "/apps/rubrica/show/job/secretary_name"
#define RUBRICA_KEY_SHOW_DATA_SECR_PHONE     "/apps/rubrica/show/job/secretary_phone"


#define RUBRICA_KEY_SHOW_DATA_MARRIED    "/apps/rubrica/show/notes/is_married"
#define RUBRICA_KEY_SHOW_DATA_SPOUSE     "/apps/rubrica/show/notes/spouse_name"
#define RUBRICA_KEY_SHOW_DATA_SPOUSE_BIRTH   "/apps/rubrica/show/notes/spouse_birthday"
#define RUBRICA_KEY_SHOW_DATA_ANNIVERSARY    "/apps/rubrica/show/notes/anniversary"
#define RUBRICA_KEY_SHOW_DATA_HAS_CHILDREN   "/apps/rubrica/show/notes/has_children"
#define RUBRICA_KEY_SHOW_DATA_CHILDREN    "/apps/rubrica/show/notes/children"
#define RUBRICA_KEY_SHOW_DATA_HOBBIES     "/apps/rubrica/show/notes/hobbies"
#define RUBRICA_KEY_SHOW_DATA_NOTE        "/apps/rubrica/show/notes/note"
#define RUBRICA_KEY_SHOW_DATA_PUBLIC_KEY  "/apps/rubrica/show/notes/public_key"


/*
 *   /apps/rubrica/dictionary keys
 */
#define RUBRICA_KEY_DICT_CARD          "/apps/rubrica/dictionary/card"
#define RUBRICA_KEY_DICT_CARD_GROUP    "/apps/rubrica/dictionary/group"
#define RUBRICA_KEY_DICT_DATA          "/apps/rubrica/dictionary/data"
#define RUBRICA_KEY_DICT_ADDRESS       "/apps/rubrica/dictionary/address"
#define RUBRICA_KEY_DICT_COMPANY       "/apps/rubrica/dictionary/company"
#define RUBRICA_KEY_DICT_WORK          "/apps/rubrica/dictionary/work"

#define RUBRICA_KEY_DICT_FIRST_NAME    "/apps/rubrica/dictionary/first_name"
#define RUBRICA_KEY_DICT_MIDDLE_NAME   "/apps/rubrica/dictionary/middle_name"
#define RUBRICA_KEY_DICT_LAST_NAME     "/apps/rubrica/dictionary/last_name"
#define RUBRICA_KEY_DICT_PROFESSION    "/apps/rubrica/dictionary/profession"
#define RUBRICA_KEY_DICT_NAME_PREFIX   "/apps/rubrica/dictionary/name_prefix"
#define RUBRICA_KEY_DICT_TITLE         "/apps/rubrica/dictionary/title"

#define RUBRICA_KEY_DICT_STREET        "/apps/rubrica/dictionary/street"
#define RUBRICA_KEY_DICT_STREET_NUMBER "/apps/rubrica/dictionary/street_number"
#define RUBRICA_KEY_DICT_ZIP_CODE      "/apps/rubrica/dictionary/zip_code"
#define RUBRICA_KEY_DICT_CITY          "/apps/rubrica/dictionary/city"
#define RUBRICA_KEY_DICT_PROVINCE      "/apps/rubrica/dictionary/province"
#define RUBRICA_KEY_DICT_STATE         "/apps/rubrica/dictionary/state"
#define RUBRICA_KEY_DICT_COUNTRY       "/apps/rubrica/dictionary/country"

#define RUBRICA_KEY_DICT_WEB_ADDRESS   "/apps/rubrica/dictionary/web_address"
#define RUBRICA_KEY_DICT_WEB           "/apps/rubrica/dictionary/web"
#define RUBRICA_KEY_DICT_EMAIL_ADDRESS "/apps/rubrica/dictionary/email_address"
#define RUBRICA_KEY_DICT_EMAIL         "/apps/rubrica/dictionary/email"

#define RUBRICA_KEY_DICT_TELEPHONE_LIST    "/apps/rubrica/dictionary/telephone_list"
#define RUBRICA_KEY_DICT_TELEPHONE_NUMBER  "/apps/rubrica/dictionary/telephone_number"
#define RUBRICA_KEY_DICT_TELEPHONE_TYPE    "/apps/rubrica/dictionary/telephone_type"
#define RUBRICA_KEY_DICT_TELEPHONE_WORK    "/apps/rubrica/dictionary/tel_work"
#define RUBRICA_KEY_DICT_TELEPHONE_HOME    "/apps/rubrica/dictionary/tel_home"
#define RUBRICA_KEY_DICT_TELEPHONE_FAX     "/apps/rubrica/dictionary/tel_fax"
#define RUBRICA_KEY_DICT_TELEPHONE_CELL    "/apps/rubrica/dictionary/tel_cell"
#define RUBRICA_KEY_DICT_TELEPHONE_OTHER   "/apps/rubrica/dictionary/tel_other"

#define RUBRICA_KEY_DICT_COMPANY_NAME  "/apps/rubrica/dictionary/company_name"
#define RUBRICA_KEY_DICT_OPERATOR      "/apps/rubrica/dictionary/operator"
#define RUBRICA_KEY_DICT_GREEN         "/apps/rubrica/dictionary/green"
#define RUBRICA_KEY_DICT_CUSTOMER_CARE "/apps/rubrica/dictionary/customer_care"

#define RUBRICA_KEY_DICT_ASSIGMENT     "/apps/rubrica/dictionary/assigment"
#define RUBRICA_KEY_DICT_ORGANIZATION  "/apps/rubrica/dictionary/organization"
#define RUBRICA_KEY_DICT_DEPARTMENT    "/apps/rubrica/dictionary/department"
#define RUBRICA_KEY_DICT_SUB_DEPARTMENT   "/apps/rubrica/dictionary/sub_department"
#define RUBRICA_KEY_DICT_SECRETARY        "/apps/rubrica/dictionary/secretary"
#define RUBRICA_KEY_DICT_SECRETARY_PHONE  "/apps/rubrica/dictionary/secretary_phone"

#define RUBRICA_KEY_DICT_SPOUSE_NAME    "/apps/rubrica/dictionary/spouse_name"
#define RUBRICA_KEY_DICT_MARRIED        "/apps/rubrica/dictionary/married"
#define RUBRICA_KEY_DICT_ANNIVERSARY    "/apps/rubrica/dictionary/anniversary"
#define RUBRICA_KEY_DICT_CHILDREN       "/apps/rubrica/dictionary/children"
#define RUBRICA_KEY_DICT_CHILDREN_NOTES "/apps/rubrica/dictionary/child_notes"
#define RUBRICA_KEY_DICT_HOBBY          "/apps/rubrica/dictionary/hobby"
#define RUBRICA_KEY_DICT_NOTES          "/apps/rubrica/dictionary/notes"
#define RUBRICA_KEY_DICT_PUBLIC_KEY     "/apps/rubrica/dictionary/public_key"

#define RUBRICA_KEY_DICT_BIRTHDAY       "/apps/rubrica/dictionary/birthday"
#define RUBRICA_KEY_DICT_OTHER_NOTES    "/apps/rubrica/dictionary/other_notes"



gboolean rubrica_preferences_get_first_run(void);
gchar *rubrica_preferences_get_home(void);       
gchar *rubrica_preferences_get_rubrica_home(void);

gboolean rubrica_preferences_get_show_path(void); 
gboolean rubrica_preferences_get_have_default_addressbook(void);
gchar   *rubrica_preferences_get_book(void);  
gboolean rubrica_preferences_get_have_default_folder(void);
gchar   *rubrica_preferences_get_default_folder(void); 
gboolean rubrica_preferences_get_do_backup(void);      
gboolean rubrica_preferences_get_backup_type(gchar *key); 
gboolean rubrica_preferences_get_backup_is_increasing(void);
gboolean rubrica_preferences_get_compress(void);  
gint     rubrica_preferences_get_compress_rate();
gboolean rubrica_preferences_get_autosave(void); 
gint     rubrica_preferences_get_time_rate(void);
 
gint rubrica_preferences_get_sort_type(void);
gint rubrica_preferences_get_sort_direction(void);
gint rubrica_preferences_get_search_type(void);
gboolean rubrica_preferences_get_search_case(void);
gboolean rubrica_preferences_get_search_mode(void);
gboolean rubrica_preferences_get_exit(void);     
RubricaToolbarStyle rubrica_preferences_get_toolbarstyle(void);
RubricaToolbarStyle rubrica_preferences_get_desktop_toolbarstyle(void);
gboolean rubrica_preferences_get_use_default_dictionary(void); 
gboolean rubrica_preferences_get_use_user_dictionary(void);  
gboolean rubrica_preferences_get_use_italian_dictionary(void);
gchar   *rubrica_preferences_get_dictionary_home(void);    
gchar   *rubrica_preferences_get_user_dictionary(void);    

#define user_wants_default_dictionary() rubrica_preferences_get_use_default_dictionary()
#define user_wants_italian_dictionary() rubrica_preferences_get_use_italian_dictionary()
#define rubrica_run_first_time() rubrica_preferences_get_first_run() 
#define backup_is_increasing() rubrica_preferences_get_backup_is_increasing()


void rubrica_preferences_set_first_run(gboolean bool);
void rubrica_preferences_set_last_run(time_t last_run);

void rubrica_preferences_set_last_book(gchar *filename);
void rubrica_preferences_set_home(gchar *home);
void rubrica_preferences_set_rubrica_home(gchar *home);

void rubrica_preferences_set_have_default_book(gboolean bool);
void rubrica_preferences_set_have_default_folder(gboolean bool);
void rubrica_preferences_set_book(gchar *str);
void rubrica_preferences_set_folder(gchar *str);
void rubrica_preferences_set_case_sensitive_search(gboolean state);
void rubrica_preferences_set_complete_search(gboolean state);
void rubrica_preferences_set_incomplete_search(gboolean state);
void rubrica_preferences_set_user_dictionary(gchar *dict);
void rubrica_preferences_set_dictionary_home(gchar *dict_home);

#endif
