#include "rbgst.h"

VALUE
rb_gst_buffer_get_data(VALUE self) {
	return rb_str_new((char *)GST_BUFFER_DATA(RGST_BUFFER(self)), 
			              GST_BUFFER_SIZE(RGST_BUFFER(self)));
}

static VALUE
rb_gst_buffer_flags(VALUE self) {
  return GFLAGS2RVAL(RGST_BUFFER(self), GST_TYPE_BUFFER_FLAG);
}

/* Class: Gst::Buffer */
void
Init_gst_buffer(void)
{
	VALUE c = G_DEF_CLASS (GST_TYPE_BUFFER, "Buffer", mGst);
	rb_define_method(c, "data", rb_gst_buffer_get_data, 0);
	rb_define_method(c, "flags", rb_gst_buffer_flags, 0);

	G_DEF_CLASS(GST_TYPE_BUFFER_FLAG, "Flags", c);
	G_DEF_CONSTANTS(c, GST_TYPE_BUFFER_FLAG, "GST_BUFFER_");
}
