/*
 * Copyright (C) 2006 Sjoerd Simons <sjoerd@luon.net>
 * Copyright (C) 2003, 2004 Laurent Sansonetti <lrz@gnome.org>
 * Copyright (C) 2006 Zaheer Abbas Merali <zaheerabbas at merali dot org>
 *
 * This file is part of Ruby/GStreamer.
 *
 * Ruby/GStreamer is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Ruby/GStreamer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Ruby/GStreamer; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "rbgst.h"

/* Class: Gst::Query
 * Queries. 
 */

static VALUE
rb_gst_query_new_duration (VALUE self, VALUE format)
{
    GstQuery *query;

    query = gst_query_new_duration (GST_FORMAT_TIME);
    return GOBJ2RVAL (query);
}

static VALUE
rb_gst_query_parse_duration (VALUE self)
{
   gint64 length;
   GstFormat format;
   gst_query_parse_duration(RGST_QUERY(self), &format, &length);
   return INT2FIX(length);
}

void
Init_gst_query (void)
{
	VALUE c = G_DEF_CLASS (GST_TYPE_QUERY, "Query", mGst);

	rb_define_singleton_method(c, "new_duration", 
		rb_gst_query_new_duration, 1);
	rb_define_method(c, "parse_duration", rb_gst_query_parse_duration, 0);
}
