
# Copyright (C) 2003 Laurent Sansonetti <lrz@gnome.org>
#
# This file is part of Ruby/GStreamer.
# 
# Ruby/GStreamer is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# Ruby/GStreamer is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with Ruby/GStreamer; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

require 'tests/misc'

class TC_registry < Test::Unit::TestCase
    def test_all_features
        types = [
	        Gst::ElementFactory,
	        Gst::IndexFactory,
	        Gst::TypeFindFactory,
        ]
        types.each do |c|
            i = 0

            Gst::Registry.each_feature(c) do |f|
                assert_instance_of(c, f)
                f2 = Gst::Registry.find_feature(f.name, c)
                assert_instance_of(c, f2)
                assert_equal(f.name, f2.name)
                i += 1
            end
            a = Gst::Registry.get_features(c)
            assert_instance_of(Array, a)
            assert_equal(i, a.size)
            a.each { |f| assert_instance_of(c, f) }
        end
    end
    def test_load_plugins
        r = Gst::Registry.new()
        Gst::Registry.each_plugin do |p|
            assert r.add_plugin(p)
            p2 = r.find_plugin(p.name)
            assert_instance_of(Gst::Plugin, p2)
            assert_equal(p.name, p2.name)
            r.remove_plugin(p)
        end
    end
end

