/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLinkStatusTab.h
    \author Romain BONDUE
    \date 29/07/2005 */
#ifndef __CLINKSTATUSTAB_H__
#define __CLINKSTATUSTAB_H__

extern "C"{
#include <gtk/gtk.h>
}

#include "Exceptions.h"



namespace nsGUI
{
    class CLinkStatusTab
    {
      public :
        CLinkStatusTab () throw();
        operator ::GtkWidget* () throw();
        operator const ::GtkWidget* () const throw();
        void Clear () throw();
        void SetLinkQuality (unsigned short) throw();
        void SetSignalLevel (short) throw();
        void SetNoiseLevel (short) throw();
        void SetStatus (std::string SSID, const std::string& Addr) throw();
        void SetMode (const std::string&) throw();
        void SetChannel (unsigned, double) throw();
        void SetTxRate (unsigned) throw();
        void SetAddr (const std::string&) throw();


      protected :
        void SetBar (::GtkProgressBar*, double Pos, int Value,
                     const char* Suffix) throw();
        /** \return A number between 0.0 and 1.0, inclusive. */
        double dBmToPercent (short) throw();

        static const char* const DisconnectLabel;


      private :
        CLinkStatusTab& operator = (const CLinkStatusTab&);
        CLinkStatusTab (const CLinkStatusTab&);

        ::GtkWidget* const m_pAlignment;
        ::GtkProgressBar* const m_pLinkQualityBar;
        ::GtkProgressBar* const m_pSignalLevelBar;
        ::GtkProgressBar* const m_pNoiseLevelBar;
        ::GtkLabel* const m_pStatusLabel;
        ::GtkLabel* const m_pModeLabel;
        ::GtkLabel* const m_pChannelLabel;
        ::GtkLabel* const m_pTxRateLabel;
        ::GtkLabel* const m_pAddrLabel;

    }; // CLinkStatusTab

} // namespace nsGUI

#include "private/CLinkStatusTab.hxx"

#endif // __CLINKSTATUSTAB_H__
