/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDriversRoot.h
    \author Romain BONDUE
    \date 19/02/2006 */
#ifndef __RTDRIVERSROOT_H__
#define __RTDRIVERSROOT_H__

#include "RTDrivers.h"
#include "SuWProtocol.h"



namespace nsWireless
{
    class CRT2400DriverRoot : public CRT2400Driver, protected CSuWProtocol
    {
      public :
        CRT2400DriverRoot (const std::string&) throw (nsErrors::CException,
                                                      std::bad_alloc);
        ~CRT2400DriverRoot () throw();

        void SetSSID (const std::string&) throw (nsErrors::CSystemExc);
        /** \param The unit is the GHz (2.462 for instance). */
        void SetFrequency (double) throw (nsErrors::CSystemExc);
        void SetChannel (unsigned) throw (nsErrors::CSystemExc);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&) throw (nsErrors::CSystemExc,
                                                        std::bad_alloc);
        void SetMode (Mode_e) throw (nsErrors::CSystemExc);
        /** \param The unit is the Kbps. */
        void SetTxRate (int) throw (nsErrors::CSystemExc);
        void SetAPMacAddr (const CMacAddress&) throw (std::bad_alloc,
                                                      nsErrors::CSystemExc);
        void Scan () throw (nsErrors::CSystemExc);

    }; // CRT2400DriverRoot


    class CRT2500DriverRoot : public CRT2500Driver, protected CSuWProtocol
    {
      public :
        CRT2500DriverRoot (const std::string&) throw (nsErrors::CException,
                                                      std::bad_alloc);
        ~CRT2500DriverRoot () throw();

        void SetSSID (const std::string&) throw (nsErrors::CSystemExc);
        /** \param The unit is the GHz (2.462 for instance). */
        void SetFrequency (double) throw (nsErrors::CSystemExc);
        void SetChannel (unsigned) throw (nsErrors::CSystemExc);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&) throw (nsErrors::CSystemExc,
                                                        std::bad_alloc);
        void SetMode (Mode_e) throw (nsErrors::CSystemExc);
        /** \param The unit is the Kbps. */
        void SetTxRate (int) throw (nsErrors::CSystemExc);
        void SetAPMacAddr (const CMacAddress&) throw (std::bad_alloc,
                                                      nsErrors::CSystemExc);
        void Scan () throw (nsErrors::CSystemExc);
        void SetWirelessMode (WirelessMode_e) throw (nsErrors::CSystemExc);
        void SetTxBurst (bool) throw (nsErrors::CSystemExc);
        void SetBGProtection (BGProtection_e) throw (nsErrors::CSystemExc);
        void SetTxPreamble (TxPreamble_e) throw (nsErrors::CSystemExc);
        void SetTurboRate (bool) throw (nsErrors::CSystemExc);
        void SetAdHocOFDM (bool) throw (nsErrors::CSystemExc);
        void SetRfmontx (bool) throw (nsErrors::CSystemExc);

    }; // CRT2500DriverRoot
 

    class CRT2570DriverRoot : public CRT2570Driver, protected CSuWProtocol
    {
      public :
        CRT2570DriverRoot (const std::string&) throw (nsErrors::CException,
                                                      std::bad_alloc);
        ~CRT2570DriverRoot () throw();

        void SetSSID (const std::string&) throw (nsErrors::CSystemExc);
        /** \param The unit is the GHz (2.462 for instance). */
        void SetFrequency (double) throw (nsErrors::CSystemExc);
        void SetChannel (unsigned) throw (nsErrors::CSystemExc);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&) throw (nsErrors::CSystemExc,
                                                        std::bad_alloc);
        void SetMode (Mode_e) throw (nsErrors::CSystemExc);
        /** \param The unit is the Kbps. */
        void SetTxRate (int) throw (nsErrors::CSystemExc);
        void SetAPMacAddr (const CMacAddress&) throw (std::bad_alloc,
                                                      nsErrors::CSystemExc);
        void Scan () throw (nsErrors::CSystemExc);

    }; // CRT2570DriverRoot

} // namespace nsWireless

#include "private/RTDriversRoot.hxx"

#endif // __RTDRIVERSROOT_H__
