/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CWE17Module.hxx
    \author Romain BONDUE
    \date 21/08/2005
    \warning This file should only be included from CWE17Module.h */
inline void nsCore::CWE17Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CWE17Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CWE17Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CWE17Module::GetPrivateTab () throw() {return 0;}


inline nsUserData::CProfile* nsCore::CWE17Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CWE17Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CWE17Module::EditProfile (unsigned Pos) throw()
{
    return m_Editor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()
