/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTModules.hxx
    \author Romain BONDUE
    \date 19/08/2005
    \warning This file should only be included from RTModules.h */
inline void nsCore::CRT2400Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRT2400Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2400Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRT2400Module::GetPrivateTab () throw() {return 0;}


inline nsUserData::CProfile* nsCore::CRT2400Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CRT2400Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CRT2400Module::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline nsUserData::CProfile* nsCore::CRT2500Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CRT2500Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CRT2500Module::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline void nsCore::CRT2500Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRT2500Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2500Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRT2500Module::GetPrivateTab () throw()
{
    return GTK_WIDGET (m_pTable);

} // GetPrivateTab()


inline void nsCore::CRT2500Module::ResumePreviousState (::GtkComboBox* pCBox)
                                                                        throw()
{
    m_IsSkipped = true;
    ::gtk_combo_box_set_active (pCBox, m_CurrentActiveBoxItem);
    m_IsSkipped = false;

} // ResumePreviousState()


inline nsUserData::CProfile* nsCore::CRT2570Module::NewProfile () throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName);
    return EditNewProfile();

} // NewProfile()


inline nsUserData::CProfile* nsCore::CRT2570Module::NewProfile
                                        (const nsWireless::CCell& Cell) throw()
{
    m_ProfilesFile.NewProfile (NewProfileDefaultName, Cell);
    return EditNewProfile();

} // NewProfile()


inline bool nsCore::CRT2570Module::EditProfile (unsigned Pos) throw()
{
    return m_ProfileEditor.Edit (m_ProfilesFile [Pos]);

} // EditProfile()


inline void nsCore::CRT2570Module::DeleteProfile (unsigned Pos) throw()
{
    m_ProfilesFile.erase (m_ProfilesFile.begin() + Pos);

} // DeleteProfile()


inline nsUserData::CProfile& nsCore::CRT2570Module::GetProfile (unsigned Pos)
                                                                        throw()
{
    return m_ProfilesFile [Pos];

} // GetProfile()


inline unsigned nsCore::CRT2570Module::GetNbProfile () const throw()
{
    return m_ProfilesFile.size();

} // GetNbProfile()


inline ::GtkWidget* nsCore::CRT2570Module::GetPrivateTab () throw()
{
    return GTK_WIDGET (m_pBox);

} // GetPrivateTab()


inline void nsCore::CRT2570Module::ResumePreviousState (::GtkComboBox* pCBox)
                                                                        throw()
{
    m_IsSkipped = true;
    ::gtk_combo_box_set_active (pCBox, m_CurrentActiveBoxItem);
    m_IsSkipped = false;

} // ResumePreviousState()
