/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLinkStatusTab.cxx
    \author Romain BONDUE
    \date 28/07/2005 */
#include <sstream>

#include "CLinkStatusTab.h"



namespace
{
    inline void FillRow (const char* Label, ::GtkWidget* pWidget,
                         ::GtkTable* pTable, unsigned Row) throw()
    {
        ::gtk_table_attach_defaults (pTable, ::gtk_label_new (Label), 0, 1,
                                     Row, Row + 1);
        ::gtk_table_attach_defaults (pTable, pWidget, 1, 2, Row, Row + 1);

    } // FillRow()

} // anonymous namespace



const char* const nsGUI::CLinkStatusTab::DisconnectLabel ("Disconnected");


nsGUI::CLinkStatusTab::CLinkStatusTab () throw()
    : m_pAlignment (::gtk_alignment_new (0.25, 0.5, 0.6, 0.3)),
      m_pLinkQualityBar (GTK_PROGRESS_BAR (::gtk_progress_bar_new())),
      m_pSignalLevelBar (GTK_PROGRESS_BAR (::gtk_progress_bar_new())),
      m_pNoiseLevelBar (GTK_PROGRESS_BAR (::gtk_progress_bar_new())),
      m_pStatusLabel (GTK_LABEL (::gtk_label_new (DisconnectLabel))),
      m_pModeLabel (GTK_LABEL (::gtk_label_new (0))),
      m_pChannelLabel (GTK_LABEL (::gtk_label_new (0))),
      m_pTxRateLabel (GTK_LABEL (::gtk_label_new (0))),
      m_pAddrLabel (GTK_LABEL (::gtk_label_new (0)))
{
    ::GtkTable* const pTable (GTK_TABLE (::gtk_table_new (8, 2, false)));
    ::gtk_container_set_border_width (GTK_CONTAINER (pTable), 6);
    ::gtk_table_set_col_spacings (pTable, 12);
    ::gtk_table_set_row_spacings (pTable, 8);
    FillRow ("Status", GTK_WIDGET (m_pStatusLabel), pTable, 0);
    FillRow ("Mode", GTK_WIDGET (m_pModeLabel), pTable, 1);
    FillRow ("Channel", GTK_WIDGET (m_pChannelLabel), pTable, 2);
    FillRow ("Tx rate", GTK_WIDGET (m_pTxRateLabel), pTable, 3);
    FillRow ("Link quality", GTK_WIDGET (m_pLinkQualityBar), pTable, 4);
    FillRow ("Signal level", GTK_WIDGET (m_pSignalLevelBar), pTable, 5);
    FillRow ("Noise level", GTK_WIDGET (m_pNoiseLevelBar), pTable, 6);
    FillRow ("IP Address", GTK_WIDGET (m_pAddrLabel), pTable, 7);

    ::gtk_container_add (GTK_CONTAINER (m_pAlignment), GTK_WIDGET (pTable));

} // CLinkStatusTab()


void nsGUI::CLinkStatusTab::SetBar (::GtkProgressBar* pBar, double BarPos,
                                    int Value, const char* Suffix) throw()
{
    ::gtk_progress_bar_set_fraction (pBar, BarPos);
    std::ostringstream Os;
    Os << Value << Suffix;
    ::gtk_progress_bar_set_text (pBar, Os.str().c_str());

} // SetBar()


void nsGUI::CLinkStatusTab::Clear () throw()
{
    SetLinkQuality (0);
    SetSignalLevel (-256);
    SetNoiseLevel (-256);
    ::gtk_label_set_text (m_pStatusLabel, DisconnectLabel);
    ::gtk_label_set_text (m_pTxRateLabel, "");

} // Clear()


void nsGUI::CLinkStatusTab::SetChannel (unsigned Channel, double Frequency)
                                                                        throw()
{
    std::ostringstream Os;
    Os << Channel << " (" << Frequency << " GHz)";
    ::gtk_label_set_text (m_pChannelLabel, Os.str().c_str());

} // SetChannel()


void nsGUI::CLinkStatusTab::SetTxRate (unsigned TxRate) throw()
{
    std::ostringstream Os;
    Os << TxRate / 1000.0 << " Mbps";
    ::gtk_label_set_text (m_pTxRateLabel, Os.str().c_str());

} // SetTxRate()
