/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DXF_read.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/24
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "intl.h"

#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Trace.h"
#include "etc.h"
#include "MsgBox.h"
#include "sgy.h"
#include "sagcad.h"
#include "Assistance.h"
#include "MemoryLeak.h"
#include "CopyFunc.h"
#include "Draw.h"
#define _DXF_READ_
#include "DXF_read.h"



/* -------------------------------------------------------------------
 * DxfFileOpen
 * 
 */
int DxfFileOpen(char *OpenFileName, double x, double y)
{
//#define DXF_FILE_OPEN

	char FileName[256], org[256], msg[256];
	FILE *stream;
	int status = 0, debug = 0;


#ifdef DXF_FILE_OPEN
	debug = 1;
	g_print("DXF_read.c : DxfFileOpen() : in\n");
#endif

	sprintf(FileName, "%s", OpenFileName);
	/* < File Open > */
	if ( (stream	 = fopen( FileName , "r" )) == NULL ){
		g_print(_("The file could not be opened. [%s]\n"), FileName);
		return 0;
	}


	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("FILE Data Error\n");
			break;
		}
		/*  */
		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;
			//if (debug > 0) g_print("%s\n", org);

			if (strstr(org,"SECTION") != NULL ) {
				if (LineRead(stream, org) == 0) return 0;
				/* Υ */
				if (atoi(org) == 2) {
					if (LineRead(stream, org) == 0) return 0;
					
					/* HEADER SECTION START */
					if (strstr(org,"HEADER") != NULL ) {
						sprintf(msg, "Reading DXF           [HEADER SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (header_section_read(stream) == 0) {g_print("HEADER ERROR\n"); break;}
						status = status + 1;
					}

					/* CLASSES SECTION START */
					if (strstr(org,"CLASSES") != NULL ) {
						sprintf(msg, "Reading DXF           [CLASSES SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (classes_section_read(stream) == 0) {g_print("CLASSES ERROR\n"); break;}
					}



					/* TABLES SECTION START */
					else if (strstr(org,"TABLES") != NULL ) {
						sprintf(msg, "Reading DXF           [TABLES SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (tables_section_read(stream) == 0) {g_print("TABLES ERROR\n"); break;}
						status = status + 2;
					}

					/* BLOCKS SECTION START */
					else if (strstr(org,"BLOCKS") != NULL ) {
						sprintf(msg, "Reading DXF           [BLOCKS SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (blocks_section_read(stream) == 0) {g_print("BLOCKS ERROR\n"); break;}
						status = status + 4;
					}

					/* ENTITIES SECTION Start */
					else if (strstr(org,"ENTITIES") != NULL ) {
						sprintf(msg, "Reading DXF           [ENTITIES SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (entities_section_read(stream, x, y) == 0) {g_print("ENTITIES ERROR\n"); break;}
						status = status + 8;
					}

					/* OBJECTS SECTION Start */
					else if (strstr(org,"OBJECTS") != NULL ) {
						sprintf(msg, "Reading DXF           [OBJECTS SECTION]");
						StatusMsg(msg);
						if (debug > 0) g_print("%s\n", msg);
						UpDate_widget(MainWindow);
						if (objects_section_read(stream) == 0) {g_print("OBJECTS ERROR\n"); break;}
					}

				}
			}

			/* DXF END */
			else if (strstr(org,"EOF") != NULL ) {
				sprintf(msg, "Reading DXF           [EOF SECTION]");
				StatusMsg(msg);
				if (debug > 0) g_print("%s\n", msg);
				UpDate_widget(MainWindow);
				sprintf(msg, "Reading Font File ");
				StatusMsg(msg);
				if (debug > 0) g_print("%s\n", msg);
				UpDate_widget(MainWindow);
				fclose(stream);
				if (debug > 0) g_print("DXF read status = [%d]\n", status);
//				fprintf(stderr, "ｪλ\n"); 
//				g_print("  DXF_read.c : DxfFileOpen() : cad_list_log GO\n");
//				cad_list_print(&cad_list_info);
//				polyline_list_log(&polyline_list_info);
//				block_list_log(&block_list_info);
//				DXF_Info();
				return status;
			}
		}
	}
	sprintf(msg, "Reading DXF         [ = ERROR = ]");
	StatusMsg(msg);
	UpDate_widget(MainWindow);
	fclose(stream);
//	fprintf(stderr, "۾ｪλ\n"); 
	return 0;
}





/* -------------------------------------------------------------------
 * header_section_read
 * إå
 */
int header_section_read(FILE *stream)
{
//#define HEADER_SECTION_READ
	char org[256];
	int Ret, debug = 0, etc = 0;
	double min_x = 0, min_y = 0, max_x = 0, max_y = 0;


#ifdef HEADER_SECTION_READ
	debug = 1;
	if (debug > 0) g_print("  DXF_read.c : header_section_read() : HEADER SECTION START\n");
#endif


	while(1) {

		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (HEADER SECTION)\n");
			return 0;
		}
		if (debug > 1) g_print("  DXF_read.c : header_section_read() : %s\n", org);


		/* λ */
		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;
			if (strstr(org,"ENDSEC") != NULL ) {
				if (debug > 0) g_print("  DXF_read.c : header_section_read() : HEADER SECTION END\n");
				if (min_x == 0 && min_y == 0 && max_x == 0 && max_y == 0) {
					//
				}
				else {
					MagX = (max_x - min_x) / 2;
					MagY = (max_y - min_y) / 2;
					Mag = sagcad_system.ViewX / (max_x - min_x);
				}
				return 1;
			}
		}


		else if (atoi(org) == 9) {
			if (LineRead(stream, org) == 0) return 0;

			/* AutoCAD Version */
			if (strstr(org,"$ACADVER") != NULL ) {
				if (LineRead(stream, org) == 0) return 0;/* < 1 > */
				if (LineRead(stream, org) == 0) return 0;/* < R12 AC1009	R15 AC1015 > */
				
				if (strstr(org, "AC1015") != NULL ) {
					strcpy(DxfVersion, "R15(AC1015)");
					MsgBox("SagCAD", _("DXF R15(AC1015) doesn't correspond."), _("Only R12(AC1009) and R13J(AC1012)"),
						   NULL, NULL, "OK");
				}
				else if (strstr(org,"AC1006") != NULL ) {
					MsgBox("SagCAD", _("DXF GX(AC1006) doesn't correspond."), _("Only R12(AC1009) and R13J(AC1012)"), 
						   NULL, NULL, "OK");
					strcpy(DxfVersion, "GX(AC1006)");
				}
				else if (strstr(org,"AC1012") != NULL ) {
	//				MsgBox("SagCAD", "DXF R13J(AC1012) бƤޤ\nDXF R12(AC1009) ΤߤǤ\n");
					strcpy(DxfVersion, "R13J(AC1012)");
				}
				else if (strstr(org,"AC1009") != NULL) {
					strcpy(DxfVersion, "R12J(AC1009)");
				}
				else {
					strcpy(DxfVersion, "Unknown");
					Ret = MsgBox("SagCAD", _("DXF GX(AC1006) doesn't correspond."), _("Only R12(AC1009) and R13J(AC1012)"), 
								 "OK", "NO", NULL);
					if (Ret == 0) {
						return 0;
					}
				}
			}

			/* ϰϤαĺ */
			else if (strstr(org,"$LIMMAX") != NULL ) {
				if (LineRead(stream, org) == 0) return 0; /* 10 */
				if (LineRead(stream, org) == 0) return 0;
				max_x = atof(org);

				if (LineRead(stream, org) == 0) return 0; /* 20 */
				if (LineRead(stream, org) == 0) return 0;
				max_y = atof(org);

				if (debug > 0) g_print("  DXF_read.c : header_section_read() : $LIMMAX (%f,%f)\n", max_x, max_y);
			}

			/* ϰϤκĺ */
			else if (strstr(org,"$LIMMIN") != NULL ) {
				if (LineRead(stream, org) == 0) return 0; /* 10 */
				if (LineRead(stream, org) == 0) return 0;
				min_x = atof(org);

				if (LineRead(stream, org) == 0) return 0; /* 20 */
				if (LineRead(stream, org) == 0) return 0;
				min_y = atof(org);

				if (debug > 0) g_print("  DXF_read.c : header_section_read() : $LIMMIN (%f,%f)\n", min_x, min_y);
			}

#ifdef TEST
			/* ֥ϰϤαĺ */
			else if (strstr(org,"$EXTMAX") != NULL ) {
				//
			}
			/* ֥ϰϤκĺ */
			else if (strstr(org,"$EXTMAX") != NULL ) {
				//
			}
#endif

			else {
				if (debug > 0) g_print("  DXF_read.c : header_section_read() : %s\n", org);
			}
		}


		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("  DXF_read.c : header_section_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug == 1) g_print("  DXF_read.c : header_section_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * classes_section_read
 * 饹
 */
int classes_section_read(FILE *stream)
{
//#define CLASSES_SECTION_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef CLASSES_SECTION_READ
	debug = 1;
	if (debug > 0) g_print("  DXF_read.c : classes_section_read() : CLASSES SECTION START\n");
#endif

	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (CLASSES SECTION)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;

			if (strstr(org,"ENDSEC") != NULL ) {
				if (debug > 0) g_print("  DXF_read.c : classes_section_read() : CLASSES SECTION END\n");
				return 1;
			}
		}

		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("  DXF_read.c : classes_section_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug > 0) g_print("  DXF_read.c : classes_section_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * tables_section_read
 * ơ֥륻
 */
int tables_section_read(FILE *stream)
{
//#define TABLES_SECTION_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef TABLES_SECTION_READ
	debug = 1;
	if (debug > 0) g_print("  DXF_read.c : tables_section_read() : TABLES SECTION START\n");
#endif

	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (TABLES SECTION)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;

			if (strstr(org,"ENDSEC") != NULL ) {
				if (debug > 0) g_print("  DXF_read.c : tables_section_read() : TABLES SECTION END\n");
				return 1;
			}

			else if (strstr(org,"TABLE") != NULL ) {
				if (table_read(stream) == 0) break;
			}
		}

		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("  DXF_read.c : tables_section_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug > 0) g_print("  DXF_read.c : tables_section_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * tables_read
 * ơ֥
 */
int table_read(FILE *stream)
{
//#define TABLE_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef TABLE_READ
	debug = 1;
	if (debug > 0) g_print("    DXF_read.c : table_read() : TABLE START\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("    FILE Data Error (TABLE)\n");
			return 0;
		}
		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;
			if (strstr(org,"ENDTAB") != NULL ) {
				if (debug > 0) g_print("    DXF_read.c : table_read() : TABLE END\n");
				return 1;
			}
		}

		else if (atoi(org) == 2) {
			if (LineRead(stream, org) == 0) return 0;
			if (strstr(org,"LAYER") != NULL ) {
				table_read_layer(stream);
				return 1;
			}
//			else if (strstr(org,"LTYPE") != NULL ) {
//				return 1;
//			}
		}

		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug == 1) g_print("    DXF_read.c : table_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug == 1) g_print("    DXF_read.c : table_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * table_read_layer
 * 쥤䡼ơ֥
 */
int table_read_layer(FILE *stream)
{
//#define TABLE_READ_LAYER
	char org[256];
	int color, debug = 0;


#ifdef TABLE_READ_LAYER
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : table_read_layer() : LAYER TABLE START\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("      FILE Data Error (LAYER TABLE)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;

			/* λ */
			if (strstr(org,"ENDTAB") != NULL ) {
				if (debug > 0) g_print("      DXF_read.c : table_read_layer() : LAYER TABLE END\n");
				return 1;
			}

			/* LAYER TABLE */
			else if (strstr(org,"LAYER") != NULL ) {
				DxfLayerIndex = -1;
				while (1) {
					if (LineRead(stream, org) == 0) return 0;

					/* λ */
					if (atoi(org) == 0) {
						if (LineRead(stream, org) == 0) return 0;

						if (strstr(org,"ENDTAB") != NULL ) {
							if (debug > 0) g_print("      DXF_read.c : table_read_layer() : LAYER TABLE END\n");
							return 1;
						}
					}

					/* 쥤䡼 */
					if (atoi(org) == 2) {
						if (LineRead(stream, org) == 0) return 0;
						DxfLayerIndex = DxfLayerIndex + 1;
						sprintf(Layer[DxfLayerIndex].name, "%s", org);
						if (debug > 0) g_print("      DXF_read.c : table_read_layer() : 쥤䡼 (%d) %s\n", DxfLayerIndex, Layer[DxfLayerIndex].name);
					}

					/* 쥤䡼 FRAG */
					else if (atoi(org) == 70) {
						if (LineRead(stream, org) == 0) return 0;
						if (debug > 1) g_print("      DXF_read.c : table_read_layer() :   FRAG (70) %s\n", org);
					}

					/*  */
					else if (atoi(org) == 62) {
						if (LineRead(stream, org) == 0) return 0;
						/* 顼ʤ餽Υ쥤䡼ɽ */
						if (atoi(org) < 0) {
							color = -1 * atoi(org);
							Layer[DxfLayerIndex].draw = 0;
						}
						else {
							color = atoi(org);
							Layer[DxfLayerIndex].draw = 1;
							NowLayer = DxfLayerIndex;
						}
						Layer[DxfLayerIndex].color = DxfColorCh(color);
						if (debug > 1) g_print("      DXF_read.c : table_read_layer() :    (62) {%s} ---> %d:[0x%x]\n", 
												org, DxfLayerIndex, Layer[DxfLayerIndex].color);
					}

					/*  */
					else if (atoi(org) == 6) {
						if (LineRead(stream, org) == 0) return 0;
						/* CONTINUOUS  HIDDEN2	CENTER2  PHANTOM2 */
						Layer[DxfLayerIndex].style = DxfStyleCh(org);
						if (Layer[DxfLayerIndex].style == -99) Layer[DxfLayerIndex].style = 1;
						if (debug > 1) g_print("      DXF_read.c : table_read_layer() :    (6) {%s} ---> %d:[%d]\n", 
												org, DxfLayerIndex, Layer[DxfLayerIndex].style);
						/*int DxfColorCh(atoi(org)) */
					}
				}
			}
		}

		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 2) g_print("      DXF_read.c : table_read_layer() : Layer table start\n");
		}
	}

	return 1;
}





/* -------------------------------------------------------------------
 * blocks_section_read
 * ֥å
 */
int blocks_section_read(FILE *stream)
{
//#define BLOCKS_SECTION_READ
	char org[256];
	int debug = 0, etc;
	static int n;


#ifdef BLOCKS_SECTION_READ
	debug = 1;
	if (debug > 0) g_print("  DXF_read.c : blocks_section_read() : BLOCKS SECTION START\n");
#endif

	while(1) {
		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (BLOCKS SECTION)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;

			/* ENDSEC */
			if (strstr(org,"ENDSEC") != NULL && org[0] == 'E') {
				if (debug > 0) g_print("  DXF_read.c : blocks_section_read() : BLOCKS SECTION END\n");
//				g_print("  DXF_read.c : blocks_section_read() : block_list_log GO\n");
//				block_list_log(&block_list_info);
				return 1;
			}

			/* BLOCK START */
			else if (strstr(org, "BLOCK") != NULL && org[0] == 'B') {
				n++;
				if (debug > 0) g_print("  DXF_read.c : blocks_section_read() : BLOCK start %d\n", n);
				blocks_read(stream);
			}
		}

		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("  DXF_read.c : blocks_section_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug > 0) g_print("  DXF_read.c : blocks_section_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * blocks_read
 * ֥å
 */
int blocks_read(FILE *stream)
{
//#define BLOCKS_READ

	char org[256];
	double X = 0, Y = 0, Z = 0;
	BLOCK block;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	INSERT insert;
//	ELLIPSE ellipse;
	int etc;
	int debug = 0;


#ifdef BLOCKS_READ
	debug = 1;
#endif



	X = 0;
	Y = 0;
	Z = 0;

	block.cad_list_info.head = NULL;
	block.cad_list_info.tail = NULL;
	block.dimension_list_info.head = NULL;
	block.dimension_list_info.tail = NULL;
	block.polyline_list_info.head = NULL;
	block.polyline_list_info.tail = NULL;
	block.insert_list_info.head = NULL;
	block.insert_list_info.tail = NULL;
	block.ellipse_list_info.head = NULL;
	block.ellipse_list_info.tail = NULL;

	while(1) {
		if (LineRead(stream, org) == 0) return 0;
//		g_print("    DXF_read.c : blocks_read() : >> [\"%s\"]\n", org);


		/* BLOCK NAME */
		if (atoi(org) == 2) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷̾ (2) [\"%s\"]\n", org);
//			if (org[0] == '*') {
//				sprintf(block.name, "%s", &org[1]);
//			}
//			else {
				sprintf(block.name, "%s", org);
//			}
		}

		/* BLOCK TYPE */
		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷Υ (70) [%s]\n", org);
			/* ̾Τʤʣ޷ */
			if (atoi(org) == 1) {
				//
			}
			/* ̤ǻȤƤ(̾Ϥ) */
			else if (atoi(org) == 64) {
				//
			}
			else {
//				return 0;
			}
		}

		/* BLOCK BASE POINT X */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			X = atof(org);
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷δ X [%s]\n", org);
		}
		/* BLOCK BASE POINT Y */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			Y = atof(org);
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷δ Y [%s]\n", org);
		}
		/* BLOCK BASE POINT Z */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			Z = atof(org);
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷δ Z [%s]\n", org);
		}





		/* NON CAD DATA */
		else if (strstr(org,"EOF") != NULL ) {
			fprintf(stderr, "CAD DATA ޤ(BLOCK SECTION)\n"); 
			return 0;
		}
		/* ̾ */
		else if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			block.layer = LayerCh(org);
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ʣ޷̾ [\"%s\"]\n", org);
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("    DXF_read.c : blocks_read() :  (62) [%s]\n", org);
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("    DXF_read.c : blocks_read() : ϥɥֹ (5) [%s]\n", org);
		}
		/* Xref */
		else if (atoi(org) == 1) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("    DXF_read.c : blocks_read() : Xref PathName (1) [%s]\n", org);
		}
		/* BLOCK NAME */
		else if (atoi(org) == 3) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("    DXF_read.c : blocks_read() : ʣ޷̾ (3) [\"%s\"]\n", org);
		}






		/* -------------------------------------------------
		 * BLOCK END
		 * 
		 */
		else if (atoi(org) == 0) {
			while (1) {
				if (LineRead(stream, org) == 0) return 0;

				/*  */
				else if (strstr(org, "POINT") != NULL && org[0] == 'P') {
					if (debug > 1) g_print("    DXF_read.c : blocks_read() : POINT\n");
					init_cad(&cad);
					if (DxfPointRead(stream, &cad) == 1) {
						if (debug > 1) g_print("      POINT in BLOCK : (%f,%f)\n", cad.sx, cad.sy);
						/* CAD Data ꥹȤκǽɲ */
						cad_list_add_first(&cad, &block.cad_list_info);
					}
				}
				/*  */
				else if (strstr(org, "LINE") != NULL && org[0] == 'L') {
					if (debug > 1) g_print("    DXF_read.c : blocks_read() : LINE\n");
					init_cad(&cad);
					if (DxfLineRead(stream, &cad) == 1) {
						if (debug > 1) g_print("      LINE in BLOCK : (%f,%f)-(%f,%f)\n", cad.sx, cad.sy, cad.ex, cad.ey);
						/* CAD Data ꥹȤκǽɲ */
						cad_list_add_first(&cad, &block.cad_list_info);
					}
				}
				/* ߸ */
				else if (strstr(org, "ARC") != NULL && org[0] == 'A') {
					if (debug > 1) g_print("    DXF_read.c : blocks_read() : ARC\n");
					init_cad(&cad);
					if (DxfArcRead(stream, &cad) == 1) {
						if (debug > 1) g_print("      ARC in BLOCK : (%f,%f), R%f\n", cad.cx, cad.cy, cad.r);
						/* CAD Data ꥹȤκǽɲ */
						cad_list_add_first(&cad, &block.cad_list_info);
					}
				}
				/*  */
				else if (strstr(org, "CIRCLE") != NULL && org[0] == 'C') {
					if (debug > 1) g_print("    DXF_read.c : blocks_read() : CIRCLE\n");
					init_cad(&cad);
					if (DxfCircleRead(stream, &cad) == 1) {
						if (debug > 1) g_print("      CIRCLE in BLOCK : (%f,%f), R%f\n", cad.cx, cad.cy, cad.r);
						/* CAD Data ꥹȤκǽɲ */
						cad_list_add_first(&cad, &block.cad_list_info);
					}
				}
				/* ʸ */
				else if (strstr(org, "TEXT") != NULL && org[0] == 'T') {
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : TEXT\n");
					init_dimension(&dimension);
					if (DxfTextRead(stream, &dimension) == 1) {
						/* DIMENSION Data ꥹȤκǽɲ */
						dimension_list_add_first(&dimension, &block.dimension_list_info);
					}
				}
				/* SOLID (ɤ٤) */
				else if (strstr(org, "SOLID") != NULL && org[0] == 'S') {
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : SOLID\n");
					init_polyline(&polyline);
					if (DxfSolidRead(stream, &polyline) == 1) {
						/* POLYLINE Data ꥹȤκǽɲ */
						polyline_list_add_first(&polyline, &block.polyline_list_info);
					}
				}
				/* ץ饤 */
				else if (strstr(org, "SPLINE") != NULL && org[0] == 'S') {
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : SPLINE\n");
					init_polyline(&polyline);
					if (DxfSplineRead(stream, &polyline) == 1) {
						/* POLYLINE Data ꥹȤκǽɲ */
						polyline_list_add_first(&polyline, &block.polyline_list_info);
					}
				}
				/* ݥ饤 */
				else if (strstr(org, "POLYLINE") != NULL && org[0] == 'P') {
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : POLYLINE\n");
//g_print("    DXF_read.c : blocks_read() : POLYLINE\n");
					init_polyline(&polyline);
					if (DxfPolyLineRead(stream, &polyline) == 1) {
						/* POLYLINE Data ꥹȤκǽɲ */
						polyline_list_add_first(&polyline, &block.polyline_list_info);
					}
				}

				/* 󥵡 */
				else if (strstr(org, "INSERT") != NULL && org[0] == 'I') {
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : INSERT\n");
					init_insert(&insert);
					if (DxfInsertRead(stream, &insert) == 1) {

//#ifdef TEST
						split_insert(&insert, 
									 &block.cad_list_info, 
									 &block.dimension_list_info, 
									 &block.polyline_list_info, 
									 &block.ellipse_list_info, 
									 0, 
									 0);
//#endif
						/* INSERT Data ꥹȤκǽɲ */
//						insert_list_add_first(&insert, &block.insert_list_info);
					}
				}


				/* ֥å */
				else if (strstr(org,"ENDBLK") != NULL && org[0] == 'E') {
					if (debug > 1) g_print("    DXF_read.c : blocks_read() : ENDBLK\n");
					block_list_add_first(&block, &block_list_info);
					if (debug > 0) g_print("    DXF_read.c : blocks_read() : BLOCK END\n\n");
					return 1;
				}
			}
		}


		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("    DXF_read.c : blocks_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 1;
}





/* -------------------------------------------------------------------
 * entities_section_read
 * ƥƥ
 */
int entities_section_read(FILE *stream, double x, double y)
{
//#define ENTITIES_SECTION_READ
	char org[256];


#ifdef ENTITIES_SECTION_READ
	int debug = 1;
	if (debug > 0) g_print("  DXF_read.c : entities_section_read() : ENTITIES SECTION START\n");
#endif


	while(1) {
		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (ENTITIES SECTION)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			//if (LineRead(stream, org) == 0) return 0;
			entitie_read(stream, x, y);
			return 1;
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * entitie_read
 * ƥƥ
 */
int entitie_read(FILE *stream, double x, double y)
{
//#define ENTITIE_READ
	char org[256];
	int debug = 0;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
	ELLIPSE ellipse;
	INSERT insert;
	SELECT select;


#ifdef ENTITIE_READ
	debug = 1;
	if (debug > 0) g_print("    DXF_read.c : entitie_read() : ENTITIE START\n");
#endif


	while(1) {
		if (LineRead(stream, org) == 0) return 0;

		if (strstr(org,"ENDSEC") != NULL ) {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : ENTITIE (ENDSEC) END\n");
			return 1;
		}

		if (strstr(org,"ENDBLK") != NULL ) {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : ENTITIE (ENDBLK) END\n");
			return 1;
		}

		/* ۾ */
		else if (strstr(org,"EOF") != NULL ) {
			g_print("    CAD DATA ޤ(ENTITIES SECTION)\n");
			return 0;
		}

		/*  */
		else if (strstr(org, "POINT") != NULL && org[0] == 'P') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : POINT\n");
			init_cad(&cad);
			if (DxfPointRead(stream, &cad) == 1) {
				/* select */
				select.index = 2;
				select.diagram_point.cad_point = &cad;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* CAD Data ꥹȤκǽɲ */
				cad_list_add_first(&cad, &cad_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : POINT read error\n");
			}
		}

		/*  */
		else if (strstr(org, "LINE") != NULL && org[0] == 'L') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : LINE\n");
			init_cad(&cad);
			if (DxfLineRead(stream, &cad) == 1) {
				/* select */
				select.index = 2;
				select.diagram_point.cad_point = &cad;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* CAD Data ꥹȤκǽɲ */
				cad_list_add_first(&cad, &cad_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : LINE read error\n");
			}
		}

		/* ߸ */
		else if (strstr(org, "ARC") != NULL && org[0] == 'A') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : ARC\n");
			init_cad(&cad);
			if (DxfArcRead(stream, &cad) == 1) {
				/* select */
				select.index = 2;
				select.diagram_point.cad_point = &cad;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* CAD Data ꥹȤκǽɲ */
				cad_list_add_first(&cad, &cad_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : ARC read error\n");
			}
		}

		/*  */
		else if (strstr(org, "CIRCLE") != NULL && org[0] == 'C') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : CIRCLE\n");
			init_cad(&cad);
			if (DxfCircleRead(stream, &cad) == 1) {
				/* select */
				select.index = 2;
				select.diagram_point.cad_point = &cad;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* CAD Data ꥹȤκǽɲ */
				cad_list_add_first(&cad, &cad_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : CIRCLE read error\n");
			}
		}



		/* ʸ */
		else if (strstr(org, "TEXT") != NULL && org[0] == 'T') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : TEXT\n");
			init_dimension(&dimension);
			if (DxfTextRead(stream, &dimension) == 1) {
				/* select */
				select.index = 3;
				select.diagram_point.dimension_point = &dimension;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* DIMENSION Data ꥹȤκǽɲ */
				dimension_list_add_first(&dimension, &dimension_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : TEXT read error\n");
			}
		}



		/* SOLID (ɤ٤) */
		else if (strstr(org, "SOLID") != NULL && org[0] == 'S') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : SOLID\n");
			init_polyline(&polyline);
			if (DxfSolidRead(stream, &polyline) == 1) {
				/* select */
				select.index = 8;
				select.diagram_point.polyline_point = &polyline;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* POLYLINE Data ꥹȤκǽɲ */
				polyline_list_add_first(&polyline, &polyline_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : SOLID read error\n");
			}
		}

		/* ץ饤 */
		else if (strstr(org, "SPLINE") != NULL && org[0] == 'S') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : SPLINE\n");
			init_polyline(&polyline);
			if (DxfSplineRead(stream, &polyline) == 1) {
				/* select */
				select.index = 8;
				select.diagram_point.polyline_point = &polyline;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* POLYLINE Data ꥹȤκǽɲ */
				polyline_list_add_first(&polyline, &polyline_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : SPLINE read error\n");
			}
		}

		/* ݥ饤 */
		else if (strstr(org, "POLYLINE") != NULL && org[0] == 'P') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : POLYLINE\n");
			init_polyline(&polyline);
			if (DxfPolyLineRead(stream, &polyline) == 1) {
				/* select */
				select.index = 8;
				select.diagram_point.polyline_point = &polyline;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* POLYLINE Data ꥹȤκǽɲ */
				polyline_list_add_first(&polyline, &polyline_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : POLYLINE read error\n");
			}
		}

		/* ʱ */
		else if (strstr(org, "ELLIPSE") != NULL && org[0] == 'E') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : ELLIPSE\n");
			init_ellipse(&ellipse);
			if (DxfEllipseRead(stream, &ellipse) == 1) {
				/* select */
				select.index = 16;
				select.diagram_point.ellipse_point = &ellipse;
				select.x = 0;
				select.y = 0;
				Parallel(&select, x, y);

				/* ELLIPSE Data ꥹȤκǽɲ */
				ellipse_list_add_first(&ellipse, &ellipse_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : ELLIPSE read error\n");
			}
		}


		/* 󥵡 */
		else if (strstr(org, "INSERT") != NULL && org[0] == 'I') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : INSERT\n");
			init_insert(&insert);
			if (DxfInsertRead(stream, &insert) == 1) {

//				g_print("    DXF_read.c : entitie_read() : INSERT split_insert [%s]\n", insert.name);

				/* Ǥʬ򤷤Ͽ */
				split_insert(&insert, &cad_list_info, &dimension_list_info, &polyline_list_info, &ellipse_list_info, x, y);

				/* INSERT Data ꥹȤκǽɲ */
//				insert_list_add_first(&insert, &insert_list_info);

			}
			else {
				g_print("    DXF_read.c : entitie_read() : INSERT read error\n");
			}
		}

		/* ˡ޷ */
		else if (strstr(org, "DIMENSION") != NULL && org[0] == 'D') {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : DIMENSION\n");
			init_insert(&insert);
			if (DxfInsertRead(stream, &insert) == 1) {

//				g_print("    DXF_read.c : entitie_read() : DIMENSION split_insert [%s]\n", insert.name);

				/* Ǥʬ򤷤Ͽ */
				split_insert(&insert, &cad_list_info, &dimension_list_info, &polyline_list_info, &ellipse_list_info, x, y);

				/* INSERT Data ꥹȤκǽɲ */
//				insert_list_add_first(&insert, &insert_list_info);
			}
			else {
				g_print("    DXF_read.c : entitie_read() : DIMENSION read error\n");
			}
		}

		/* ¾ */
		else {
			if (debug > 0) g_print("    DXF_read.c : entitie_read() : ¾ %s\n", org);
			//DxfEtcRead(stream);
		}
	}

	g_print("    DXF_read.c : entitie_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * ǡɤ߹
 * 
 */
int DxfPointRead(FILE *stream, CAD *cad)
{
//#define DXF_POINT_READ
	char org[256], str[256];
	int etc = 0, debug = 0;


#ifdef DXF_POINT_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfPointRead() : POINT start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : %s\n", org);

		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			cad->layer = LayerCh(org);
			cad->style = Layer[cad->layer].style;
			cad->color = Layer[cad->layer].color;
			cad->code = 0;
			/* ɽ & ɽ */
			cad->OnScreen = 1; /* ɽ */

			if (cad->layer > 255) {
				if (debug > 0) g_print("      Error Layer No = %d", cad->layer);
				MsgBox("SagCAD", str, " ", NULL, NULL, "OK");
			}

		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ϥɥֹ (5) %s\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : μ (48) %s\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ǥ֤ȥڡѡ֤ζ (67) %s\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ADE å (90) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ͽˡ (210) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ͽˡ (220) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : ͽˡ (230) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			cad->style = DxfStyleCh(org);
			if (cad->style == -99) cad->style = Layer[cad->layer].style;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() :  (6) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			cad->color = DxfColorCh(atoi(org));
			if (cad->color == 0) 
				cad->color = Layer[cad->layer].color;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() :  (62) %s\n", org);
		}
		/* SX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			cad->sx = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : SX (10) %s\n", org);
		}
		/* SY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			cad->sy = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : SY (20) %s\n", org);
		}
		/* SZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : SZ (30) %s\n", org);
		}
		/* EX */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			cad->ex = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : EX (11) %s\n", org);
		}
		/* EY */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			cad->ey = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : EY (21) %s\n", org);
		}
		/* EZ */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfPointRead() : EZ (31) %s\n", org);
		}
		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print("      DXF_read.c : DxfPointRead() : SX = %f  SY = %f\n", cad->sx, cad->sy);
			if (debug > 0) g_print("      DXF_read.c : DxfPointRead() : POINT end\n");
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPointRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ǡɤ߹
 * 
 */
int DxfLineRead(FILE *stream, CAD *cad)
{
//#define DXF_LINE_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef DXF_LINE_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfLineRead() : LINE start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : %s\n", org);

		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			cad->layer = LayerCh(org);
			cad->style = Layer[cad->layer].style;
			cad->color = Layer[cad->layer].color;
			cad->code = 1;
			/* ɽ & ɽ */
			cad->OnScreen = 1; /* ɽ */
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : 쥤䡼 (8) [%s]\n", org);
		}
		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			cad->style = DxfStyleCh(org);
			if (cad->style == -99) cad->style = Layer[cad->layer].style;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() :  (6) [%s]\n", org);
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ϥɥֹ (5) [%s]\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : μ (48) [%s]\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ADE å (90) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ͽˡ (210) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ͽˡ (220) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : ͽˡ (230) [%s]\n", org);
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			cad->color = DxfColorCh(atoi(org));
			if (cad->color == 0) 
				cad->color = Layer[cad->layer].color;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() :  (62) [%s]\n", org);
		}
		/* SX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			cad->sx = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : SX (10) [%s]\n", org);
		}
		/* SY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			cad->sy = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : SY (20) [%s]\n", org);
		}
		/* SZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : SZ (30) [%s]\n", org);
		}
		/* EX */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			cad->ex = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : EX (11) [%s]\n", org);
		}
		/* EY */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			cad->ey = sg(atof(org), 6);
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : EY (21) [%s]\n", org);
		}
		/* EZ */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() : EZ (31) [%s]\n", org);
		}
		/*  */
		else if (atoi(org) == 39) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfLineRead() :  (39) [%s]\n", org);
		}
		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print(
					"      DXF_read.c : DxfLineRead() : SX = %f  SY = %f  EX = %f  EY = %f\n", 
					cad->sx, cad->sy, cad->ex, cad->ey);
			if (debug > 0) g_print("      DXF_read.c : DxfLineRead() : LINE end\n");
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfLineRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ߸̥ǡɤ߹
 * 
 */
int DxfArcRead(FILE *stream, CAD *cad)
{
//#define DXF_ARC_READ
	double SA = 0, EA = 0;
	char org[256];
	int etc = 0, debug = 0;


#ifdef DXF_ARC_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfArcRead() : ARC start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfArcRead() : %s\n", org);
		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			cad->layer = LayerCh(org);
			cad->style = Layer[cad->layer].style;
			cad->color = Layer[cad->layer].color;
			cad->code = 2;
			/* ɽ & ɽ */
			cad->OnScreen = 1; /* ɽ */
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			cad->style = DxfStyleCh(org);
			if (cad->style == -99) cad->style = Layer[cad->layer].style;
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			cad->color = DxfColorCh(atoi(org));
			if (cad->color == 0) 
				cad->color = Layer[cad->layer].color;
		}
		/* CX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			cad->cx = sg(atof(org), 6);
		}
		/* CY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			cad->cy = sg(atof(org), 6);
		}
		/* CZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* R */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			cad->r = sg(atof(org), 6);
		}
		/* SA */
		else if (atoi(org) == 50) {
			if (LineRead(stream, org) == 0) return 0;
			SA = sg(atof(org), 6);
		}
		/* EA */
		else if (atoi(org) == 51) {
			if (LineRead(stream, org) == 0) return 0;
			EA = sg(atof(org), 6);
		}
		/* END */
		else if (atoi(org) == 0) {
			cad->sx = sg(cad->cx + (cad->r * cos((SA / 360) * 2 * PI)), 6);
			cad->sy = sg(cad->cy + (cad->r * sin((SA / 360) * 2 * PI)), 6);
			cad->ex = sg(cad->cx + (cad->r * cos((EA / 360) * 2 * PI)), 6);
			cad->ey = sg(cad->cy + (cad->r * sin((EA / 360) * 2 * PI)), 6);
			if (debug > 0) g_print(
					"      DXF_read.c : DxfArcRead() : SX = %f  SY = %f  EX = %f  EY = %f  CX = %f  CY = %f  R = %f\n", 
					cad->sx, cad->sy, cad->ex, cad->ey, 
					cad->cx, cad->cy, cad->r);
			if (debug > 0) g_print("      DXF_read.c : DxfArcRead() : ARC end\n");
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfArcRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ߥǡɤ߹
 * 
 */
int DxfCircleRead(FILE *stream, CAD *cad)
{
//#define DXF_CIRCLE_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef DXF_CIRCLE_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfCircleRead() : CIRCLE start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfCircleRead() : %s\n", org);
		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			cad->layer = LayerCh(org);
			cad->style = Layer[cad->layer].style;
			cad->color = Layer[cad->layer].color;
			cad->code = 4;
			/* ɽ & ɽ */
			cad->OnScreen = 1; /* ɽ */
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			cad->style = DxfStyleCh(org);
			if (cad->style == -99) cad->style = Layer[cad->layer].style;
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			cad->color = DxfColorCh(atoi(org));
			if (cad->color == 0) 
				cad->color = Layer[cad->layer].color;
		}
		/* CX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			cad->cx = sg(atof(org), 6);
		}
		/* CY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			cad->cy = sg(atof(org), 6);
		}
		/* CZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* R */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			cad->r = sg(atof(org), 6);
		}
		/* SA */
		else if (atoi(org) == 50) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* EA */
		else if (atoi(org) == 51) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print(
					"      DXF_read.c : DxfCircleRead() : CX = %f  CY = %f  R = %f\n", 
					cad->cx, cad->cy, cad->r);
			if (debug > 0) g_print("      DXF_read.c : DxfCircleRead() : CIRCLE start\n");
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfCircleRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʸǡɤ߹
 * 
 */
int DxfTextRead(FILE *stream, DIMENSION *dimension)
{
//#define DXF_TEXT_READ
	char org[256];
	double scale;
	int etc = 0;
	int debug = 0;


#ifdef DXF_TEXT_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : TEXT start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfTextRead() : %s\n", org);
		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->Layer = LayerCh(org);
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : 쥤䡼 (8) %s ---> %d\n", org, dimension->Layer);
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ϥɥֹ (5) %s\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : μ (48) %s\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ǥ֤ȥڡѡ֤ζ (67) %s\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ADE å (90) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ͽˡ (210) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ͽˡ (220) %s\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ͽˡ (230) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->text_color = DxfColorCh(atoi(org));
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() :  (62) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->SearchPointX = sg(atof(org), 6);
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() :  (10) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->SearchPointY = sg(atof(org), 6);
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() :  (20) %s\n", org);
		}
		/*  */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() :  (30) %s\n", org);
			/* ̵ */
		}
		/* -----------------------------
		 * ֲ碌
		 * 
		 * 0 : 
		 * 1 : 濴
		 * 2 : 
		 * 3 : ()
		 * 4 : ()
		 * 5 : (եå)
		 */
		else if (atoi(org) == 72) {
			if (LineRead(stream, org) == 0) return 0;
			if (atoi(org) < 3) {
				dimension->FitPointX = atoi(org);
				dimension->StartPoint = dimension->StartPoint + atoi(org);
			}
			else if (atoi(org) == 3) {
				dimension->FitPointX = 0;
				dimension->FitPointY = 0;
				dimension->StartPoint = dimension->StartPoint + 0;
			}
			else if (atoi(org) == 4) {
				dimension->FitPointX = 1;
				dimension->FitPointY = 0;
				dimension->StartPoint = dimension->StartPoint + 0;
			}
			else if (atoi(org) == 5) {
				dimension->FitPointX = 0;
				dimension->FitPointY = 0;
				dimension->StartPoint = dimension->StartPoint + 0;
			}
			else {
				dimension->FitPointX = 0;
				dimension->StartPoint = dimension->StartPoint + 1;
			}
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ֲ碌 (72) %s\n", org);
		}
		/* -----------------------------
		 * ֲ碌
		 * 
		 * 0 : 
		 * 1 : 
		 * 2 : 
		 */
		else if (atoi(org) == 73) {
			if (LineRead(stream, org) == 0) return 0;
			if (atoi(org) < 3) {
				dimension->FitPointY = atoi(org);
				dimension->StartPoint = dimension->StartPoint + 0;
			}
			else {
				dimension->FitPointY = 0;
				dimension->StartPoint = dimension->StartPoint + 10;
			}
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ֲ碌 (73) %s\n", org);
		}
		/* ֲ碌 */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			if (dimension->StartPoint != 0) {
				dimension->SearchPointX = sg(atof(org), 6);
			}
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ֲ碌 (11) %s\n", org);
		}
		/* ֲ碌 */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			if (dimension->StartPoint != 0) {
				dimension->SearchPointY = sg(atof(org), 6);
			}
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ֲ碌 (21) %s\n", org);
		}
		/* ֲ碌 */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			if (dimension->StartPoint != 0) {
				/* ̵ */
			}
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ֲ碌 (31) %s\n", org);
		}


		/* ʸ⤵ */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->FontHeight = (float) sg(atof(org), 6);
			scale = (dimension->FontHeight / 9.);
			dimension->FontSpace = sagcad_dimension.Font_space * scale;
			dimension->FontOverLineSpace = sagcad_dimension.Font_space_line * scale;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ʸ⤵ (40) %s\n", org);
		}
		/* ʸ */
		else if (atoi(org) == 1) {
			if (LineRead(stream, org) == 0) return 0;
			strcpy(dimension->Text, org);

			replace(dimension->Text, "%%C", "");
			replace(dimension->Text, "%%c", "");
			replace(dimension->Text, "%%D", "");
			replace(dimension->Text, "%%d", "");
			replace(dimension->Text, "%%O", "");
			replace(dimension->Text, "%%o", "");
			replace(dimension->Text, "%%U", "");
			replace(dimension->Text, "%%u", "");
			replace(dimension->Text, "%%%", "%");
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ʸ (1) %s\n", org);
		}
		/* ž */
		else if (atoi(org) == 50) {
			if (LineRead(stream, org) == 0) return 0;
			dimension->Angle = (float) sg(atof(org), 6);
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ž (50) %s\n", org);
		}

		/* ʸ̾ */
		else if (atoi(org) == 7) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ʸ̾ (7) %s\n", org);
			/* ̵ */
		}
		/* ʸե饰 */
		else if (atoi(org) == 71) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ʸե饰 (71) %s\n", org);
			/* ̵ */
		}
		/* Уؼ */
		else if (atoi(org) == 41) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : Уؼ (41) %s\n", org);
			/* ̵ */
		}
		/* г */
		else if (atoi(org) == 51) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : г (51) %s\n", org);
			/* ̵ */
		}
		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print(
					"      DXF_read.c : DxfTextRead() : TEXT = [%s]  Angle = %f  PointX = %f  PointY = %f\n", 
					dimension->Text, dimension->Angle, dimension->SearchPointX, dimension->SearchPointY);
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : TEXT end\n");
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfTextRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ץ饤ǡɤ߹ (R13j ʹ)
 * 
 */
int DxfSplineRead(FILE *stream, POLYLINE *polyline)
{
//#define DXF_READ_LOG_SPLINE
	char org[256];
	int dummy, pea = 0;
	int etc = 0, debug = 0;
	VERTEX vertex;


#ifdef DXF_READ_LOG_SPLINE
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : SPLINE start\n");
#endif


	/* ץ饤 */
	polyline->code = 16;
	polyline->frag  = 0;


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 1) g_print("      DXF_read.c : DxfSplineRead() : %s\n", org);


		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			polyline->layer = LayerCh(org);
			polyline->style = Layer[polyline->layer].style;
			polyline->color = Layer[polyline->layer].color;
			if (polyline->color == sagcad_color.Back) {
				polyline->color = ~polyline->color;
				polyline->color = polyline->color & 0xffffff;
			}
		}

		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() :  (6) [%s]\n", org);
			polyline->style = DxfStyleCh(org);
			if (polyline->style == -99) polyline->style = Layer[polyline->layer].style;
		}

		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() :  (62) [%s]\n", org);
			polyline->color = DxfColorCh(atoi(org));
			if (polyline->color == 0) 
				polyline->color = Layer[polyline->layer].color;
		}

		/* ץ饤󡦥ե饰 */
		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ饤󡦥ե饰 (70) [%s]\n", org);
			dummy = atoi(org);
			/* 1 : Ĥץ饤 */
			if ((dummy & 1) == 1) {
				polyline->frag = polyline->frag + 1;
			}
			/* 2 : Ūץ饤 */
			else if ((dummy & 2) == 2) {
				polyline->frag = polyline->frag + 2;
			}
			/* 4 : ͭץ饤 */
			else if ((dummy & 4) == 4) {
				polyline->frag = polyline->frag + 4;
			}
			/* 8 : ʿ */
			else if ((dummy & 8) == 8) {
				polyline->frag = polyline->frag + 8;
			}
			/* 16 :  (ʿ̥ӥåȤꤵ) */
			else if ((dummy & 16) == 16) {
				polyline->frag = polyline->frag + 16;
			}
		}

		/* եåο */
		else if (atoi(org) == 74) {
			if (LineRead(stream, org) == 0) return 0;
			polyline->index = atoi(org);
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եåο (74) [%d]\n", polyline->index);
		}

		/* եå X */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			vertex.x = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եå X (11) [%f]\n", vertex.x);
			if (pea == 0) {
				pea = 1;
			}
			else if (pea == 1) {
				/* VERTEX Data ꥹȤκǽɲ */
				vertex_list_add_last(&vertex, &polyline->vertex_list_info);
				if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եå (%f,%f)\n", vertex.x, vertex.y);
				pea = 0;
				vertex.x = 0;
				vertex.y = 0;
			}
		}

		/* եå Y */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			vertex.y = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եå Y (21) [%f]\n", vertex.y);
			if (pea == 0) {
				pea = 1;
			}
			else if (pea == 1) {
				/* VERTEX Data ꥹȤκǽɲ */
				vertex_list_add_last(&vertex, &polyline->vertex_list_info);
				if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եå (%f,%f)\n", vertex.x, vertex.y);
				pea = 0;
				vertex.x = 0;
				vertex.y = 0;
			}
		}

		/* եå Z */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եå Z (31) [%s]\n", org);
		}

		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : SPLINE end\n");
			return 1;
		}










		/* ---------------------------------------
		 * ƥƥ
		 */
		
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ϥɥֹ (5) [%s]\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : μ (48) [%s]\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ADE å (90) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ͽˡ (210) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ͽˡ (220) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ͽˡ (230) [%s]\n", org);
		}
		/* 
		 * ƥƥ
		 * ---------------------------------------
		 */



		/* ---------------------------------------
		 * ץ饤
		 */
		/* ץ饤μ */
		else if (atoi(org) == 71) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ饤μ (71) [%s]\n", org);
		}

		/* ΥåȤο */
		else if (atoi(org) == 72) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ΥåȤο (72) [%s]\n", org);
		}

		/* ο */
		else if (atoi(org) == 73) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ο (73) [%s]\n", org);
		}

		/* եåȵƺ */
		else if (atoi(org) == 42) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եåȵƺ (42) [%s]\n", org);
		}

		/* ƺ */
		else if (atoi(org) == 43) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ƺ (43) [%s]\n", org);
		}

		/* եåȵƺ (եåȡץ饤ξ) */
		else if (atoi(org) == 44) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : եåȵƺ (եåȡץ饤ξ) (44) [%s]\n", org);
		}

		/* ΥåȤ */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ΥåȤ (40) [%s]\n", org);
		}

		/*  X */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() :  X (10) [%s]\n", org);
		}
		/*  Y */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() :  Y (20) [%s]\n", org);
		}
		/*  Z */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() :  Z (30) [%s]\n", org);
		}

		/* ץ  X */
		else if (atoi(org) == 12) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ  X (12) [%s]\n", org);
		}
		/* ץ  Y */
		else if (atoi(org) == 22) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ  Y (22) [%s]\n", org);
		}
		/* ץ  Z */
		else if (atoi(org) == 32) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ  Z (32) [%s]\n", org);
		}

		/* ץ λ X */
		else if (atoi(org) == 13) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ λ X (13) [%s]\n", org);
		}
		/* ץ λ Y */
		else if (atoi(org) == 23) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ λ Y (23) [%s]\n", org);
		}
		/* ץ λ Z */
		else if (atoi(org) == 33) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ץ λ Z (33) [%s]\n", org);
		}
		/* 
		 * ץ饤
		 * ---------------------------------------
		 */



		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSplineRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ݥ饤ǡɤ߹
 * 
 */
int DxfPolyLineRead(FILE *stream, POLYLINE *polyline)
{
//#define DXF_POLYLINE_READ
	int i;
	char org[256];
	VERTEX vertex;

	int dummy = 0;
	double X = 0, Y = 0;
	int etc = 0, debug = 0;


	polyline->code =  8;
	polyline->frag  = 0;


#ifdef DXF_POLYLINE_READ
	debug =1;
	if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : POLYLINE start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : %s\n", org);

		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			polyline->layer = LayerCh(org);
			polyline->style = Layer[polyline->layer].style;
			polyline->color = Layer[polyline->layer].color;
			if (polyline->color == sagcad_color.Back) {
				polyline->color = ~polyline->color;
				polyline->color = polyline->color & 0xffffff;
			}
		}

		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() :  (6) [%s]\n", org);
			polyline->style = DxfStyleCh(org);
			if (polyline->style == -99) polyline->style = Layer[polyline->layer].style;
		}

		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() :  (62) [%s]\n", org);
			polyline->color = DxfColorCh(atoi(org));
			if (polyline->color == 0) 
				polyline->color = Layer[polyline->layer].color;
		}

		/* ݥ饤󡦥ե饰 */
		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ݥ饤󡦥ե饰 (70) [%s] ", org);
			dummy = atoi(org);

			/* Ĥݥ饤 */
			if ((dummy & 1) == 1) {
				polyline->frag = polyline->frag + 1;
				if (debug > 0) g_print("Ĥݥ饤\n");
			}
			/* եåȥ֤ĺɲ */
			else if ((dummy & 2) == 2) {
				polyline->frag = polyline->frag + 2;
				if (debug > 0) g_print("եåȥ֤ĺɲ\n");
			}
			/* ץ饤󥫡֤ĺɲ */
			else if ((dummy & 4) == 4) {
				polyline->frag = polyline->frag + 4;
				if (debug > 0) g_print("եåȥ֤ĺɲ\n");
			}
			/* ݥ饤 */
			else if ((dummy & 8) == 8) {
				polyline->frag = polyline->frag + 8;
				if (debug > 0) g_print("ݥ饤\n");
			}
			/* ¿ѷå */
			else if ((dummy & 16) == 16) {
				polyline->frag = polyline->frag + 16;
				if (debug > 0) g_print("¿ѷå\n");
			}
			/* ĤƤ¿ѷå */
			else if ((dummy & 32) == 32) {
				polyline->frag = polyline->frag + 32;
				if (debug > 0) g_print("ĤƤ¿ѷå\n");
			}
			/* ݥå */
			else if ((dummy & 64) == 64) {
				polyline->frag = polyline->frag + 64;
				if (debug > 0) g_print("ݥå\n");
			}
			/* ѥϢ³ */
			else if ((dummy & 128) == 128) {
				polyline->frag = polyline->frag + 128;
				if (debug > 0) g_print("ѥϢ³\n");
			}
			else {
				if (debug > 0) g_print("\n");
			}
		}

		/* ץ饤 */
		else if (atoi(org) == 75) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ץ饤 (75) [%s]   ", org);
			dummy = atoi(org);

			/* ̵ꡦ̤α߳경 */
			if (dummy == 0) {
				if (debug > 0) g_print("polyline->code = 8\n");
				polyline->code =  8;
			}
			/* ¥ץ饤 */
			else if (dummy == 5) {
				if (debug > 0) g_print("polyline->code = 16\n");
				polyline->code =  16;
			}
			/* ¥ץ饤 */
			else if (dummy == 6) {
				if (debug > 0) g_print("polyline->code = 16\n");
				polyline->code =  16;
			}
			/* ٥ */
			else if (dummy == 8) {
				if (debug > 0) g_print("polyline->code = 8\n");
				polyline->code =  8;
			}
			else {
				if (debug > 0) g_print("polyline->code = 8\n");
			}
		}

		/* END */
		else if (atoi(org) == 0) {
			i = 0;
			while (1) {
				if (LineRead(stream, org) == 0) return 0;

				/* VERTEX ɤߤ */
				if (strstr(org, "VERTEX") != NULL && org[0] == 'V') {
					vertex.x = 0;
					vertex.y = 0;
					if (DxfVertexRead(stream, &vertex) != 0) {
						i++;
						vertex_list_add_last(&vertex, &polyline->vertex_list_info);
						if (i == 1) {
							X = vertex.x;
							Y = vertex.y;
						}
						if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : VERTEX %d (%f,%f)\n", i, vertex.x, vertex.y);
					}
				}


				/* SEQEND (VERTEX end) */
				else if (strstr(org, "SEQEND") != NULL && org[0] == 'S') {
					if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : out\n");
					return 1;
				}
			}
		}












		/* ---------------------------------------
		 * ƥƥ
		 */

		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ϥɥֹ (5) [%s]\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : μ (48) [%s]\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ADE å (90) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ͽˡ (210) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ͽˡ (220) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ͽˡ (230) [%s]\n", org);
		}

		/* 
		 * ƥƥ
		 * ---------------------------------------
		 */





		/* ĺ³ե饰 */
		else if (atoi(org) == 66) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ĺ³ե饰 (66) [%s]\n", org);
		}
		/* ¿ѷåΣĺο */
		else if (atoi(org) == 71) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ¿ѷåΣĺο (71) [%s]\n", org);
		}
		/* ¿ѷåΣĺο */
		else if (atoi(org) == 72) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("       DXF_read.c : DxfPolyLineRead() : ¿ѷåΣĺο (72) [%s]\n", org);
		}
		/* ߳경եΣ̩ */
		else if (atoi(org) == 73) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ߳경եΣ̩ (73) [%s]\n", org);
		}
		/* ߳경եΣ̩ */
		else if (atoi(org) == 74) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ߳경եΣ̩ (74) [%s]\n", org);
		}
		/* SX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : SX (10) [%s]\n", org);
		}
		/* SY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : SY (20) [%s]\n", org);
		}
		/* SZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : SZ (30) [%s]\n", org);
		}
		/*  */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() :  (40) [%s]\n", org);
		}
		/* λ */
		else if (atoi(org) == 41) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : λ (41) [%s]\n", org);
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfPolyLineRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ĺǡɤ߹
 * 
 */
int DxfVertexRead(FILE *stream, VERTEX *vertex)
{
//#define DXF_VERTEX_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef DXF_VERTEX_READ
	debug = 1;
	if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : VERTEX start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : %s\n", org);

		/* END */
		if (atoi(org) == 0) {
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : VERTEX end\n");
			return 1;
		}

		/* EX */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			vertex->x = sg(atof(org), 6);
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : SX (10) %s\n", org);
		}

		/* EY */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			vertex->y = sg(atof(org), 6);
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : SY (20) %s\n", org);
		}

		/* SZ */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : SZ (30) %s\n", org);
		}

		/* ---------------------------------------
		 * ĺե饰 
		 * 16 ʤΤ̵뤷
		 */
		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			/*  */
			if (atoi(org) == 16) {
				return 0;
			}
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : ĺե饰 (70) [%s]\n", org);
		}






		/* 쥤䡼 */
		else if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : 쥤䡼 (8) [%s]\n", org);
		}
		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() :  (6) [%s]\n", org);
		}
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : ϥɥֹ (5) [%s]\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
		}
		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() :  (62) %s\n", org);
		}
		/* դ */
		else if (atoi(org) == 42) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : դ (42) %s\n", org);
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfVertexRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * åɥǡɤ߹ (R13j ʹ)
 * 
 */
int DxfSolidRead(FILE *stream, POLYLINE *polyline)
{
//#define DXF_SOLID_READ
	char org[256];
	int i;
	double x[5],y[5],z[5];
	int etc = 0;
	VERTEX vertex;
	int debug = 0;


#ifdef DXF_SOLID_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfSolidRead() : SOLID start\n");
#endif


	polyline->code  = 8;
	polyline->frag  = 1;


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 0) g_print("      DXF_read.c : DxfSolidRead() : %s\n", org);


		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			polyline->layer = LayerCh(org);
			polyline->style = Layer[polyline->layer].style;
			polyline->color = Layer[polyline->layer].color;
			if (polyline->color == sagcad_color.Back) {
				polyline->color = ~polyline->color;
				polyline->color = polyline->color & 0xffffff;
			}
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 쥤䡼 (8) [%s] ---> [%d]\n", 
								   org, polyline->layer);
		}

		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() :  (6) [%s]\n", org);
			polyline->style = DxfStyleCh(org);
			if (polyline->style == -99) polyline->style = Layer[polyline->layer].style;
		}

		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() :  (62) [%s]\n", org);
			polyline->color = DxfColorCh(atoi(org));
			if (polyline->color == 0) 
				polyline->color = Layer[polyline->layer].color;
		}

		/* 1 ܤĺ X */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			x[0] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 1 ܤĺ X (10) [%s]\n", org);
		}
		/* 1 ܤĺ Y */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			y[0] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 1 ܤĺ Y (20) [%s]\n", org);
		}
		/* 1 ܤĺ Z */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			z[0] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 1 ܤĺ Z (30) [%s]\n", org);
		}

		/* 2 ܤĺ X */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			x[1] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 2 ܤĺ X (11) [%s]\n", org);
		}
		/* 2 ܤĺ Y */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			y[1] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 2 ܤĺ Y (21) [%s]\n", org);
		}
		/* 2 ܤĺ Z */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			z[1] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 2 ܤĺ Z (31) [%s]\n", org);
		}

		/* 3 ܤĺ X */
		else if (atoi(org) == 12) {
			if (LineRead(stream, org) == 0) return 0;
			x[2] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 3 ܤĺ X (12) [%s]\n", org);
		}
		/* 3 ܤĺ Y */
		else if (atoi(org) == 22) {
			if (LineRead(stream, org) == 0) return 0;
			y[2] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 3 ܤĺ Y (22) [%s]\n", org);
		}
		/* 3 ܤĺ Z */
		else if (atoi(org) == 32) {
			if (LineRead(stream, org) == 0) return 0;
			z[2] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 3 ܤĺ Z (32) [%s]\n", org);
		}

		/* 4 ܤĺ X */
		else if (atoi(org) == 13) {
			if (LineRead(stream, org) == 0) return 0;
			x[3] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 4 ܤĺ X (13) [%s]\n", org);
		}
		/* 4 ܤĺ Y */
		else if (atoi(org) == 23) {
			if (LineRead(stream, org) == 0) return 0;
			y[3] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 4 ܤĺ Y (23) [%s]\n", org);
		}
		/* 4 ܤĺ Z */
		else if (atoi(org) == 33) {
			if (LineRead(stream, org) == 0) return 0;
			z[3] = atof(org);
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : 4 ܤĺ Z (33) [%s]\n", org);
		}

		/* END */
		else if (atoi(org) == 0) {
			if (x[2] == x[3] && y[2] == y[3]) {
				polyline->index = 3;
				for (i = 0 ; i < polyline->index ; i++) {
					vertex.x = x[i];
					vertex.y = y[i];
					vertex_list_add_last(&vertex, &polyline->vertex_list_info);
				}
			}
			else {
				polyline->index = 4;
				for (i = 0 ; i < polyline->index ; i++) {
					vertex.x = x[i];
					vertex.y = y[i];
					vertex_list_add_last(&vertex, &polyline->vertex_list_info);
				}
			}
			
			if (debug > 0) g_print("      DXF_read.c : DxfSolidRead() : SOLID end\n");
			return 1;
		}










		/* ---------------------------------------
		 * ƥƥ
		 */
		
		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ϥɥֹ (5) [%s]\n", org);
		}
		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : μ (48) [%s]\n", org);
		}
		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}
		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ADE å (90) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ͽˡ (210) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ͽˡ (220) [%s]\n", org);
		}
		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ͽˡ (230) [%s]\n", org);
		}

		/* 
		 * ƥƥ
		 * ---------------------------------------
		 */



		/* ---------------------------------------
		 * SOLID (ɤ٤) 
		 */
		
		/* ץ  */
		else if (atoi(org) == 39) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("      DXF_read.c : DxfSolidRead() : ץ  (39) [%s]\n", org);
		}

		/* 
		 * SOLID (ɤ٤) 
		 * ---------------------------------------
		 */



		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfSolidRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʱߥǡɤ߹ (R13j ʹ)
 * 
 */
int DxfEllipseRead(FILE *stream, ELLIPSE *ellipse)
{
//#define DXF_ELLIPSE_READ
	int etc = 0, debug = 0;
	char org[256];


#ifdef DXF_ELLIPSE_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ELLIPSE start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : %s\n", org);



		/* ---------------------------------------
		 * ƥƥ
		 */
		
		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->layer = LayerCh(org);
			ellipse->style = Layer[ellipse->layer].style;
			ellipse->color = Layer[ellipse->layer].color;
			if (ellipse->color == sagcad_color.Back) {
				ellipse->color = ~ellipse->color;
				ellipse->color = ellipse->color & 0xffffff;
			}
		}

		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ϥɥֹ (5) [%s]\n", org);
		}

		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() :  (6) [%s]\n", org);
			ellipse->style = DxfStyleCh(org);
			if (ellipse->style == -99) ellipse->style = Layer[ellipse->layer].style;
		}

		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : μ (48) [%s]\n", org);
		}

		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() :  (62) [%s]\n", org);
			ellipse->color = DxfColorCh(atoi(org));
			if (ellipse->color == 0) 
				ellipse->color = Layer[ellipse->layer].color;
		}

		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}

		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ADE å (90) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ͽˡ (210) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ͽˡ (220) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ͽˡ (230) [%s]\n", org);
		}

		/* END */
		else if (atoi(org) == 0) {
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ELLIPSE end\n");
			return 1;
		}
		/* 
		 * ƥƥ
		 * ---------------------------------------
		 */



		/* ---------------------------------------
		 * ELLIPSE 
		 */
		
		/* 濴 X */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->cx = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : 濴 X (10) [%s]\n", org);
		}
		/* 濴 Y */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->cy = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : 濴 Y (20) [%s]\n", org);
		}
		/* 濴 Z */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : 濴 Z (30) [%s]\n", org);
		}


		/* Ĺΰü X (濴Ȥߤʤкɸ) */
		else if (atoi(org) == 11) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->dx = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : Ĺΰü X (11) [%s]\n", org);
		}
		/* Ĺΰü Y (濴Ȥߤʤкɸ) */
		else if (atoi(org) == 21) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->dy = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : Ĺΰü Y (21) [%s]\n", org);
		}
		/* Ĺΰü Z (濴Ȥߤʤкɸ) */
		else if (atoi(org) == 31) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : Ĺΰü Z (31) [%s]\n", org);
		}


		/* ûĹ(ĹĹФΨ) */
		else if (atoi(org) == 40) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->k = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ûĹ (40) [%s]\n", org);
		}

		/* ϳ (饸) */
		else if (atoi(org) == 41) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->sa = raddeg(atof(org));
			angle_check(&ellipse->sa);
			if (sg(ellipse->sa, 3) == 0 || sg(ellipse->sa, 3) == 360) {
				ellipse->sa = 0;
			}
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : ϳ (41) [%s]\n", org);
		}

		/* λ (饸) */
		else if (atoi(org) == 42) {
			if (LineRead(stream, org) == 0) return 0;
			ellipse->ea = raddeg(atof(org));
			angle_check(&ellipse->ea);
			if (sg(ellipse->ea, 3) == 360 || sg(ellipse->ea, 3) == 0) {
				ellipse->ea = 360;
			}
			if (debug > 0) g_print("      DXF_read.c : DxfEllipseRead() : λ (42) [%s]\n", org);
		}

		/* 
		 * ELLIPSE 
		 * ---------------------------------------
		 */



		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfEllipseRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * 󥵡ȥǡɤ߹ (R13j ʹ)
 * 
 */
int DxfInsertRead(FILE *stream, INSERT *insert)
{
//#define DXF_INSERT_READ
	int etc = 0, debug = 0;
	char org[256];


#ifdef DXF_INSERT_READ
	debug = 1;
	if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : INSERT start\n");
#endif


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : %s\n", org);



		/* ---------------------------------------
		 * ƥƥ
		 */
		
		/* 쥤䡼 */
		if (atoi(org) == 8) {
			if (LineRead(stream, org) == 0) return 0;
			insert->layer = LayerCh(org);
			insert->style = Layer[insert->layer].style;
			insert->color = Layer[insert->layer].color;
			if (insert->color == sagcad_color.Back) {
				insert->color = ~insert->color;
				insert->color = insert->color & 0xffffff;
			}
		}

		/* ϥɥֹ */
		else if (atoi(org) == 5) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ϥɥֹ (5) [%s]\n", org);
		}

		/*  */
		else if (atoi(org) == 6) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() :  (6) [%s]\n", org);
			insert->style = DxfStyleCh(org);
			if (insert->style == -99) insert->style = Layer[insert->layer].style;
		}

		/* μ */
		else if (atoi(org) == 48) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : μ (48) [%s]\n", org);
		}

		/*  */
		else if (atoi(org) == 62) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() :  (62) [%s]\n", org);
			insert->color = DxfColorCh(atoi(org));
			if (insert->color == 0) 
				insert->color = Layer[insert->layer].color;
		}

		/* ǥ֤ȥڡѡ֤ζ */
		else if (atoi(org) == 67) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ǥ֤ȥڡѡ֤ζ (67) [%s]\n", org);
		}

		/* ADE å */
		else if (atoi(org) == 90) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ADE å (90) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 210) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ͽˡ (210) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 220) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ͽˡ (220) [%s]\n", org);
		}

		/* ͽˡ */
		else if (atoi(org) == 230) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ͽˡ (230) [%s]\n", org);
		}

		/* END */
		else if (atoi(org) == 0) {
			
			
			
			/* CAD Data ꥹȤκǽɲ */
			//PolyLine_list_add_first(&polyline);
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : INSERT end\n");
			return 1;
		}
		/* 
		 * ƥƥ
		 * ---------------------------------------
		 */



		/* ---------------------------------------
		 * 󥵡
		 */
		
		/* BLOCK NAME */
		else if (atoi(org) == 2) {
			if (LineRead(stream, org) == 0) return 0;
//			if (org[0] == '*') {
//				sprintf(insert->name, "%s", &org[1]);
//			}
//			else {
				sprintf(insert->name, "%s", org);
//			}
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : BLOCK NAME (2) [\"%s\"]\n", org);
		}

		/*  X */
		else if (atoi(org) == 10) {
			if (LineRead(stream, org) == 0) return 0;
			if (insert->name[0] == '*' && insert->name[1] == 'D') {
				insert->x = 0;
			}
			else {
				insert->x = atof(org);
			}
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() :  X (10) [%s]\n", org);
		}
		/*  Y */
		else if (atoi(org) == 20) {
			if (LineRead(stream, org) == 0) return 0;
			if (insert->name[0] == '*' && insert->name[1] == 'D') {
				insert->y = 0;
			}
			else {
				insert->y = atof(org);
			}
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() :  Y (20) [%s]\n", org);
		}
		/*  Z */
		else if (atoi(org) == 30) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() :  Z (30) [%s]\n", org);
		}


		/* μ */
		else if (atoi(org) == 41) {
			if (LineRead(stream, org) == 0) return 0;
			insert->x_scale = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : μ (41) [%s]\n", org);
		}

		/* μ */
		else if (atoi(org) == 42) {
			if (LineRead(stream, org) == 0) return 0;
			insert->y_scale = atof(org);
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : μ (42) [%s]\n", org);
		}

		/* μ */
		else if (atoi(org) == 43) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : μ (43) [%s]\n", org);
		}

		/* ž */
		else if (atoi(org) == 50) {
			if (LineRead(stream, org) == 0) return 0;
			if (insert->name[0] == '*' && insert->name[1] == 'D') {
				insert->angle = 0;
			}
			else {
				insert->angle = atof(org);
			}
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ž (50) [%s]\n", org);
		}





		/* ο */
		else if (atoi(org) == 70) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : ο (70) [%s]\n", org);
			insert->x_num = atoi(org);
		}

		/* Ԥο */
		else if (atoi(org) == 71) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : Ԥο (71) [%s]\n", org);
			insert->y_num = atoi(org);
		}

		/* δֳ */
		else if (atoi(org) == 44) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : δֳ (44) [%s]\n", org);
			insert->x_pitch = atof(org);
		}

		/* Ԥδֳ */
		else if (atoi(org) == 45) {
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfInsertRead() : Ԥδֳ (45) [%s]\n", org);
			insert->y_pitch = atof(org);
		}

		/* 
		 * 󥵡
		 * ---------------------------------------
		 */



		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("        DXF_read.c : DxfInsertRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ¾Υǡɤ߹
 * 
 */
int DxfEtcRead(FILE *stream)
{
	char org[256];
	int etc = 0, debug = 0;


	while (1) {
		if (LineRead(stream, org) == 0) return 0;
		/* END */
		if (atoi(org) == 0) {
			return 1;
		}
		/* ¾ */
		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 0) g_print("      DXF_read.c : DxfEtcRead() : ¾ (%d) [%s]\n", etc, org);
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * objects_section_read
 * ֥ȥ
 */
int objects_section_read(FILE *stream)
{
//#define OBJECTS_SECTION_READ
	char org[256];
	int etc = 0, debug = 0;


#ifdef OBJECTS_SECTION_READ
	debug = 1;
	if (debug > 0) g_print("  DXF_read.c : objects_section_read() : OBJECTS SECTION START\n");
#endif

	while (1) {
		if (LineRead(stream, org) == 0) {
			g_print("  FILE Data Error (OBJECTS SECTION)\n");
			return 0;
		}

		if (atoi(org) == 0) {
			if (LineRead(stream, org) == 0) return 0;

			if (strstr(org,"ENDSEC") != NULL ) {
				if (debug > 0) g_print("  DXF_read.c : objects_section_read() : OBJECTS SECTION END\n");
				return 1;
			}
		}

		else {
			etc = atoi(org);
			if (LineRead(stream, org) == 0) return 0;
			if (debug > 1) g_print("  DXF_read.c : objects_section_read() : ¾ (%d) [%s]\n", etc, org);
		}
	}

	if (debug > 0) g_print("  DXF_read.c : objects_section_read() : ۾ｪλ\n");
	return 0;
}





/* -------------------------------------------------------------------
 * DxfStyleCh
 * 
 * DXF  SagCAD ѹ
 * 
 */
int DxfStyleCh(char *Style)
{
//#define DXFSTYLECH
/* CONTINUOUS  HIDDEN2	CENTER2  PHANTOM2 */

	int debug = 0;


#ifdef DXFSTYLECH
	debug = 1;
#endif


	/* CONTINUOUS */
	if (strstr(Style,"CONTINUOUS") != NULL ) {
		return 1;
	}
	/* SOLID */
	else if (strstr(Style,"SOLID") != NULL ) {
		return 1;
	}


	/* CENTER */
	else if (strstr(Style,"CENTER") != NULL ) {
		return 3;
	}
	/* DASHDOT */
	else if (strstr(Style,"DASHDOT") != NULL ) {
		return 3;
	}


	/* HIDDEN */
	else if (strstr(Style,"HIDDEN") != NULL ) {
		return 2;
	}
	/* DASHE */
	else if (strstr(Style,"DASHE") != NULL ) {
		return 2;
	}
	/* DASHED */
	else if (strstr(Style,"DASHED") != NULL ) {
		return 2;
	}
	/* DOT */
	else if (strstr(Style,"DOT") != NULL ) {
		return 2;
	}


	/* PHANTOM */
	else if (strstr(Style,"PHANTOM") != NULL ) {
		return 4;
	}
	/* DIVIDE */
	else if (strstr(Style,"DIVIDE") != NULL ) {
		return 4;
	}


	/* BYBLOCK */
	else if (strstr(Style,"BYBLOCK") != NULL ) {
		return -99;
	}




	/* ¾ */
	else {
		if (debug > 0) g_print("      DXF_read.c : DxfStyleCh() : ꤵƤʤ Line Style = %s\n", Style);
		return 1;
	}
}





/* -------------------------------------------------------------------
 * LayerCh
 * 
 */
int LayerCh(char *Lay)
{
	int i;

	for(i = 1 ; i<= DxfLayerIndex ; i++) {
		if (strstr(Lay, Layer[i].name) != NULL ) {
			return i;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * DXF_Info
 * 
	GLOBAL int DxfLayerIndex;
 */
void DXF_Info(void)
{
	int i;
	char str[256];


	sprintf(str, "-----------------------------------------\n");
	OneShotLog(str);
	sprintf(str, "The result that SagCAD analyzed DXF file.\n");
	OneShotLog(str);
	sprintf(str, "DXF version [ %s ]\n", DxfVersion);
	OneShotLog(str);
	
	if (DxfLayerIndex > 0) {
		for (i = 0 ; i <= DxfLayerIndex ; i++) {
			sprintf(str, "Layer %d = [%s]   color = 0x%x   style = %d\n", 
				i, Layer[i].name, (int)Layer[i].color, Layer[i].style);
			OneShotLog(str);
		}
	}
	sprintf(str, "-----------------------------------------\n");
	OneShotLog(str);
	return;
}





/* -------------------------------------------------------------------
 * DxfColorCh
 * 
 * DXF Υ顼 SagCAD Υ顼ѹ
 * 
 */
long DxfColorCh(long DxfColor)
{
	long color;
	static const long colormap[257]=
	{
		0x000000,	// color 0	Black, also By Block
		0xff0000,	// color 1	Red
		0xffff00,	// color 2	Yellow
		0x00ff00,	// color 3	Green
		0x00ffff,	// color 4	Cyan
		0x0000ff,	// color 5	Blue
		0xff00ff,	// color 6	Magenta
		0xffffff,	// color 7	White
		0x989898,	// color 8	Grey
		0xC0C0C0,	// color 9
		0xff0000,	// color 10
		0xff8080,	// color 11
		0xa60000,	// color 12
		0xa65353,	// color 13
		0x800000,	// color 14
		0x804040,	// color 15
		0x4c0000,	// color 16
		0x4c2626,	// color 17
		0x260000,	// color 18
		0x261313,	// color 19
		0xff4000,	// color 20
		0xff9f80,	// color 21
		0xa62900,	// color 22
		0xa66853,	// color 23
		0x802000,	// color 24
		0x805040,	// color 25
		0x4c1300,	// color 26
		0x4c3026,	// color 27
		0x260a00,	// color 28
		0x261813,	// color 29
		0xff8000,	// color 30
		0xffbf80,	// color 31
		0xa65300,	// color 32
		0xa67c53,	// color 33
		0x804000,	// color 34
		0x806040,	// color 35
		0x4c2600,	// color 36
		0x4c3926,	// color 37
		0x261300,	// color 38
		0x261d13,	// color 39
		0xffbf00,	// color 40
		0xffdf80,	// color 41
		0xa67c00,	// color 42
		0xa69153,	// color 43
		0x806000,	// color 44
		0x807040,	// color 45
		0x4c3900,	// color 46
		0x4c4326,	// color 47
		0x261d00,	// color 48
		0x262113,	// color 49
		0xffff00,	// color 50
		0xffff80,	// color 51
		0xa6a600,	// color 52
		0xa6a653,	// color 53
		0x808000,	// color 54
		0x808040,	// color 55
		0x4c4c00,	// color 56
		0x4c4c26,	// color 57
		0x262600,	// color 58
		0x262613,	// color 59
		0xbfff00,	// color 60
		0xdfff80,	// color 61
		0x7ca600,	// color 62
		0x91a653,	// color 63
		0x608000,	// color 64
		0x708040,	// color 65
		0x394c00,	// color 66
		0x434c26,	// color 67
		0x1d2600,	// color 68
		0x212613,	// color 69
		0x80ff00,	// color 70
		0xbfff80,	// color 71
		0x53a600,	// color 72
		0x7ca653,	// color 73
		0x408000,	// color 74
		0x608040,	// color 75
		0x264c00,	// color 76
		0x394c26,	// color 77
		0x132600,	// color 78
		0x1d2613,	// color 79
		0x40ff00,	// color 80
		0x9fff80,	// color 81
		0x29a600,	// color 82
		0x68a653,	// color 83
		0x208000,	// color 84
		0x508040,	// color 85
		0x134c00,	// color 86
		0x304c26,	// color 87
		0x0a2600,	// color 88
		0x182613,	// color 89
		0x00ff00,	// color 90
		0x80ff80,	// color 91
		0x00a600,	// color 92
		0x53a653,	// color 93
		0x008000,	// color 94
		0x408040,	// color 95
		0x004c00,	// color 96
		0x264c26,	// color 97
		0x002600,	// color 98
		0x132613,	// color 99
		0x00ff40,	// color 100
		0x80ff9f,	// color 101
		0x00a629,	// color 102
		0x53a668,	// color 103
		0x008020,	// color 104
		0x408050,	// color 105
		0x004c13,	// color 106
		0x264c30,	// color 107
		0x00260a,	// color 108
		0x132618,	// color 109
		0x00ff80,	// color 110
		0x80ffbf,	// color 111
		0x00a653,	// color 112
		0x53a67c,	// color 113
		0x008040,	// color 114
		0x408060,	// color 115
		0x004c26,	// color 116
		0x264c39,	// color 117
		0x002613,	// color 118
		0x13261d,	// color 119
		0x00ffbf,	// color 120
		0x80ffdf,	// color 121
		0x00a67c,	// color 122
		0x53a691,	// color 123
		0x008060,	// color 124
		0x408070,	// color 125
		0x004c39,	// color 126
		0x264c43,	// color 127
		0x00261d,	// color 128
		0x132621,	// color 129
		0x00ffff,	// color 130
		0x80ffff,	// color 131
		0x00a6a6,	// color 132
		0x53a6a6,	// color 133
		0x008080,	// color 134
		0x408080,	// color 135
		0x004c4c,	// color 136
		0x264c4c,	// color 137
		0x002626,	// color 138
		0x132626,	// color 139
		0x00bfff,	// color 140
		0x80dfff,	// color 141
		0x007ca6,	// color 142
		0x5391a6,	// color 143
		0x006080,	// color 144
		0x407080,	// color 145
		0x00394c,	// color 146
		0x26434c,	// color 147
		0x001d26,	// color 148
		0x132126,	// color 149
		0x0080ff,	// color 150
		0x80bfff,	// color 151
		0x0053a6,	// color 152
		0x537ca6,	// color 153
		0x004080,	// color 154
		0x406080,	// color 155
		0x00264c,	// color 156
		0x26394c,	// color 157
		0x001326,	// color 158
		0x131d26,	// color 159
		0x0040ff,	// color 160
		0x809fff,	// color 161
		0x0029a6,	// color 162
		0x5368a6,	// color 163
		0x002080,	// color 164
		0x405080,	// color 165
		0x00134c,	// color 166
		0x26304c,	// color 167
		0x000a26,	// color 168
		0x131826,	// color 169
		0x0000ff,	// color 170
		0x8080ff,	// color 171
		0x0000a6,	// color 172
		0x5353a6,	// color 173
		0x000080,	// color 174
		0x404080,	// color 175
		0x00004c,	// color 176
		0x26264c,	// color 177
		0x000026,	// color 178
		0x131326,	// color 179
		0x4000ff,	// color 180
		0x9f80ff,	// color 181
		0x2900a6,	// color 182
		0x6853a6,	// color 183
		0x200080,	// color 184
		0x504080,	// color 185
		0x13004c,	// color 186
		0x30264c,	// color 187
		0x0a0026,	// color 188
		0x181326,	// color 189
		0x8000ff,	// color 190
		0xbf80ff,	// color 191
		0x5300a6,	// color 192
		0x7c53a6,	// color 193
		0x400080,	// color 194
		0x604080,	// color 195
		0x26004c,	// color 196
		0x39264c,	// color 197
		0x130026,	// color 198
		0x1d1326,	// color 199
		0xbf00ff,	// color 200
		0xdf80ff,	// color 201
		0x7c00a6,	// color 202
		0x9153a6,	// color 203
		0x600080,	// color 204
		0x704080,	// color 205
		0x39004c,	// color 206
		0x43264c,	// color 207
		0x1d0026,	// color 208
		0x211326,	// color 209
		0xff00ff,	// color 210
		0xff80ff,	// color 211
		0xa600a6,	// color 212
		0xa653a6,	// color 213
		0x800080,	// color 214
		0x804080,	// color 215
		0x4c004c,	// color 216
		0x4c264c,	// color 217
		0x260026,	// color 218
		0x261326,	// color 219
		0xff00bf,	// color 220
		0xff80df,	// color 221
		0xa6007c,	// color 222
		0xa65391,	// color 223
		0x800060,	// color 224
		0x804070,	// color 225
		0x4c0039,	// color 226
		0x4c2643,	// color 227
		0x26001d,	// color 228
		0x261321,	// color 229
		0xff0080,	// color 230
		0xff80bf,	// color 231
		0xa60053,	// color 232
		0xa6537c,	// color 233
		0x800040,	// color 234
		0x804060,	// color 235
		0x4c0026,	// color 236
		0x4c2639,	// color 237
		0x260013,	// color 238
		0x26131d,	// color 239
		0xff0040,	// color 240
		0xff809f,	// color 241
		0xa60029,	// color 242
		0xa65368,	// color 243
		0x800020,	// color 244
		0x804050,	// color 245
		0x4c0013,	// color 246
		0x4c2630,	// color 247
		0x26000a,	// color 248
		0x261318,	// color 249
		0x545454,	// color 250
		0x767676,	// color 251
		0x989898,	// color 252
		0xbbbbbb,	// color 253
		0xdddddd,	// color 254
		0xffffff,	// color 255
		0x000000 	// color 256 Black, also by By Layer
	};

	DxfColor = abs(DxfColor);
	color = colormap[DxfColor];

	if (color == sagcad_color.Back) {
		color = ~color;
		color = color & 0xffffff;
	}
	return color;
}





/* ====================================================================
 * ===	Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *	  Project			   : SagCAD
 *	  Source			   : DXF_read.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * 󥵡ȥǡǤʬ
 * 
 */
int split_insert(INSERT *insert, 
				 CAD_LIST_INFO *p_cad_list_info, 
				 DIMENSION_LIST_INFO *p_dimension_list_info, 
				 POLYLINE_LIST_INFO *p_polyline_list_info, 
				 ELLIPSE_LIST_INFO *p_ellipse_list_info, 
				 double x, 
				 double y
				 )
{
	int i;
	BLOCK_LIST *pbl;
		CAD_LIST *pc;
		DIMENSION_LIST *pd;
		POLYLINE_LIST *pp;
//		ELLIPSE_LIST *pe;

	SELECT select;
	CAD cad;
	DIMENSION dimension;
	POLYLINE polyline;
//	ELLIPSE ellipse;

//	VERTEX_LIST *v;
//	VERTEX vertex;


//	g_print("DXF_read.c : split_insert() : BLOCK NAME [%s]\n", insert->name);


	/* BLOCK̾ŪBLOCKõ */
	pbl = block_search_block_name(insert->name, &block_list_info);
	if (pbl != NULL) {
		/* BLOCK  CAD ǡ CAD_LIST_INFO Ͽ */
		pc = pbl->block->cad_list_info.head;
		while (pc != NULL) {
			init_cad(&cad);
			cad = *pc->cad;
			select.index = 2;
			select.diagram_point.cad_point = &cad;
			if (cad.color == Layer[cad.layer].color && cad.layer == 0) {
				cad.color = Layer[insert->layer].color;
			}
			if (cad.style == Layer[cad.layer].style && cad.layer == 0) {
				cad.style = Layer[insert->layer].style;
			}
			cad.layer = insert->layer;

			Parallel(&select, insert->x + x, insert->y + y);
			Rotation(&select, insert->x, insert->y, insert->angle);
			ScalingXY(&select, insert->x, insert->y, insert->x_scale, insert->y_scale);

			/* CAD Data ꥹȤκǽɲ */
			cad_list_add_first(&cad, p_cad_list_info);

			pc = pc->next;
		}



		/* BLOCK  DIMENSION ǡ DIMENSION_LIST_INFO Ͽ */
		pd = pbl->block->dimension_list_info.head;
		while (pd != NULL) {
			init_dimension(&dimension);
			dimension = *pd->dimension;
			select.index = 3;
			select.diagram_point.dimension_point = &dimension;

			dimension.Layer = insert->layer;

			if (dimension.index > 0) {
				dimension.AssistLine = NULL;
				/* ǡ (LIST) 񤭹िΰݤ */
				dimension.AssistLine = (ASSISTANCE *)xmalloc(dimension.index * sizeof(ASSISTANCE));
				for (i = 0 ; i < dimension.index ; i++) {
					dimension.AssistLine[i] = pd->dimension->AssistLine[i];
				}
			}

			Parallel(&select, insert->x + x, insert->y + y);
			Rotation(&select, insert->x, insert->y, insert->angle);
			ScalingXY(&select, insert->x, insert->y, insert->x_scale, insert->y_scale);

			/* DIMENSION Data ꥹȤκǽɲ */
			dimension_list_add_first(&dimension, p_dimension_list_info);

			pd = pd->next;
		}



		/* BLOCK  POLYLINE ǡ POLYLINE_LIST_INFO Ͽ */
		pp = pbl->block->polyline_list_info.head;
		while (pp != NULL) {
//			g_print("DXF_read.c : split_insert() : POLYLINE\n");
			init_polyline(&polyline);
			polyline = *pp->polyline;
			select.index = 8;
			select.diagram_point.polyline_point = &polyline;

			if (polyline.color == Layer[polyline.layer].color && polyline.layer == 0) {
				polyline.color = Layer[insert->layer].color;
			}
			if (polyline.style == Layer[polyline.layer].style && polyline.layer == 0) {
				polyline.style = Layer[insert->layer].style;
			}
			polyline.layer = insert->layer;

//g_print("DXF_read.c : split_insert() : POLYLINE vertex copy\n");

			copy_vertex_list_info(&pp->polyline->vertex_list_info, &polyline.vertex_list_info);

//g_print("----- org -----\n");
//vertex_list_print(&pp->polyline->vertex_list_info);
//g_print("----- cpy -----\n");
//vertex_list_print(&polyline.vertex_list_info);


#ifdef TEST
			/* BLOCK  CAD ǡ CAD_LIST_INFO Ͽ */
			v = pp->polyline->vertex_list_info.head;
			while (v != NULL) {
				vertex = *v->vertex;
				vertex_list_add_last(&vertex, &polyline.vertex_list_info);
				v = v->next;
			}
#endif

//g_print("DXF_read.c : split_insert() : POLYLINE Parallel\n");
			Parallel(&select, insert->x + x, insert->y + y);
//g_print("----- Parallel -----\n");
//vertex_list_print(&polyline.vertex_list_info);


//g_print("DXF_read.c : split_insert() : POLYLINE Rotation\n");
			Rotation(&select, insert->x, insert->y, insert->angle);
//g_print("----- Rotation -----\n");
//vertex_list_print(&polyline.vertex_list_info);


//			Scaling(&select, X, Y, xScale);
//g_print("DXF_read.c : split_insert() : POLYLINE ScalingXY\n");
			ScalingXY(&select, insert->x, insert->y, insert->x_scale, insert->y_scale);
//g_print("----- ScalingXY -----\n");
//vertex_list_print(&polyline.vertex_list_info);


			/* POLYLINE Data ꥹȤκǽɲ */
			polyline_list_add_first(&polyline, p_polyline_list_info);

			pp = pp->next;
		}
	}
	else if (pbl == NULL) {
		g_print("DXF_read.c : split_insert() : BLOCK NAME UNKNOWN [%s]\n", insert->name);
	}


	return 0;
}




/* -------------------------------------------------------------------
 * CAD_LIST_INFO_1  CAD_LIST_INFO_2 ˥ԡ
 * 
 */
int copy_cad_list_info(CAD_LIST_INFO *org_cad_list_info, CAD_LIST_INFO *cpy_cad_list_info)
{
	CAD_LIST *pc;
	CAD cad;


	/* BLOCK  CAD ǡ CAD_LIST_INFO Ͽ */
	pc = org_cad_list_info->head;
	while (pc != NULL) {
		cad = *pc->cad;
		cad_list_add_first(&cad, cpy_cad_list_info);
		pc = pc->next;
	}
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DXF_read.c
 * ====================================================================
 */
