/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Line_dlg.h"
#define LINESTYLEBOX
#include "LineStyleBox.h"



/*
 * ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * "expose ()" ٥ȥϥɥ
 */
gint ls_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	gint w, h;

	/* ɥ󥰥쥢礭 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	/* ط */
	PenSet(ls_gc, 1, 0x0000);
	gdk_draw_rectangle (widget->window, ls_gc, TRUE, 0, 0, w, h);

	/* ߤɽ */
	PenSet_with_back(ls_gc, NowStyle, NowColor, sagcad_color.Back);
	gdk_draw_line(widget->window, ls_gc, 0, h/2, w, h/2);
	return FALSE;
}



/*
 * ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * "button_press (å)" ٥ȥϥɥ
 */
gint ls_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	int style;
	long color;
	GdkRectangle update_rect;

	style = NowStyle;
	color = NowColor;

	/* ܥ */
	if (event->button == 1) {
		Line_set_dlg(&style, &color);

		NowStyle = style;
		NowColor = color;

		update_rect.x = 0;
		update_rect.y = 0;
		/* ɥ󥰥쥢礭 */
		update_rect.width = widget->allocation.width;
		update_rect.height = widget->allocation.height;
//		gdk_draw_rectangle (pixmap, widget->style->black_gc, TRUE, update_rect.x, update_rect.y,
//						update_rect.width, update_rect.height);
		gtk_widget_draw (widget, &update_rect);
//			gtk_widget_draw (widget, GdkRectangle *area);
//			g_print("style = %d\n", style);
//			g_print("color = %x\n", color);
	}

	return TRUE;
}



/*
 * ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 */
GtkWidget *create_line_style_box(void)
{
	GtkWidget *line_style_box;

  /** ɥ󥰥ꥢ **/
  line_style_box = gtk_drawing_area_new();
  /** ɥ󥰥ꥢΥ **/
  gtk_drawing_area_size( GTK_DRAWING_AREA(line_style_box), 100, 18);
  /** "expose_event"٥ȥϥɥ **/
  gtk_signal_connect(GTK_OBJECT(line_style_box), "expose_event",
			 (GtkSignalFunc) ls_expose_event, NULL);
  /** "button_press_event"٥ȥϥɥ **/
  gtk_signal_connect(GTK_OBJECT(line_style_box), "button_press_event",
			 (GtkSignalFunc) ls_button_press_event, NULL);
  /** ٥ȥޥ **/
  gtk_widget_set_events(line_style_box, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  return line_style_box;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * ====================================================================
 */
