/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Block.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/15
 *    Last                 : 2003/03/23
 * ====================================================================
 */
#ifndef __LIST_BLOCK_H__
#define __LIST_BLOCK_H__

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_BLOCK_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL BLOCK_LIST *p_block_list;
	GLOBAL BLOCK_LIST_INFO block_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_BLOCK_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int init_block(BLOCK *block);
/*  */
BLOCK_LIST *r_block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data ꥹȤκǽɲ */
BLOCK_LIST *block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data ꥹȤκǽɲäơ Undo Baffer ˽ */
BLOCK_LIST *block_list_add_first_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);


/* BLOCK Data ꥹȤκǸɲ */
BLOCK_LIST *block_list_add_last(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data ꥹȤκǸɲá Undo Baffer ˽ */
BLOCK_LIST *block_list_add_last_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data κǽ (κǤϤʤ) */
int block_list_delete(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data ꥹȤκǸɲá Undo Baffer ˽ */
int block_list_delete_Undo(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data ѹ */
BLOCK_LIST *block_list_edit(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data ѹ롢 Undo Baffer ˽ */
BLOCK_LIST *block_list_edit_with_undo(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info);

/* ꥹȤĴ٤ */
long block_list_num(BLOCK_LIST_INFO *p_block_list_info);
/* n ܤΥǡθ */
BLOCK_LIST *block_search_num(long search_number, BLOCK_LIST_INFO *p_block_list_info);
/* ǡθ(BLOCK *p_block  BLOCK_LIST ) */
BLOCK_LIST *block_search_block(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Υǡθ (name  BLOCK_LIST ) */
BLOCK_LIST *block_search_block_name(char *name, BLOCK_LIST_INFO *p_block_list_info);
/* ǡθ(BLOCK *p_block  Data No.  long ͤ) */
long block_search_block_to_num(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data ꥹȤ */
int block_list_free(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);
/* ꥹȤ */
void block_list_all_free(BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK_LIST Υǡ log */
void block_list_log(BLOCK_LIST_INFO *p_block_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_BLOCK_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Block.h
 * ====================================================================
 */
