/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_font.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __LIST_FONT_H__
#define __LIST_FONT_H__

//#include <>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
/* --- < list_font.c ƤФ줿Ȥ > --------------------- */
#ifdef _LIST_FONT_ 
	SAG_FONT_LIST *p_font_list;
	SAG_FONT_LIST_INFO font_list_info;



/* --- < list_font.c ʳƤФ줿Ȥ > ----------------- */
#else 
	extern SAG_FONT_LIST *p_font_list;
	extern SAG_FONT_LIST_INFO font_list_info;



#endif /* _LIST_FONT_ */
#undef _LIST_FONT_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* SAG_FONT Data ꥹȤκǸɲ */
SAG_FONT_LIST *font_list_add_last(SAG_FONT *add_font);
/* SAG_FONT Data ꥹȤ */
int font_list_free(SAG_FONT_LIST *del_List);
/* ꥹȤ */
void font_list_all_free(void);


/* SagCAD Font Type (sft File) Υǡɤ߹ */
int sft_file_read(FILE *stream);
int ScalingFont(SAG_FONT_DATA *font_data, double x, double y, double k);
SAG_FONT *sft_char_read(FILE *stream, char *str);
/* QCad Font Type (cxf File) Υǡɤ߹ */
int cxf_file_read(FILE *stream);
SAG_FONT *cxf_char_read(FILE *stream, char *str);


/* ʸΥեȥǡɤߤ (Ū) */
int font_open(char *font_file);
/* ʸΥեȥǡɤߤ (ưŪ) */
SAG_FONT *font_search_open(char *moji, char *font_file2);

/* ʸΥǡõ */
SAG_FONT *font_search(char *moji, char *font_file2);
/* moji 򡩤Ȥɽ褦Ͽ */
SAG_FONT *not_find_font(char *moji);

/* ʸɤμ̤Ƚꤹ */
int whatKanji_sjis(/* unsigned */ char *str);
int whatKanji_euc(/*unsigned */ char *str);

/*  */
void font_list_print(void);

double CulcTextVector (GtkWidget *widget, DIMENSION *a);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_FONT_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_font.h
 * ====================================================================
 */
