/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : global.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/09/11
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_insert.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "Trace.h"
#include "MsgBox.h"
#include "sagcad.h"
#define _GLOBAL_
#include "global.h"
#include "etc.h"


//#ifdef WIN32
//#define   COLOR_INIT(v)  Color_RB_Change(v)
//#else
#define   COLOR_INIT(v)  (v)
//#endif


int sagcad_global_init(void)
{
	int i;
	char home[256];
	CAD cad;


	/* sagcad_user */
	strcpy(sagcad_user.UserName, "Your Name");
	strcpy(sagcad_user.CompanyName, "Your Company");


	/* ɤμ */
	Get_charset();
#ifdef DEBUG
	if (Get_charset() == 1) g_print("charset = euc\n");
	else g_print("charset = sjis\n");
#endif
	/* եΥѥμ */
	GetConfigPath(sagcad_user.ConfigPath);

	strcpy(sagcad_user.BrowserPath, "netscape");
	home_of_user(home);
	strcpy(sagcad_user.CadPath, home);
	strcpy(sagcad_user.KeepCadPath, home);
	strcpy(sagcad_user.NcPath, "CADPATH");

	strcpy(sagcad_user.browser_command, "netscape %s");
	strcpy(sagcad_user.editor_command, "kterm -e vi %s");
	strcpy(sagcad_user.print_command, "lpr %s");



	/* system */
	sagcad_system.Wait = 100;			/* 100 */
//	sagcad_system.MaxLayer = 100;		/* 100 */
	sagcad_system.LostCurrent = 0;		/* 1 */
	sagcad_system.RealTimeLayerSet = 1;	/* 1 */
	sagcad_system.GridMode = 0;			/* 0 */

	/* ԥ㡼ܥåΥڥ (ASPECT = H / W) */
	sagcad_system.ViewX = 300;
	sagcad_system.DeviceX = 0;
	sagcad_system.DeviceY = 0;
	sagcad_system.Aspect = 0;

	sagcad_system.WinMode = 0;			/* 1: */
	sagcad_system.win_width = 800;//gdk_screen_width() * 0.8;
	sagcad_system.win_height = 600;//gdk_screen_height() * 0.8;
	sagcad_system.win_x_pos = (gdk_screen_width() - sagcad_system.win_width) / 2;
	sagcad_system.win_y_pos = (gdk_screen_height() - sagcad_system.win_height) / 2;

	sagcad_system.ZoomMag = (float) 1.5;			/* 1.3 */
	sagcad_system.Splits = 15;						/* 15 */
	sagcad_system.Search = 2;						/* 2 */
	sagcad_system.ScrollPitch = 50;					
	sagcad_system.Length = 50;						/* 50 */
	sagcad_system.FilletRC = 10;					/* 10 */
	sagcad_system.Grid = (float) 0.5;				/* 0.5 */

	/* sagcad_dimension */
	sagcad_dimension.Draw_Type = DRAW_REAL;			/* 0  0:̤ν̼	1:	2:ʸ */
	sagcad_dimension.font_Type = 1;					/* 1  1:٥ȥ   0:TrueType */
	sagcad_dimension.Font_height = (float) 3.2;		/* 3.2 */
	sagcad_dimension.Font_space = 2;				/* 0 */
	sagcad_dimension.Word_space = 8;				/* 0 */
	sagcad_dimension.Font_space_line = (float) 0.625;	/* 0 */
	sagcad_dimension.arrow_length = 3;				/* 2 */
	sagcad_dimension.arrow_angle = 10;				/* 15 */
	sagcad_dimension.arrow_line_extension = 5;		/* 3 */
	sagcad_dimension.assistance_line_extension = 0.625;	/* 1 */
	sagcad_dimension.assistance_line_space = 0.625;		/* 1 */
	sagcad_dimension.dimension_figure = 3;			/* 3 */

	strcpy(sagcad_dimension.font_file, "normal.cxf");		/* sagfont.sft */
	strcpy(sagcad_dimension.font_file2, "japanese.cxf");	/* sagfont2.sft */

	/* sagcad_color */
	sagcad_color.Back = COLOR_INIT(0x000000);
	sagcad_color.Select = COLOR_INIT(0xff0000);
	sagcad_color.Dimension = COLOR_INIT(0xffffff);
	sagcad_color.Cam = COLOR_INIT(0xffffff);
	sagcad_color.PrinterRect = COLOR_INIT(0x0000ff);
	sagcad_color.FirstCenterLine = COLOR_INIT(0xffffff);
//	sagcad_color.Menu[26];				/* 0x00ff00 */
	sagcad_color.Menu[0]  = COLOR_INIT(0x000000);	/* 0x000000 */
	sagcad_color.Menu[1]  = COLOR_INIT(0x00ff00);	/* 0x000000 */
	sagcad_color.Menu[2]  = COLOR_INIT(0x00ffff);	/* 0x000000 */
	sagcad_color.Menu[3]  = COLOR_INIT(0xffff00);	/* 0x000000 */
	sagcad_color.Menu[4]  = COLOR_INIT(0x0000ff);	/* 0x000000 */
	sagcad_color.Menu[5]  = COLOR_INIT(0xffffff);	/* 0x000000 */

	sagcad_color.Menu[6]  = COLOR_INIT(0xff00ff);	/* 0x000000 */
	sagcad_color.Menu[7]  = COLOR_INIT(0xffc0cb);	/* 0x000000 */
	sagcad_color.Menu[8]  = COLOR_INIT(0xffa500);	/* 0x000000 */
	sagcad_color.Menu[9]  = COLOR_INIT(0xda70d6);	/* 0x000000 */
	sagcad_color.Menu[10] = COLOR_INIT(0xffd700);	/* 0x000000 */

	sagcad_color.Menu[11] = COLOR_INIT(0xff8ec7);	/* 0x000000 */
	sagcad_color.Menu[12] = COLOR_INIT(0xff69b4);	/* 0x000000 */
	sagcad_color.Menu[13] = COLOR_INIT(0xdaa520);	/* 0x000000 */
	sagcad_color.Menu[14] = COLOR_INIT(0xadff2f);	/* 0x000000 */
	sagcad_color.Menu[15] = COLOR_INIT(0x32cd32);	/* 0x000000 */

	sagcad_color.Menu[16] = COLOR_INIT(0x9acd32);	/* 0x000000 */
	sagcad_color.Menu[17] = COLOR_INIT(0x5f9ea0);	/* 0x000000 */
	sagcad_color.Menu[18] = COLOR_INIT(0x4682b4);	/* 0x000000 */
	sagcad_color.Menu[19] = COLOR_INIT(0x48d1cc);	/* 0x000000 */
	sagcad_color.Menu[20] = COLOR_INIT(0xadd8e6);	/* 0x000000 */

	sagcad_color.Menu[21] = COLOR_INIT(0x7fffd4);	/* 0x000000 */
	sagcad_color.Menu[22] = COLOR_INIT(0xf8f4d8);	/* 0x000000 */
	sagcad_color.Menu[23] = COLOR_INIT(0xe0e0e0);	/* 0x000000 */
	sagcad_color.Menu[24] = COLOR_INIT(0xb0b0b0);	/* 0x000000 */
	sagcad_color.Menu[25] = COLOR_INIT(0x808080);	/* 0x000000 */


	/* line_style */
	sagcad_line_style[0].style = 1;
	sagcad_line_style[0].max = 1;
	sagcad_line_style[0].min = 0;
	sagcad_line_style[0].DsplayWidth = 2;
	sagcad_line_style[0].PrinterWidth = 2;

	sagcad_line_style[1].style = 1;
	sagcad_line_style[1].max = 1;
	sagcad_line_style[1].min = 0;
	sagcad_line_style[1].DsplayWidth = 1;
	sagcad_line_style[1].PrinterWidth = 1;

	sagcad_line_style[2].style = 2;
	sagcad_line_style[2].max = 2;
	sagcad_line_style[2].min = 1;
	sagcad_line_style[2].DsplayWidth = 1;
	sagcad_line_style[2].PrinterWidth = 1;

	sagcad_line_style[3].style = 3;
	sagcad_line_style[3].max = 10;
	sagcad_line_style[3].min = 1;
	sagcad_line_style[3].DsplayWidth = 1;
	sagcad_line_style[3].PrinterWidth = 1;

	sagcad_line_style[4].style = 4;
	sagcad_line_style[4].max = 10;
	sagcad_line_style[4].min = 1;
	sagcad_line_style[4].DsplayWidth = 1;
	sagcad_line_style[4].PrinterWidth = 1;

	sagcad_line_style[5].style = 1;
	sagcad_line_style[5].max = 1;
	sagcad_line_style[5].min = 0;
	sagcad_line_style[5].DsplayWidth = 1;
	sagcad_line_style[5].PrinterWidth = 1;

	sagcad_line_style[6].style = 1;
	sagcad_line_style[6].max = 1;
	sagcad_line_style[6].min = 0;
	sagcad_line_style[6].DsplayWidth = 1;
	sagcad_line_style[6].PrinterWidth = 1;


	/* digits */
	sagcad_digits.calcu_digits = 10;
	sagcad_digits.compa_digits = 3;
	sagcad_digits.data_digits = 8;
	sagcad_digits.dimension_digits = 3;
	sagcad_digits.cam_digits = 3;
//	calcu_digits = 10;
//	compa_digits = 3;


	/* cam */
	sagcad_cam.CamCheck = 0;
	sagcad_cam.AbsInc = 1;
	sagcad_cam.Modal = 0;
	sagcad_cam.RIJ = 1;
	sagcad_cam.Heel = 0;


	/* Printer */
	printer.Paper = A4_PAPER;
	printer.Orientation = LANDSCAPE; /* PORTRAIT : 1 : ġ LANDSCAPE : 0 : */

	printer.paper_top = 297;
	printer.paper_bottom = 0;
	printer.paper_left = 0;
	printer.paper_right = 210;

	printer.blank_top = 0;
	printer.blank_bottom = 0;
	printer.blank_left = 0;
	printer.blank_right = 0;

	printer.scale = 1;
	printer.up_scale = 1;
	printer.low_scale = 1;

	printer.Draw_View = DISPLAY_VIEW; /* DISPLAY_VIEW : 1 : ̡ DRAWING_VIEW : 0 : ̡*/
	printer.WakuLayer = 0xff;

	keep_printer = printer;



	NowColor = COLOR_INIT(0x00ff00);
	NowStyle = 1;
	NowLayer = 1;


	cad_list_info.head = NULL;
	cad_list_info.tail = NULL;
	/* CAD ǡ */
	cad.layer = 0; cad.code = 0; cad.style = 3; cad.color = sagcad_color.FirstCenterLine;
	cad.sx = 0; cad.sy = 0; cad.ex = 0; cad.ey = 0;
	cad.cx = 0; cad.cy = 0; cad.r = 0;
	/* CAD Data ꥹȤκǽɲ */
	cad_list_add_first(&cad, &cad_list_info);

	cad.layer = 0; cad.code = 1; cad.style = 3; cad.color = sagcad_color.FirstCenterLine;
	cad.sx = sagcad_system.Length; cad.sy = 0; cad.ex = -sagcad_system.Length; cad.ey = 0;
	cad.cx = 0; cad.cy = 0; cad.r = 0;
	cad_list_add_first(&cad, &cad_list_info);

	cad.layer = 0; cad.code = 1; cad.style = 3; cad.color = sagcad_color.FirstCenterLine;
	cad.sx = 0; cad.sy = sagcad_system.Length; cad.ex = 0; cad.ey = -sagcad_system.Length;
	cad.cx = 0; cad.cy = 0; cad.r = 0;
	cad_list_add_first(&cad, &cad_list_info);


#ifdef TEST
	ReturnFunc = MouseRet_Non;
#endif


	/* Layer */
	for (i = 0 ; i < 256 ; i++) {
		if (i == 0 ||i == 1) {
			Layer[i].draw = 1;
		}
		else {
			Layer[i].draw = 0;
		}
		Layer[i].style = 1;
		Layer[i].color = 0xffffff;
		
		sprintf(Layer[i].name, "%X", i);
	}

	/* Ͽѿ */
	for (i = 0 ; i < 7 ; i++) {
		GamenMag[i] = 1;
		GamenMagX[i] = 0;
		GamenMagY[i] = 0;
	}


	return 1;
}





/* ---------------------------------------------------------------------
 * RGB(0xrrggbb) Υ顼 GTK(GdkColor)ѤѴ
 */
GdkColor color_gtk(long rgbcol)
{
	GdkColor color;
	int red, green, blue;

	/* blue */
	blue = rgbcol & 0x0000ff;
	blue = blue * 0xff;
	color.blue = blue;

	/* green */
	green = rgbcol & 0x00ff00;
	green = green >> 8;
	green = green * 0xff;
	color.green = green;

	/* red */
	red = rgbcol & 0xff0000;
	red = red >> 16;
	red = red * 0xff;
	color.red = red;

	return color;
}





/* ---------------------------------------------------------------------
 * GTK(GdkColor) Υ顼  RGB(0xrrggbb)Ѵ
 */
long gtk_color_rgb(GdkColor color)
{
	long red, green, blue;

	blue = color.blue / 0xff;

	green = color.green / 0xff;
	green = green << 8;

	red = color.red / 0xff;
	red = red << 16;

	return (red | green | blue);
}





/* ---------------------------------------------------------------------
 * 0xrrggbb ηΥǡ "rr"  "bb" 򴹤
 * Windows(0xbbggrr) Υ顼  <-->  0xrrggbb  Ѵ
 * 
 */
long Color_RB_Change(long rgbcol)
{
	long color;
	long red, green, blue;

	/* red */
	red = rgbcol & 0x0000ff;
	red = red << 16;

	/* green */
	green = rgbcol & 0x00ff00;

	/* blue */
	blue = rgbcol & 0xff0000;
	blue = blue >> 16;

	color = red + green + blue;
	return color;
}





/* -------------------------------------------------------------------
 * ȥ˥ץ
 * 
 */
int set_window_text(GtkWidget *widget, char *str)
{
	gtk_window_set_title(GTK_WINDOW(widget), str);
	return 1;
}





/* -------------------------------------------------------------------
 * ٥˥ƥȤ
 * 
 */
int set_label_text(GtkWidget *widget, char *str)
{
	gtk_label_set(GTK_LABEL(widget), str);
	return 1;
}





/* -------------------------------------------------------------------
 * եɤ߹
 * 
 */
int ConfigRead(void)
{
//char test[256];

	FILE *stream;
	char Path[256], str[256], home[256];


	/* -----------------------------------------------------
	 * Open File
	 */
	GetConfigPath(str);
//	home_of_user(home);
	sprintf(Path, "%s/sagcadrc", str);

//g_print("%s\n", Path);
	if ((stream = fopen( Path, "r")) == NULL) {
//		g_print("ե %s ĤޤǤ\nư夹˴ĶԤäƤ\n", Path);
		MsgBox("SagCAD ERROR", _("An initial setting file wasn't found out.") , 
			   _("Set environment immediately after start-up.") , NULL, NULL, "OK");

		home_of_user(home);
		sprintf(str, "%s/.sagcad", home);
		mkdir(str, S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IXGRP);
		if (ConfigWrite() == 0) {
			g_print( _("The initial setting file [%s] It wasn't possible to create.\n") , Path);
		}

		return 0;
	}
//g_print("are\n");


	while(1) {
		if (LineRead(stream, str) == 0) {
			fclose(stream);
			return 0;
		}

		/* EOF */
		if(strstr(str,"EOF") != NULL ) break;

		/*  */
		if (strstr(str,"#") - str == 0) {
			;
		}





		/* User */

		/* CompanyName */
		else if(strstr(str, "CompanyName") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sprintf(sagcad_user.CompanyName, "%s", str);
//OneShotLog(sagcad_user.CompanyName);
		}
		/* UserName */
		else if(strstr(str, "UserName") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sprintf(sagcad_user.UserName, "%s",str);
//OneShotLog(sagcad_user.UserName);
		}
		/* PassWord */
		else if(strstr(str, "PassWord") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
//			sprintf(PassWord, "%s", str);
		}



		/* PATH */

		/* CAD PATH */
		else if(strstr(str, "CadPath") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			strcpy(sagcad_user.CadPath, str);
			strcpy(sagcad_user.KeepCadPath, str);
		}
		/* NC PATH */
		else if(strstr(str, "NcPath") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			strcpy(sagcad_user.NcPath, str);
		}

		/* Browser PATH */
//		else if(strstr(str, "BrowserPath") != NULL ) {
//			if (LineRead(stream, str) == 0) return 0;
//			strcpy(sagcad_user.BrowserPath, str);
//			g_print("BrowserPath = %s", str);
//		}



		/* COMMAND */

		/* Editor command */
		else if(strstr(str, "Editor command") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			strcpy(sagcad_user.editor_command, str);
		}
		/* Print command */
		else if(strstr(str, "Print command") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			strcpy(sagcad_user.print_command, str);
		}
		/* Browser command */
		else if(strstr(str, "Browser command") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			strcpy(sagcad_user.browser_command, str);
		}



		/* System */

		/* Wait */
		else if(strstr(str, "Wait") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.Wait = atoi(str);
		}
		/* ZoomMag */
		else if(strstr(str, "ZoomMag") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.ZoomMag = (float) atof(str);
		}
		/* Splits */
		else if(strstr(str, "Splits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.Splits = (float) atof(str);
		}
		/* Search */
		else if(strstr(str, "Search") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.Search = (float) atof(str);
		}
		/* Length */
		else if(strstr(str, "Length") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.Length = (float) atof(str);
		}
		/* FilletRC */
		else if(strstr(str, "FilletRC") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.FilletRC = (float) atof(str);
		}
		/* WinMode */
		else if(strstr(str, "WinMode") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.WinMode = atoi(str);
		}
		/* win_x_pos */
		else if(strstr(str, "win_x_pos") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.win_x_pos = atoi(str);
//			g_print("global.c : ConfigRead() : win_x_pos = %d\n", sagcad_system.win_x_pos);
		}
		/* win_y_pos */
		else if(strstr(str, "win_y_pos") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.win_y_pos = atoi(str);
//			g_print("global.c : ConfigRead() : win_y_pos = %d\n", sagcad_system.win_y_pos);
		}
		/* win_width */
		else if(strstr(str, "win_width") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.win_width = atoi(str);
		}
		/* win_height */
		else if(strstr(str, "win_height") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.win_height = atoi(str);
		}



		/* Layer Setting */

		/* MaxLayer */
//		else if(strstr(str, "MaxLayer") != NULL ) {
//			if (LineRead(stream, str) == 0) return 0;
//			sagcad_system.MaxLayer = atoi(str);
//		}
		/* LostCurrent */
		else if(strstr(str, "LostCurrent") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.LostCurrent = atoi(str);
		}
		/* RealTimeLayerSet */
		else if(strstr(str, "RealTimeLayerSet") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_system.RealTimeLayerSet = atoi(str);
		}



		/* ˡ */

		/* DimensionConfig */
		else if(strstr(str, "DimensionConfig") != NULL || strstr(str, "Draw_Type") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.Draw_Type = atoi(str);
//sprintf(test, "sagcad_dimension.Draw_Type = %d\n", sagcad_dimension.Draw_Type);
//OneShotLog(test);
		}
		/* font_Type */
		else if(strstr(str, "font_Type") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.font_Type = atoi(str);
//sprintf(test, "sagcad_dimension.font_Type = %d\n", sagcad_dimension.font_Type);
//OneShotLog(test);
		}
		/* Font_height */
		else if(strstr(str, "Font_height") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.Font_height = (float) atof(str);
//sprintf(test, "sagcad_dimension.Font_height = %f\n", sagcad_dimension.Font_height);
//OneShotLog(test);
		}
		/* Font_space_line */
		else if(strstr(str, "Font_space_line") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.Font_space_line = (float) atof(str);
//sprintf(test, "sagcad_dimension.Font_space_line = %f\n", sagcad_dimension.Font_space_line);
//OneShotLog(test);
		}
		/* Font_space */
		else if(strstr(str, "Font_space") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.Font_space = (float) atof(str);
//sprintf(test, "sagcad_dimension.Font_space = %f\n", sagcad_dimension.Font_space);
//OneShotLog(test);
		}
		/* arrow_length */
		else if(strstr(str, "arrow_length") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.arrow_length = (float) atof(str);
//sprintf(test, "sagcad_dimension.arrow_length = %f\n", sagcad_dimension.arrow_length);
//OneShotLog(test);
		}
		/* arrow_angle */
		else if(strstr(str, "arrow_angle") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.arrow_angle = (float) atof(str);
//sprintf(test, "sagcad_dimension.arrow_angle = %f\n", sagcad_dimension.arrow_angle);
//OneShotLog(test);
		}
		/* arrow_line_extension */
		else if(strstr(str, "arrow_line_extension") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.arrow_line_extension = (float) atof(str);
//sprintf(test, "sagcad_dimension.arrow_line_extension = %f\n", sagcad_dimension.arrow_line_extension);
//OneShotLog(test);
		}
		/* assistance_line_extension */
		else if(strstr(str, "assistance_line_extension") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.assistance_line_extension = (float) atof(str);
//sprintf(test, "sagcad_dimension.assistance_line_extension = %f\n", sagcad_dimension.assistance_line_extension);
//OneShotLog(test);
		}
		/* assistance_line_space */
		else if(strstr(str, "assistance_line_space") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.assistance_line_space = (float) atof(str);
//sprintf(test, "sagcad_dimension.assistance_line_space = %f\n", sagcad_dimension.assistance_line_space);
//OneShotLog(test);
		}
		/* dimension_figure */
		else if(strstr(str, "dimension_figure") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_dimension.dimension_figure = atoi(str);
//sprintf(test, "sagcad_dimension.dimension_figure = %d\n", sagcad_dimension.dimension_figure);
//OneShotLog(test);
		}
		/* font_file1 */
		else if(strstr(str, "font_file1") != NULL ) {
			LineRead(stream, str);
			sprintf(sagcad_dimension.font_file, "%s", str);
		}
		/* font_file2 */
		else if(strstr(str, "font_file2") != NULL ) {
			LineRead(stream, str);
			sprintf(sagcad_dimension.font_file2, "%s", str);
		}



		/* ƥ५顼 */

		/* BackColor */
		else if(strstr(str, "BackColor") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Back = (atoi16(str)); }
		/* SelectColor */
		else if(strstr(str, "SelectColor") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Select = (atoi16(str)); }
		/* DimensionColor */
		else if(strstr(str, "DimensionColor") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Dimension = (atoi16(str)); }
		/* CamColor */
		else if(strstr(str, "CamColor") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Cam = (atoi16(str)); }
		/* PrinterRectColor */
		else if(strstr(str, "PrinterRectColor") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.PrinterRect = (atoi16(str)); }
		/* FirstCenterLine */
		else if(strstr(str, "FirstCenterLine") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.FirstCenterLine = (atoi16(str)); }



		/* 顼 ˥塼 */

		/* ColorMenu00 */
		else if(strstr(str, "ColorMenu01") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[1] = (atoi16(str)); }
		/* ColorMenu01 */
		else if(strstr(str, "ColorMenu02") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[2] = (atoi16(str)); }
		/* ColorMenu02 */
		else if(strstr(str, "ColorMenu03") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[3] = (atoi16(str)); }
		/* ColorMenu03 */
		else if(strstr(str, "ColorMenu04") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[4] = (atoi16(str)); }
		/* ColorMenu04 */
		else if(strstr(str, "ColorMenu05") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[5] = (atoi16(str)); }
		/* ColorMenu05 */
		else if(strstr(str, "ColorMenu06") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[6] = (atoi16(str)); }
		/* ColorMenu06 */
		else if(strstr(str, "ColorMenu07") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[7] = (atoi16(str)); }
		/* ColorMenu07 */
		else if(strstr(str, "ColorMenu08") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[8] = (atoi16(str)); }
		/* ColorMenu08 */
		else if(strstr(str, "ColorMenu09") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[9] = (atoi16(str)); }
		/* ColorMenu09 */
		else if(strstr(str, "ColorMenu10") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[10] = (atoi16(str)); }
		/* ColorMenu10 */
		else if(strstr(str, "ColorMenu11") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[11] = (atoi16(str)); }
		/* ColorMenu11 */
		else if(strstr(str, "ColorMenu12") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[12] = (atoi16(str)); }
		/* ColorMenu12 */
		else if(strstr(str, "ColorMenu13") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[13] = (atoi16(str)); }
		/* ColorMenu13 */
		else if(strstr(str, "ColorMenu14") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[14] = (atoi16(str)); }
		/* ColorMenu14 */
		else if(strstr(str, "ColorMenu15") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[15] = (atoi16(str)); }
		/* ColorMenu15 */
		else if(strstr(str, "ColorMenu16") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[16] = (atoi16(str)); }
		/* ColorMenu16 */
		else if(strstr(str, "ColorMenu17") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[17] = (atoi16(str)); }
		/* ColorMenu17 */
		else if(strstr(str, "ColorMenu18") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[18] = (atoi16(str)); }
		/* ColorMenu18 */
		else if(strstr(str, "ColorMenu19") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[19] = (atoi16(str)); }
		/* ColorMenu19 */
		else if(strstr(str, "ColorMenu20") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[20] = (atoi16(str)); }
		/* ColorMenu20 */
		else if(strstr(str, "ColorMenu21") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[21] = (atoi16(str)); }
		/* ColorMenu21 */
		else if(strstr(str, "ColorMenu22") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[22] = (atoi16(str)); }
		/* ColorMenu22 */
		else if(strstr(str, "ColorMenu23") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[23] = (atoi16(str)); }
		/* ColorMenu23 */
		else if(strstr(str, "ColorMenu24") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[24] = (atoi16(str)); }
		/* ColorMenu24 */
		else if(strstr(str, "ColorMenu25") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_color.Menu[25] = (atoi16(str)); }



		/*  */

		/* LineStyle[0] */
		else if(strstr(str, "LineStyle00_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[0].style = atoi(str);
		}
		else if(strstr(str, "LineStyle00_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[0].max = atoi(str);
		}
		else if(strstr(str, "LineStyle00_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[0].min = atoi(str);
		}
		else if(strstr(str, "LineStyle00_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[0].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle00_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[0].PrinterWidth = atoi(str);
		}

		/* LineStyle[1] */
		else if(strstr(str, "LineStyle01_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[1].style = atoi(str);
		}
		else if(strstr(str, "LineStyle01_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[1].max = atoi(str);
		}
		else if(strstr(str, "LineStyle01_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[1].min = atoi(str);
		}
		else if(strstr(str, "LineStyle01_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[1].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle01_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[1].PrinterWidth = atoi(str);
		}

		/* LineStyle[2] */
		else if(strstr(str, "LineStyle02_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[2].style = atoi(str);
		}
		else if(strstr(str, "LineStyle02_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[2].max = atoi(str);
		}
		else if(strstr(str, "LineStyle02_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[2].min = atoi(str);
		}
		else if(strstr(str, "LineStyle02_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[2].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle02_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[2].PrinterWidth = atoi(str);
		}

		/* sagcad_line_style[3] */
		else if(strstr(str, "LineStyle03_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[3].style = atoi(str);
		}
		else if(strstr(str, "LineStyle03_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[3].max = atoi(str);
		}
		else if(strstr(str, "LineStyle03_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[3].min = atoi(str);
		}
		else if(strstr(str, "LineStyle03_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[3].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle03_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[3].PrinterWidth = atoi(str);
		}

		/* LineStyle[4] */
		else if(strstr(str, "LineStyle04_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[4].style = atoi(str);
		}
		else if(strstr(str, "LineStyle04_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[4].max = atoi(str);
		}
		else if(strstr(str, "LineStyle04_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[4].min = atoi(str);
		}
		else if(strstr(str, "LineStyle04_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[4].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle04_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[4].PrinterWidth = atoi(str);
		}

		/* LineStyle[5] */
		else if(strstr(str, "LineStyle05_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[5].style = atoi(str);
		}
		else if(strstr(str, "LineStyle05_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[5].max = atoi(str);
		}
		else if(strstr(str, "LineStyle05_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[5].min = atoi(str);
		}
		else if(strstr(str, "LineStyle05_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[5].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle05_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[5].PrinterWidth = atoi(str);
		}

		/* LineStyle[6] */
		else if(strstr(str, "LineStyle06_style") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[6].style = atoi(str);
		}
		else if(strstr(str, "LineStyle06_max") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[6].max = atoi(str);
		}
		else if(strstr(str, "LineStyle06_min") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[6].min = atoi(str);
		}
		else if(strstr(str, "LineStyle06_DsplayWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[6].DsplayWidth = atoi(str);
		}
		else if(strstr(str, "LineStyle06_PrinterWidth") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_line_style[6].PrinterWidth = atoi(str);
		}





		/* digits */

		/* calcu_digits */
		else if(strstr(str, "calcu_digits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_digits.calcu_digits = atoi(str);
			calcu_digits = atoi(str);
		}

		/* compa_digits */
		else if(strstr(str, "compa_digits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_digits.compa_digits = atoi(str);
			compa_digits = atoi(str);
		}

		/* data_digits */
		else if(strstr(str, "data_digits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_digits.data_digits = atoi(str);
		}

		/* dimension_digits */
		else if(strstr(str, "dimension_digits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_digits.dimension_digits = atoi(str);
		}

		/* cam_digits */
		else if(strstr(str, "cam_digits") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_digits.cam_digits = atoi(str);
		}





		/* cam */

		/* CamCheck */
		else if(strstr(str, "CamCheck") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_cam.CamCheck = atoi(str);
		}

		/* AbsInc */
		else if(strstr(str, "AbsInc") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_cam.AbsInc = atoi(str);
		}

		/* Modal */
		else if(strstr(str, "Modal") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_cam.Modal = atoi(str);
		}

		/* RIJ */
		else if(strstr(str, "RIJ") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_cam.RIJ = atoi(str);
		}

		/* Heel */
		else if(strstr(str, "Heel") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			sagcad_cam.Heel = atoi(str);
		}



//#ifdef TEST
		/* printer */

		/* scPaperSize */
		else if(strstr(str, "Paper") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.Paper = atoi(str);
		}

		/* scOrientation */
		else if(strstr(str, "Orientation") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.Orientation = atoi(str);
		}

		/* paper_top */
		else if(strstr(str, "paper_top") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.paper_top = atof(str);
		}
		/* paper_bottom */
		else if(strstr(str, "paper_bottom") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.paper_bottom = atof(str);
		}
		/* paper_left */
		else if(strstr(str, "paper_left") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.paper_left = atof(str);
		}
		/* paper_right */
		else if(strstr(str, "paper_right") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.paper_right = atof(str);
		}

		/* blank_top */
		else if(strstr(str, "blank_top") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.blank_top = 0;//atof(str);
		}
		/* blank_bottom */
		else if(strstr(str, "blank_bottom") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.blank_bottom = 0;//atof(str);
		}
		/* blank_left */
		else if(strstr(str, "blank_left") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.blank_left = 0;//atof(str);
		}
		/* blank_right */
		else if(strstr(str, "blank_right") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.blank_right = 0;//atof(str);
		}

		/* UpScale */
		else if(strstr(str, "up_scale") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.up_scale = (float) atof(str);
		}

		/* LowScale */
		else if(strstr(str, "low_scale") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.low_scale = (float) atof(str);
		}

		/* RealSize */
		else if(strstr(str, "Draw_View") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.Draw_View = atoi(str);
		}

		/* WakuLayer */
		else if(strstr(str, "WakuLayer") != NULL ) {
			if (LineRead(stream, str) == 0) return 0;
			printer.WakuLayer = atoi(str);
		}
//#endif


	}
	fclose(stream);
	return 1;
}





/* -------------------------------------------------------------------
 * ե񤭤
 * 
 */
int ConfigWrite(void)
{
	FILE *stream;
	char Path[256], str[256], str1[256];//, home[256];
	int i;



	/* -----------------------------------------------------
	 * Open File
	 */
	GetConfigPath(str);
	sprintf(Path, "%s/sagcadrc", str);
//	home_of_user(home);
//	sprintf(Path, "%s/.sagcadrc", home);
	if ((stream = fopen( Path, "w")) == NULL) {
//		g_print("ե %s ǤޤǤ", Path);
		MsgBox("SagCAD ERROR", "ե", "ǤޤǤ", NULL, NULL, "OK");
		return 0;
	}


	sprintf(str, "# ====================================================================\n");
	fputs(str, stream);
	sprintf(str, "# ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===\n");
	fputs(str, stream);
	sprintf(str, "# ====================================================================\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);
	sprintf(str, "#    Project              : sagcad\n");
	fputs(str, stream);
	sprintf(str, "#    Description          : CAD/CAM\n");
	fputs(str, stream);
	sprintf(str, "#    Source               : sagcadrc\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);
	sprintf(str, "#    ----------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);
	sprintf(str, "#    Copyright            : (C) 1998-2003 by Yutaka Sagiya\n");
	fputs(str, stream);
	sprintf(str, "#    email                : kappa@a6s.highway.ne.jp\n");
	fputs(str, stream);
	sprintf(str, "#                         : yutaka@sagiya.com\n");
	fputs(str, stream);
	sprintf(str, "#    Begin                : 2001/03/27\n");
	fputs(str, stream);
	sprintf(str, "#    Last                 : 2002/10/12\n");
	fputs(str, stream);
	sprintf(str, "# ====================================================================\n");
	fputs(str, stream);





	/* -----------------------------------------------------
	 * User 
	 */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# User\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* CompanyName */
	sprintf(str, "CompanyName\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.CompanyName);
	fputs(str, stream);

	/* UserName */
	sprintf(str, "UserName\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.UserName);
	fputs(str, stream);


	/* -----------------------------------------------------
	 * PATH 
	 */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# PATH\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* CadPath */
	sprintf(str, "CadPath\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.KeepCadPath);
	fputs(str, stream);

	/* NcPath */
	sprintf(str, "NcPath\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.NcPath);
	fputs(str, stream);

	/* BrowserPath */
	sprintf(str, "BrowserPath\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.BrowserPath);
	fputs(str, stream);


	/* -----------------------------------------------------
	 * Command 
	 */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# COMMAND\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* Editor */
	sprintf(str, "Editor command\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.editor_command);
	fputs(str, stream);

	/* Print */
	sprintf(str, "Print command\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.print_command);
	fputs(str, stream);

	/* Browser */
	sprintf(str, "Browser command\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_user.browser_command);
	fputs(str, stream);


	/* -----------------------------------------------------
	 * System 
	 */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# System\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* Wait */
	sprintf(str, "Wait\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.Wait);
	fputs(str, stream);

	/* win_x_pos */
	sprintf(str, "win_x_pos\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.win_x_pos);
	fputs(str, stream);

	/* win_y_pos */
	sprintf(str, "win_y_pos\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.win_y_pos);
	fputs(str, stream);

	/* win_width */
	sprintf(str, "win_width\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.win_width);
	fputs(str, stream);

	/* win_height */
	sprintf(str, "win_height\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.win_height);
	fputs(str, stream);

	/* ZoomMag */
	sprintf(str, "ZoomMag\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_system.ZoomMag, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Splits */
	sprintf(str, "Splits\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_system.Splits, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Search */
	sprintf(str, "Search\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_system.Search, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Length */
	sprintf(str, "Length\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_system.Length, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* FiretRC */
	sprintf(str, "FilletRC\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_system.FilletRC, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* WinMode */
	sprintf(str, "WinMode\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.WinMode);
	fputs(str, stream);


	/* -----------------------------------------------------
	 * Layer Setting 
	 */
	/* MaxLayer */
//	sprintf(str, "MaxLayer\n");
//	fputs(str, stream);
//	sprintf(str, "  %d\n", sagcad_system.MaxLayer);
//	fputs(str, stream);

	/* LostCurrent */
	sprintf(str, "LostCurrent\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.LostCurrent);
	fputs(str, stream);

	/* RealTimeLayerSet */
	sprintf(str, "RealTimeLayerSet\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_system.RealTimeLayerSet);
	fputs(str, stream);





	/* -----------------------------------------------------
	 * ˡ 
	 */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# ˡ\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* DimensionConfig */
	sprintf(str, "Draw_Type\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_dimension.Draw_Type);
	fputs(str, stream);

	/* font_Type */
	sprintf(str, "font_Type\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.font_Type, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Font_height */
	sprintf(str, "Font_height\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.Font_height, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Font_space */
	sprintf(str, "Font_space\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.Font_space, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* Font_space_line */
	sprintf(str, "Font_space_line\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.Font_space_line, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* arrow_length */
	sprintf(str, "arrow_length\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.arrow_length, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* arrow_angle */
	sprintf(str, "arrow_angle\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.arrow_angle, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* arrow_line_extension */
	sprintf(str, "arrow_line_extension\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.arrow_line_extension, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* assistance_line_extension */
	sprintf(str, "assistance_line_extension\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.assistance_line_extension, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* assistance_line_space */
	sprintf(str, "assistance_line_space\n");
	fputs(str, stream);
	FloatOut(str1, sagcad_dimension.assistance_line_space, 0);
	sprintf(str, "  %s\n", str1);
	fputs(str, stream);

	/* dimension_figure */
	sprintf(str, "dimension_figure\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_dimension.dimension_figure);
	fputs(str, stream);

	/* font_file1 */
	sprintf(str, "font_file1\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_dimension.font_file);
	fputs(str, stream);

	/* font_file2 */
	sprintf(str, "font_file2\n");
	fputs(str, stream);
	sprintf(str, "%s\n", sagcad_dimension.font_file2);
	fputs(str, stream);





	/* ƥ५顼 */

	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# System Color\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* BackColor */
	sprintf(str, "BackColor\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Back));
	fputs(str, stream);

	/* SelectColor */
	sprintf(str, "SelectColor\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Select));
	fputs(str, stream);

	/* DimensionColor */
	sprintf(str, "DimensionColor\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Dimension));
	fputs(str, stream);

	/* CamColor */
	sprintf(str, "CamColor\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Cam));
	fputs(str, stream);

	/* PrinterRectColor */
	sprintf(str, "PrinterRectColor\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.PrinterRect));
	fputs(str, stream);

	/* FirstCenterLine */
	sprintf(str, "FirstCenterLine\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.FirstCenterLine));
	fputs(str, stream);





	/* 顼 ˥塼 */

	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# Color Menu\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	/* ColorMenu01 */
	sprintf(str, "ColorMenu01\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[1]));
	fputs(str, stream);
	/* ColorMenu02 */
	sprintf(str, "ColorMenu02\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[2]));
	fputs(str, stream);
	/* ColorMenu03 */
	sprintf(str, "ColorMenu03\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[3]));
	fputs(str, stream);
	/* ColorMenu04 */
	sprintf(str, "ColorMenu04\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[4]));
	fputs(str, stream);
	/* ColorMenu05 */
	sprintf(str, "ColorMenu05\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[5]));
	fputs(str, stream);
	/* ColorMenu06 */
	sprintf(str, "ColorMenu06\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[6]));
	fputs(str, stream);
	/* ColorMenu07 */
	sprintf(str, "ColorMenu07\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[7]));
	fputs(str, stream);
	/* ColorMenu08 */
	sprintf(str, "ColorMenu08\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[8]));
	fputs(str, stream);
	/* ColorMenu09 */
	sprintf(str, "ColorMenu09\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[9]));
	fputs(str, stream);
	/* ColorMenu10 */
	sprintf(str, "ColorMenu10\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[10]));
	fputs(str, stream);
	/* ColorMenu11 */
	sprintf(str, "ColorMenu11\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[11]));
	fputs(str, stream);
	/* ColorMenu12 */
	sprintf(str, "ColorMenu12\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[12]));
	fputs(str, stream);
	/* ColorMenu13 */
	sprintf(str, "ColorMenu13\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[13]));
	fputs(str, stream);
	/* ColorMenu14 */
	sprintf(str, "ColorMenu14\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[14]));
	fputs(str, stream);
	/* ColorMenu15 */
	sprintf(str, "ColorMenu15\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[15]));
	fputs(str, stream);
	/* ColorMenu16 */
	sprintf(str, "ColorMenu16\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[16]));
	fputs(str, stream);
	/* ColorMenu17 */
	sprintf(str, "ColorMenu17\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[17]));
	fputs(str, stream);
	/* ColorMenu18 */
	sprintf(str, "ColorMenu18\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[18]));
	fputs(str, stream);
	/* ColorMenu19 */
	sprintf(str, "ColorMenu19\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[19]));
	fputs(str, stream);
	/* ColorMenu20 */
	sprintf(str, "ColorMenu20\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[20]));
	fputs(str, stream);
	/* ColorMenu21 */
	sprintf(str, "ColorMenu21\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[21]));
	fputs(str, stream);
	/* ColorMenu22 */
	sprintf(str, "ColorMenu22\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[22]));
	fputs(str, stream);
	/* ColorMenu23 */
	sprintf(str, "ColorMenu23\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[23]));
	fputs(str, stream);
	/* ColorMenu24 */
	sprintf(str, "ColorMenu24\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[24]));
	fputs(str, stream);
	/* ColorMenu25 */
	sprintf(str, "ColorMenu25\n");
	fputs(str, stream);
	sprintf(str, "0x%x\n", (int)(sagcad_color.Menu[25]));
	fputs(str, stream);





	/*  */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# Line Style\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	for ( i = 0 ; i < 7 ; i++ ) {
	/* LineStyle00 */
		sprintf(str, "LineStyle0%d_style\n", i);
		fputs(str, stream);
		sprintf(str, "  %d\n", sagcad_line_style[i].style);
		fputs(str, stream);
		sprintf(str, "LineStyle0%d_max\n", i);
		fputs(str, stream);
		sprintf(str, "  %d\n", sagcad_line_style[i].max);
		fputs(str, stream);
		sprintf(str, "LineStyle0%d_min\n", i);
		fputs(str, stream);
		sprintf(str, "  %d\n", sagcad_line_style[i].min);
		fputs(str, stream);
		sprintf(str, "LineStyle0%d_DsplayWidth\n", i);
		fputs(str, stream);
		sprintf(str, "  %d\n", sagcad_line_style[i].DsplayWidth);
		fputs(str, stream);
		sprintf(str, "LineStyle0%d_PrinterWidth\n", i);
		fputs(str, stream);
		sprintf(str, "  %d\n", sagcad_line_style[i].PrinterWidth);
		fputs(str, stream);
	}





	/* digits */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# digits\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	sprintf(str, "calcu_digits\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_digits.calcu_digits);
	fputs(str, stream);

	sprintf(str, "compa_digits\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_digits.compa_digits);
	fputs(str, stream);

	sprintf(str, "data_digits\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_digits.data_digits);
	fputs(str, stream);

	sprintf(str, "dimension_digits\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_digits.dimension_digits);
	fputs(str, stream);

	sprintf(str, "cam_digits\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_digits.cam_digits);
	fputs(str, stream);





	/* cam */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# cam\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	sprintf(str, "CamCheck\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_cam.CamCheck);
	fputs(str, stream);

	sprintf(str, "AbsInc\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_cam.AbsInc);
	fputs(str, stream);

	sprintf(str, "Modal\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_cam.Modal);
	fputs(str, stream);

	sprintf(str, "RIJ\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_cam.RIJ);
	fputs(str, stream);

	sprintf(str, "Heel\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", sagcad_cam.Heel);
	fputs(str, stream);




	/* printer */
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "\n");
	fputs(str, stream);
	sprintf(str, "# --------------------------------------------------------------------\n");
	fputs(str, stream);
	sprintf(str, "# printer\n");
	fputs(str, stream);
	sprintf(str, "# \n");
	fputs(str, stream);

	sprintf(str, "Paper\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", keep_printer.Paper);
	fputs(str, stream);

	sprintf(str, "Orientation\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", keep_printer.Orientation);
	fputs(str, stream);

	sprintf(str, "brank_top\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.blank_top);
	fputs(str, stream);
	sprintf(str, "blank_bottom\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.blank_bottom);
	fputs(str, stream);
	sprintf(str, "blank_left\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.blank_left);
	fputs(str, stream);
	sprintf(str, "blank_right\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.blank_right);
	fputs(str, stream);

	sprintf(str, "paper_top\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.paper_top);
	fputs(str, stream);
	sprintf(str, "paper_bottom\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.paper_bottom);
	fputs(str, stream);
	sprintf(str, "paper_left\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.paper_left);
	fputs(str, stream);
	sprintf(str, "paper_right\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.paper_right);
	fputs(str, stream);

	sprintf(str, "up_scale\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.up_scale);
	fputs(str, stream);
	sprintf(str, "low_scale\n");
	fputs(str, stream);
	sprintf(str, "  %f\n", keep_printer.low_scale);
	fputs(str, stream);

	sprintf(str, "Draw_View\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", keep_printer.Draw_View);
	fputs(str, stream);

	sprintf(str, "WakuLayer\n");
	fputs(str, stream);
	sprintf(str, "  %d\n", keep_printer.WakuLayer);
	fputs(str, stream);

	keep_printer = printer;



	/* EOF */
	sprintf(str, "EOF\n");
	fputs(str, stream );
	/* ե򥯥 */ 
	fclose(stream);
	return 1;
}
#ifdef AFTER
#endif





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : global.c
 * ====================================================================
 */

