%define name	sage
%define version	0.1.2
%define release 1
%define prefix /usr

Summary:	An OpenGL Extensions library using SDL
Name:		%{name}
Version:	%{version}
Release:	%{release}
License:	LGPL
Group:		System Environment/Libraries
Source:		%{name}-%{version}.tar.gz
Requires:	SDL >= 1.2.2
BuildRequires:	SDL-devel >= 1.2.2
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot

AutoReqProv: no

%description
Sage is an OpenGL extensions library using SDL's SDL_GetProcAddress function to connect OpenGL extension functions.

%package devel
Summary:	An OpenGL Extensions library using SDL
Group:		Development/Libraries
Requires:	%{name} = %{version} SDL-devel >= 1.2.2

%description devel
Sage is an OpenGL extensions library using SDL's SDL_GetProcAddress function to connect OpenGL extension functions.

%prep
%setup -q

%build
CXXFLAGS=$RPM_OPT_FLAGS %configure

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_libdir}/libsage.so.*
%doc AUTHORS README COPYING NEWS

%files devel
%defattr(-,root,root)
%{_includedir}/sage/sage.h
%{_includedir}/sage/header.h
%{_includedir}/sage/utility.h
%{_includedir}/sage/glext_sage.h
%{_includedir}/sage/GL.h
%{_includedir}/sage/GLU.h
%{_includedir}/sage/undefs.h
%{_libdir}/libsage.a
%{_libdir}/libsage.so
%{_libdir}/libsage.la
%{_libdir}/pkgconfig/sage.pc
%{_mandir}/man3/sage.3.gz
%{_mandir}/man3/sage_init.3.gz

%changelog
* Mon Oct 10 2005 Simon Goodall <sage@simongoodall.co.uk>
- Add man pages to files section

* Mon Jun 28 2004 Simon Goodall <sage@simongoodall.co.uk>
- Replace _prefix with better macros
- Add missing file entries
- Ignore libGL.so.1 
