#!/usr/bin/env ruby
#
# Samizdat top focuses list
#
#   Copyright (c) 2002-2005  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

request do |session|
  t = session.template
  skip, = session.params %w[skip]
  skip = skip.to_i

  title = config['site']['name'] + ': ' + _('Top Focuses') +
    (skip > 0 ? sprintf(_(', page %s'), skip + 1) : '')

  focuses = cache[%{focuses/#{skip}}]
  if focuses.nil?
    cache[%{focuses/#{skip}}] = focuses = rdf.select_all( %{
SELECT ?focus, count(?resource)
WHERE (rdf::predicate ?stmt dc::relation)
      (rdf::subject ?stmt ?resource)
      (rdf::object ?stmt ?focus)
      (s::inReplyTo ?resource ?parent)
      (dct::isVersionOf ?resource ?current)
      (s::rating ?stmt ?rating)
LITERAL ?rating > 0 AND ?parent IS NULL AND ?current IS NULL
GROUP BY ?focus
ORDER BY count(?resource) DESC}, limit_page, limit_page * skip)
  end
  focuses = focuses.collect {|focus, usage|
    Resource.new(session, focus).render_related }
  page = focuses.join + %{<div class="foot">} +
    t.nav(focuses.size < limit_page, skip + 1) + "</div>\n"

  t.page(title, page)
end
