/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

GtkWidget*
create_about1 (void)
{
  const gchar *authors[] = {
    "Jochen Voss <voss@mathematik.uni-kl.de>",
    NULL
  };
  GtkWidget *about1;

  about1 = gnome_about_new ("SandUhr", VERSION,
                        _("Copyright 1999, 2000 Jochen Voss"),
                        authors,
                        _("This is just another alarm clock,\nwhich is designed as a sand-glass."),
                        "sanduhr/about.png");
  gtk_object_set_data (GTK_OBJECT (about1), "about1", about1);
  gtk_window_set_modal (GTK_WINDOW (about1), TRUE);
  gtk_window_set_wmclass (GTK_WINDOW (about1), "sanduhr", "AboutDialog");

  return about1;
}

GtkWidget*
create_initdialog (void)
{
  GtkWidget *initdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *frame1;
  GtkWidget *vbox2;
  GSList *init_times_group = NULL;
  GtkWidget *b90;
  GtkWidget *b180;
  GtkWidget *b300;
  GtkWidget *b1800;
  GtkWidget *bxxx;
  GtkWidget *custom_entry;
  GtkWidget *frame2;
  GtkWidget *entry2;
  GtkWidget *message;
  GtkWidget *dialog_action_area1;
  GtkWidget *button4;
  GtkWidget *button3;
  GtkWidget *init_help_button;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  initdialog = gnome_dialog_new (_("Initial Sanduhr Settings"), NULL);
  gtk_object_set_data (GTK_OBJECT (initdialog), "initdialog", initdialog);
  GTK_WINDOW (initdialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (initdialog), TRUE, TRUE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (initdialog), "sanduhr", "Sanduhr");

  dialog_vbox1 = GNOME_DIALOG (initdialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (initdialog), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  frame1 = gtk_frame_new (_("Alarm time"));
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame1), vbox2);

  b90 = gtk_radio_button_new_with_label (init_times_group, _("90 seconds"));
  init_times_group = gtk_radio_button_group (GTK_RADIO_BUTTON (b90));
  gtk_widget_ref (b90);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "b90", b90,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b90);
  gtk_box_pack_start (GTK_BOX (vbox2), b90, FALSE, FALSE, 0);

  b180 = gtk_radio_button_new_with_label (init_times_group, _("3 minutes"));
  init_times_group = gtk_radio_button_group (GTK_RADIO_BUTTON (b180));
  gtk_widget_ref (b180);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "b180", b180,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b180);
  gtk_box_pack_start (GTK_BOX (vbox2), b180, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b180), TRUE);

  b300 = gtk_radio_button_new_with_label (init_times_group, _("5 minutes"));
  init_times_group = gtk_radio_button_group (GTK_RADIO_BUTTON (b300));
  gtk_widget_ref (b300);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "b300", b300,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b300);
  gtk_box_pack_start (GTK_BOX (vbox2), b300, FALSE, FALSE, 0);

  b1800 = gtk_radio_button_new_with_label (init_times_group, _("30 minutes"));
  init_times_group = gtk_radio_button_group (GTK_RADIO_BUTTON (b1800));
  gtk_widget_ref (b1800);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "b1800", b1800,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (b1800);
  gtk_box_pack_start (GTK_BOX (vbox2), b1800, FALSE, FALSE, 0);

  bxxx = gtk_radio_button_new_with_label (init_times_group, _("custom (e.g. +1h45m30s or 14:32):"));
  init_times_group = gtk_radio_button_group (GTK_RADIO_BUTTON (bxxx));
  gtk_widget_ref (bxxx);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "bxxx", bxxx,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bxxx);
  gtk_box_pack_start (GTK_BOX (vbox2), bxxx, FALSE, FALSE, 0);

  custom_entry = gtk_entry_new ();
  gtk_widget_ref (custom_entry);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "custom_entry", custom_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (custom_entry);
  gtk_box_pack_start (GTK_BOX (vbox2), custom_entry, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, custom_entry, _("The alarm period, e.g. \"+1h30m\", \"+45s\", or \"21:30\""), NULL);

  frame2 = gtk_frame_new (_("Alarm message"));
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);

  entry2 = gnome_entry_new ("message");
  gtk_widget_ref (entry2);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "entry2", entry2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry2);
  gtk_container_add (GTK_CONTAINER (frame2), entry2);

  message = gnome_entry_gtk_entry (GNOME_ENTRY (entry2));
  gtk_widget_ref (message);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "message", message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message);
  gtk_tooltips_set_tip (tooltips, message, _("A message to be displayed when the timer expires."), NULL);

  dialog_action_area1 = GNOME_DIALOG (initdialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (initdialog), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  gnome_dialog_append_button (GNOME_DIALOG (initdialog), GNOME_STOCK_BUTTON_OK);
  button4 = GTK_WIDGET (g_list_last (GNOME_DIALOG (initdialog)->buttons)->data);
  gtk_widget_ref (button4);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "button4", button4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button4);
  GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (initdialog), GNOME_STOCK_BUTTON_CANCEL);
  button3 = GTK_WIDGET (g_list_last (GNOME_DIALOG (initdialog)->buttons)->data);
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button3);
  GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (initdialog), GNOME_STOCK_BUTTON_HELP);
  init_help_button = GTK_WIDGET (g_list_last (GNOME_DIALOG (initdialog)->buttons)->data);
  gtk_widget_ref (init_help_button);
  gtk_object_set_data_full (GTK_OBJECT (initdialog), "init_help_button", init_help_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (init_help_button);
  GTK_WIDGET_SET_FLAGS (init_help_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (custom_entry), "changed",
                      GTK_SIGNAL_FUNC (on_custom_entry_changed),
                      NULL);

  gtk_object_set_data (GTK_OBJECT (initdialog), "tooltips", tooltips);

  return initdialog;
}

GtkWidget*
create_properties (void)
{
  GtkWidget *properties;
  GtkWidget *notebook1;
  GtkWidget *table1;
  GtkWidget *time_entry;
  GtkWidget *entry4;
  GtkWidget *msg_entry;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label1;
  GtkWidget *vbox3;
  GSList *alarmmethod_group = NULL;
  GtkWidget *bell_alarm;
  GtkWidget *snd_alarm;
  GtkWidget *snd_file_entry;
  GtkWidget *snd_entry;
  GtkWidget *cmd_alarm;
  GtkWidget *cmd_file_entry;
  GtkWidget *cmd_entry;
  GtkWidget *corba_alarm;
  GtkWidget *corba_entry;
  GtkWidget *label2;
  GtkWidget *table2;
  GtkWidget *label7;
  GtkWidget *sand_color;
  GtkWidget *label3;
  GtkWidget *table3;
  GtkWidget *label8;
  GtkWidget *deco_button;
  GtkWidget *alignment1;
  GtkWidget *vbox4;
  GSList *layergroup_group = NULL;
  GtkWidget *layer_desktop;
  GtkWidget *layer_below;
  GtkWidget *layer_normal;
  GtkWidget *layer_ontop;
  GtkWidget *label9;
  GtkWidget *label4;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  properties = gnome_property_box_new ();
  gtk_object_set_data (GTK_OBJECT (properties), "properties", properties);
  gtk_window_set_title (GTK_WINDOW (properties), _("SandUhr properties"));
  gtk_window_set_policy (GTK_WINDOW (properties), TRUE, TRUE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (properties), "sanduhr", "PropertyBox");

  notebook1 = GNOME_PROPERTY_BOX (properties)->notebook;
  gtk_object_set_data (GTK_OBJECT (properties), "notebook1", notebook1);
  gtk_widget_show (notebook1);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (properties), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (notebook1), table1);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  time_entry = gtk_entry_new ();
  gtk_widget_ref (time_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "time_entry", time_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (time_entry);
  gtk_table_attach (GTK_TABLE (table1), time_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, time_entry, _("the alarm period, e.g. \"+1h30m\", \"+45s\", or \"21:30\""), NULL);

  entry4 = gnome_entry_new ("message");
  gtk_widget_ref (entry4);
  gtk_object_set_data_full (GTK_OBJECT (properties), "entry4", entry4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry4);
  gtk_table_attach (GTK_TABLE (table1), entry4, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  msg_entry = gnome_entry_gtk_entry (GNOME_ENTRY (entry4));
  gtk_widget_ref (msg_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "msg_entry", msg_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (msg_entry);
  gtk_tooltips_set_tip (tooltips, msg_entry, _("A message to be displayed when the timer expires."), NULL);

  label5 = gtk_label_new (_("Time:"));
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0);

  label6 = gtk_label_new (_("Message:"));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label1 = gtk_label_new (_("alarm"));
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label1);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (properties), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox3);

  bell_alarm = gtk_radio_button_new_with_label (alarmmethod_group, _("Ring terminal bell"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (bell_alarm));
  gtk_widget_ref (bell_alarm);
  gtk_object_set_data_full (GTK_OBJECT (properties), "bell_alarm", bell_alarm,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bell_alarm);
  gtk_box_pack_start (GTK_BOX (vbox3), bell_alarm, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bell_alarm), TRUE);

  snd_alarm = gtk_radio_button_new_with_label (alarmmethod_group, _("Play sound file:"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (snd_alarm));
  gtk_widget_ref (snd_alarm);
  gtk_object_set_data_full (GTK_OBJECT (properties), "snd_alarm", snd_alarm,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (snd_alarm);
  gtk_box_pack_start (GTK_BOX (vbox3), snd_alarm, FALSE, FALSE, 0);

  snd_file_entry = gnome_file_entry_new ("sounds", _("Alarm sound file"));
  gtk_widget_ref (snd_file_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "snd_file_entry", snd_file_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (snd_file_entry);
  gtk_box_pack_start (GTK_BOX (vbox3), snd_file_entry, FALSE, FALSE, 0);
  gnome_file_entry_set_modal (GNOME_FILE_ENTRY (snd_file_entry), TRUE);

  snd_entry = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (snd_file_entry));
  gtk_widget_ref (snd_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "snd_entry", snd_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (snd_entry);
  gtk_tooltips_set_tip (tooltips, snd_entry, _("The name of an audio file to play"), NULL);

  cmd_alarm = gtk_radio_button_new_with_label (alarmmethod_group, _("External command:"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cmd_alarm));
  gtk_widget_ref (cmd_alarm);
  gtk_object_set_data_full (GTK_OBJECT (properties), "cmd_alarm", cmd_alarm,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cmd_alarm);
  gtk_box_pack_start (GTK_BOX (vbox3), cmd_alarm, FALSE, FALSE, 0);

  cmd_file_entry = gnome_file_entry_new ("commands", _("External alarm command"));
  gtk_widget_ref (cmd_file_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "cmd_file_entry", cmd_file_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cmd_file_entry);
  gtk_box_pack_start (GTK_BOX (vbox3), cmd_file_entry, FALSE, FALSE, 0);

  cmd_entry = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (cmd_file_entry));
  gtk_widget_ref (cmd_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "cmd_entry", cmd_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cmd_entry);
  gtk_tooltips_set_tip (tooltips, cmd_entry, _("The name of an external command to deliver the alarm (e.g. an audio player)"), NULL);

  corba_alarm = gtk_radio_button_new_with_label (alarmmethod_group, _("External SandUhr::AlarmAction CORBA object:"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (corba_alarm));
  gtk_widget_ref (corba_alarm);
  gtk_object_set_data_full (GTK_OBJECT (properties), "corba_alarm", corba_alarm,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corba_alarm);
  gtk_box_pack_start (GTK_BOX (vbox3), corba_alarm, FALSE, FALSE, 0);

  corba_entry = gtk_entry_new ();
  gtk_widget_ref (corba_entry);
  gtk_object_set_data_full (GTK_OBJECT (properties), "corba_entry", corba_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corba_entry);
  gtk_box_pack_start (GTK_BOX (vbox3), corba_entry, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, corba_entry, _("The IOR string of a CORBA object, which implements SandUhr::AlarmAction."), NULL);

  label2 = gtk_label_new (_("action"));
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label2);

  table2 = gtk_table_new (1, 2, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (properties), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (notebook1), table2);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 8);

  label7 = gtk_label_new (_("Color:"));
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table2), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  sand_color = gnome_color_picker_new ();
  gtk_widget_ref (sand_color);
  gtk_object_set_data_full (GTK_OBJECT (properties), "sand_color", sand_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sand_color);
  gtk_table_attach (GTK_TABLE (table2), sand_color, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gnome_color_picker_set_title (GNOME_COLOR_PICKER (sand_color), _("Pick a sand color"));

  label3 = gtk_label_new (_("sand"));
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label3);

  table3 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (properties), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (notebook1), table3);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 8);

  label8 = gtk_label_new (_("handles:"));
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table3), label8, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  deco_button = gtk_check_button_new_with_label (_("add window decorations"));
  gtk_widget_ref (deco_button);
  gtk_object_set_data_full (GTK_OBJECT (properties), "deco_button", deco_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (deco_button);
  gtk_table_attach (GTK_TABLE (table3), deco_button, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  alignment1 = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_ref (alignment1);
  gtk_object_set_data_full (GTK_OBJECT (properties), "alignment1", alignment1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (alignment1);
  gtk_table_attach (GTK_TABLE (table3), alignment1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (properties), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (alignment1), vbox4);

  layer_desktop = gtk_radio_button_new_with_label (layergroup_group, _("desktop"));
  layergroup_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layer_desktop));
  gtk_widget_ref (layer_desktop);
  gtk_object_set_data_full (GTK_OBJECT (properties), "layer_desktop", layer_desktop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layer_desktop);
  gtk_box_pack_start (GTK_BOX (vbox4), layer_desktop, FALSE, FALSE, 0);

  layer_below = gtk_radio_button_new_with_label (layergroup_group, _("below"));
  layergroup_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layer_below));
  gtk_widget_ref (layer_below);
  gtk_object_set_data_full (GTK_OBJECT (properties), "layer_below", layer_below,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layer_below);
  gtk_box_pack_start (GTK_BOX (vbox4), layer_below, FALSE, FALSE, 0);

  layer_normal = gtk_radio_button_new_with_label (layergroup_group, _("normal"));
  layergroup_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layer_normal));
  gtk_widget_ref (layer_normal);
  gtk_object_set_data_full (GTK_OBJECT (properties), "layer_normal", layer_normal,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layer_normal);
  gtk_box_pack_start (GTK_BOX (vbox4), layer_normal, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (layer_normal), TRUE);

  layer_ontop = gtk_radio_button_new_with_label (layergroup_group, _("on top"));
  layergroup_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layer_ontop));
  gtk_widget_ref (layer_ontop);
  gtk_object_set_data_full (GTK_OBJECT (properties), "layer_ontop", layer_ontop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layer_ontop);
  gtk_box_pack_start (GTK_BOX (vbox4), layer_ontop, FALSE, FALSE, 0);

  label9 = gtk_label_new (_("layer:"));
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table3), label9, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0);

  label4 = gtk_label_new (_("window"));
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (properties), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), label4);

  gtk_signal_connect (GTK_OBJECT (properties), "apply",
                      GTK_SIGNAL_FUNC (apply_settings),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (properties), "help",
                      GTK_SIGNAL_FUNC (on_settings_help),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (properties), "close",
                      GTK_SIGNAL_FUNC (on_settings_close),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (time_entry), "changed",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (msg_entry), "changed",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (bell_alarm), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (snd_alarm), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (snd_entry), "changed",
                      GTK_SIGNAL_FUNC (on_snd_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cmd_alarm), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cmd_entry), "changed",
                      GTK_SIGNAL_FUNC (on_cmd_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (corba_alarm), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (corba_entry), "changed",
                      GTK_SIGNAL_FUNC (on_corba_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (sand_color), "color_set",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (deco_button), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layer_desktop), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layer_below), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layer_normal), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layer_ontop), "toggled",
                      GTK_SIGNAL_FUNC (settings_changed),
                      NULL);

  gtk_object_set_data (GTK_OBJECT (properties), "tooltips", tooltips);

  return properties;
}

GtkWidget*
create_preferences (void)
{
  GtkWidget *preferences;
  GtkWidget *notebook2;
  GtkWidget *vbox5;
  GSList *alarmmethod_group = NULL;
  GtkWidget *bell_pref;
  GtkWidget *snd_pref;
  GtkWidget *pref_file_entry;
  GtkWidget *pref_file;
  GtkWidget *cmd_pref;
  GtkWidget *pref_cmdstring_entry;
  GtkWidget *pref_cmdstring;
  GtkWidget *label14;
  GtkWidget *vbox7;
  GSList *colormethod_group = NULL;
  GtkWidget *random_color_pref;
  GtkWidget *hbox1;
  GtkWidget *fixed_color_pref;
  GtkWidget *color_pref;
  GtkWidget *label15;
  GtkWidget *table4;
  GtkWidget *label17;
  GtkWidget *pref_deco;
  GtkWidget *alignment2;
  GtkWidget *vbox6;
  GSList *pref_layer_group = NULL;
  GtkWidget *pref_desktop;
  GtkWidget *pref_below;
  GtkWidget *pref_normal;
  GtkWidget *pref_ontop;
  GtkWidget *label18;
  GtkWidget *label16;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  preferences = gnome_property_box_new ();
  gtk_object_set_data (GTK_OBJECT (preferences), "preferences", preferences);
  gtk_window_set_title (GTK_WINDOW (preferences), _("SandUhr preferences"));
  gtk_window_set_policy (GTK_WINDOW (preferences), TRUE, TRUE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (preferences), "sanduhr", "PropertyBox");

  notebook2 = GNOME_PROPERTY_BOX (preferences)->notebook;
  gtk_object_set_data (GTK_OBJECT (preferences), "notebook2", notebook2);
  gtk_widget_show (notebook2);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox5);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "vbox5", vbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox5);

  bell_pref = gtk_radio_button_new_with_label (alarmmethod_group, _("Ring terminal bell"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (bell_pref));
  gtk_widget_ref (bell_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "bell_pref", bell_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bell_pref);
  gtk_box_pack_start (GTK_BOX (vbox5), bell_pref, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bell_pref), TRUE);

  snd_pref = gtk_radio_button_new_with_label (alarmmethod_group, _("Play sound file:"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (snd_pref));
  gtk_widget_ref (snd_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "snd_pref", snd_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (snd_pref);
  gtk_box_pack_start (GTK_BOX (vbox5), snd_pref, FALSE, FALSE, 0);

  pref_file_entry = gnome_file_entry_new ("sounds", _("Alarm sound file"));
  gtk_widget_ref (pref_file_entry);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_file_entry", pref_file_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_file_entry);
  gtk_box_pack_start (GTK_BOX (vbox5), pref_file_entry, FALSE, FALSE, 0);
  gnome_file_entry_set_modal (GNOME_FILE_ENTRY (pref_file_entry), TRUE);

  pref_file = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (pref_file_entry));
  gtk_widget_ref (pref_file);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_file", pref_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_file);
  gtk_tooltips_set_tip (tooltips, pref_file, _("The name of an audio file to play"), NULL);

  cmd_pref = gtk_radio_button_new_with_label (alarmmethod_group, _("External command:"));
  alarmmethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cmd_pref));
  gtk_widget_ref (cmd_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "cmd_pref", cmd_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cmd_pref);
  gtk_box_pack_start (GTK_BOX (vbox5), cmd_pref, FALSE, FALSE, 0);

  pref_cmdstring_entry = gnome_file_entry_new ("commands", _("External alarm command"));
  gtk_widget_ref (pref_cmdstring_entry);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_cmdstring_entry", pref_cmdstring_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_cmdstring_entry);
  gtk_box_pack_start (GTK_BOX (vbox5), pref_cmdstring_entry, FALSE, FALSE, 0);
  gnome_file_entry_set_modal (GNOME_FILE_ENTRY (pref_cmdstring_entry), TRUE);

  pref_cmdstring = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (pref_cmdstring_entry));
  gtk_widget_ref (pref_cmdstring);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_cmdstring", pref_cmdstring,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_cmdstring);
  gtk_tooltips_set_tip (tooltips, pref_cmdstring, _("The name of an external command to deliver the alarm (e.g. an audio player)"), NULL);

  label14 = gtk_label_new (_("action"));
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 0), label14);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox7);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "vbox7", vbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox7);

  random_color_pref = gtk_radio_button_new_with_label (colormethod_group, _("random color"));
  colormethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (random_color_pref));
  gtk_widget_ref (random_color_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "random_color_pref", random_color_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (random_color_pref);
  gtk_box_pack_start (GTK_BOX (vbox7), random_color_pref, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox1, FALSE, FALSE, 0);

  fixed_color_pref = gtk_radio_button_new_with_label (colormethod_group, _("fixed color:"));
  colormethod_group = gtk_radio_button_group (GTK_RADIO_BUTTON (fixed_color_pref));
  gtk_widget_ref (fixed_color_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "fixed_color_pref", fixed_color_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fixed_color_pref);
  gtk_box_pack_start (GTK_BOX (hbox1), fixed_color_pref, FALSE, FALSE, 0);

  color_pref = gnome_color_picker_new ();
  gtk_widget_ref (color_pref);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "color_pref", color_pref,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (color_pref);
  gtk_box_pack_start (GTK_BOX (hbox1), color_pref, FALSE, FALSE, 0);
  gnome_color_picker_set_title (GNOME_COLOR_PICKER (color_pref), _("Pick a sand color"));

  label15 = gtk_label_new (_("sand"));
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 1), label15);

  table4 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table4);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "table4", table4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (notebook2), table4);
  gtk_table_set_row_spacings (GTK_TABLE (table4), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table4), 8);

  label17 = gtk_label_new (_("handles:"));
  gtk_widget_ref (label17);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "label17", label17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table4), label17, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 0, 0.5);

  pref_deco = gtk_check_button_new_with_label (_("add window decorations"));
  gtk_widget_ref (pref_deco);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_deco", pref_deco,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_deco);
  gtk_table_attach (GTK_TABLE (table4), pref_deco, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  alignment2 = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_ref (alignment2);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "alignment2", alignment2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (alignment2);
  gtk_table_attach (GTK_TABLE (table4), alignment2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (alignment2), vbox6);

  pref_desktop = gtk_radio_button_new_with_label (pref_layer_group, _("desktop"));
  pref_layer_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_desktop));
  gtk_widget_ref (pref_desktop);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_desktop", pref_desktop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_desktop);
  gtk_box_pack_start (GTK_BOX (vbox6), pref_desktop, FALSE, FALSE, 0);

  pref_below = gtk_radio_button_new_with_label (pref_layer_group, _("below"));
  pref_layer_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_below));
  gtk_widget_ref (pref_below);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_below", pref_below,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_below);
  gtk_box_pack_start (GTK_BOX (vbox6), pref_below, FALSE, FALSE, 0);

  pref_normal = gtk_radio_button_new_with_label (pref_layer_group, _("normal"));
  pref_layer_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_normal));
  gtk_widget_ref (pref_normal);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_normal", pref_normal,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_normal);
  gtk_box_pack_start (GTK_BOX (vbox6), pref_normal, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_normal), TRUE);

  pref_ontop = gtk_radio_button_new_with_label (pref_layer_group, _("on top"));
  pref_layer_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_ontop));
  gtk_widget_ref (pref_ontop);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "pref_ontop", pref_ontop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_ontop);
  gtk_box_pack_start (GTK_BOX (vbox6), pref_ontop, FALSE, FALSE, 0);

  label18 = gtk_label_new (_("layer:"));
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table4), label18, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label18), 0, 0);

  label16 = gtk_label_new (_("window"));
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (preferences), "label16", label16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 2), label16);

  gtk_signal_connect (GTK_OBJECT (preferences), "apply",
                      GTK_SIGNAL_FUNC (on_preferences_apply),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (preferences), "help",
                      GTK_SIGNAL_FUNC (on_preferences_help),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (bell_pref), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (snd_pref), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_file), "changed",
                      GTK_SIGNAL_FUNC (on_pref_file_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cmd_pref), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_cmdstring), "changed",
                      GTK_SIGNAL_FUNC (on_pref_cmd_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (random_color_pref), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fixed_color_pref), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (color_pref), "color_set",
                      GTK_SIGNAL_FUNC (on_color_pref_color_set),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_deco), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_desktop), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_below), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_normal), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (pref_ontop), "toggled",
                      GTK_SIGNAL_FUNC (pref_changed),
                      NULL);

  gtk_object_set_data (GTK_OBJECT (preferences), "tooltips", tooltips);

  return preferences;
}

