#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CubeDialog {} {
    global cube
    global cubedlg
    global current
    global menu
    global ds9
    global blink

    # see if we already have a window visible
    if [winfo exist $cube(top)] {
	raise $cube(top)
	return
    }

    set w $cube(top)
    set title "Data Cube"

    # create the cube window

    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW CubeDestroyDialog

    $w configure -menu $cube(mb)

    menu $cube(mb) -tearoff 0
    $cube(mb) add cascade -label "File" -menu $cube(mb).file
    $cube(mb) add cascade -label "Interval" -menu $cube(mb).blink

    menu $cube(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $cube(mb).file add command -label "Close" -command CubeDestroyDialog

    menu $cube(mb).blink -tearoff 0 -selectcolor $menu(selectcolor)
    $cube(mb).blink add radiobutton -label ".125 Second" \
	-variable blink(interval) -value 125
    $cube(mb).blink add radiobutton -label ".25 Second" \
	-variable blink(interval) -value 250
    $cube(mb).blink add radiobutton -label ".5 Second" \
	-variable blink(interval) -value 500
    $cube(mb).blink add radiobutton -label "1 Second" \
	-variable blink(interval) -value 1000
    $cube(mb).blink add radiobutton -label "2 Seconds" \
	-variable blink(interval) -value 2000
    $cube(mb).blink add radiobutton -label "4 Seconds" \
	-variable blink(interval) -value 4000
    $cube(mb).blink add radiobutton -label "8 Seconds" \
	-variable blink(interval) -value 8000

    frame $w.param -relief groove -borderwidth 2
    frame $w.vcr -relief groove -borderwidth 2
    pack $w.param $w.vcr -fill x -expand true -ipadx 4 -ipady 4

    set cubedlg(scale) [scale $w.param.slice -from 1 -to 1 -length 300 \
			 -variable cube(slice) -orient horizontal \
			 -tickinterval 1 \
			 -showvalue true -resolution 1 \
			 -command CubeApply]

    pack $w.param.slice	-side top -ipadx 4 -ipady 4 -anchor w

    set bs 2
    button $w.vcr.first -text "First" -width $bs -height $bs -command CubeFirst
    button $w.vcr.prev -text "Prev" -width $bs -height $bs -command CubePrev
    button $w.vcr.stop -text "Stop" -width $bs -height $bs -command CubeStop
    button $w.vcr.play -text "Play" -width $bs -height $bs -command CubePlay
    button $w.vcr.next -text "Next" -width $bs -height $bs -command CubeNext
    button $w.vcr.last -text "Last" -width $bs -height $bs -command CubeLast

    pack $w.vcr.first $w.vcr.prev $w.vcr.stop $w.vcr.play \
	$w.vcr.next $w.vcr.last -side left -expand true

    UpdateCubeDialog
}

proc CubeDestroyDialog {} {
    global cube
    global cubedlg

    if {[winfo exist $cube(top)]} {
	destroy $cube(top)
	destroy $cube(mb)
    }

    if {[info exist cubedlg]} {
	unset cubedlg
    }
}

proc CubeApply {slice} {
    global cube
    global current

    CubeStop

    set cube(slice) $slice
    if {$current(frame) != {}} {
	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
}

proc CubeStop {} {
    global cube
    global curent

    if {$cube(id)>0} {
	after cancel $cube(id)
	set cube(id) 0
    }
}

proc CubePlay {} {
    global cube

    if {$cube(id) == 0} {
	CubeTimer
    }
}

proc CubeTimer {} {
    global cube
    global current
    global blink

    if {$cube(slice) == $cube(depth)} {
	set cube(slice) 1
    } else {
	set cube(slice) [expr $cube(slice)+1]
    }
    if {$current(frame) != {}} {
	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
    set cube(id) [after $blink(interval) CubeTimer]
}

proc CubeFirst {} {
    global cube
    global current

    CubeStop

    set cube(slice) 1
    if {$current(frame) != {}} {
	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
}

proc CubePrev {} {
    global cube
    global current

    CubeStop

    if {$current(frame) != {}} {
	set cube(slice) [$current(frame) get fits slice]
	set cube(depth) [$current(frame) get fits depth]

	if {$cube(slice) == 1} {
	    set cube(slice) $cube(depth)
	} else {
	    set cube(slice) [expr $cube(slice)-1]
	}

	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
}

proc CubeNext {} {
    global cube
    global current

    CubeStop

    if {$current(frame) != {}} {
	set cube(slice) [$current(frame) get fits slice]
	set cube(depth) [$current(frame) get fits depth]

	if {$cube(slice) == $cube(depth)} {
	    set cube(slice) 1
	} else {
	    set cube(slice) [expr $cube(slice)+1]
	}

	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
}

proc CubeLast {} {
    global cube
    global current

    CubeStop

    set cube(slice) $cube(depth)
    if {$current(frame) != {}} {
	$current(frame) update fits slice $cube(slice)
	ContourUpdateNow
    }
}

proc UpdateCubeDialog {} {
    global cube
    global cubedlg
    global current

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateCubeDialog"
    }

    if {$current(frame) != {}} {
	set cube(depth) [$current(frame) get fits depth]
	set cube(slice) [$current(frame) get fits slice]

	if [winfo exist $cube(top)] {
	    if {$cube(depth) < 20} {
		set interval 1
	    } elseif {$cube(depth) < 100} {
		set interval 10
	    } elseif {$cube(depth) < 200} {
		set interval 20
	    } else {
		set interval 50
	    }

	    $cubedlg(scale) configure -to $cube(depth) -tickinterval $interval
	}
    }
}

proc ProcessDataCubeCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global cube
    global blink

    switch -- [string tolower [lindex $var $i]] {
	play {CubePlay}
	stop {CubeStop}
	next {CubeNext}
	prev {CubePrev}
	first {CubeFirst}
	last {CubeLast}
	interval {incr i; set blink(interval) [lindex $var $i]}
	default {CubeApply [lindex $var $i]}
    }
}
