#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CreateGraphs {} {
    global ds9
    global graph
    global canvas

    # we need to manually set the plot bg color, i.e. use the default bg
    set plotColor [$ds9(main) cget -background]

    set ds9(graph,sp) [frame $ds9(main).spacer -width $graph(sp,x) \
			   -height $graph(sp,y)]
    # Horizontal Graph

    set ds9(graph,horz) [blt::graph $ds9(main).horz \
			     -width $canvas(width) -height $graph(size) \
			     -bd 0 -plotborderwidth 2 -plotrelief groove \
			     -title "" \
			     -plotpadx 0 -plotpady 0 \
			     -leftmargin 1 -topmargin 4 \
			     -rightmargin $graph(sp,x) \
			     -bottommargin 8 -plotbackground $plotColor \
			     -takefocus 0 \
			    ]

    # wee need to manually set the element foreground color, i.e. use graph fg
    set fgColor [$ds9(graph,horz) cget -foreground]

    $ds9(graph,horz) element create line1 \
	-xdata graphHorzX -ydata graphHorzY -color $fgColor -symbol ""
    $ds9(graph,horz) legend configure -hide yes
    $ds9(graph,horz) xaxis configure -title "" -hide yes
    $ds9(graph,horz) x2axis configure -title "" -hide yes
    $ds9(graph,horz) yaxis configure -title "" -hide yes
    $ds9(graph,horz) y2axis configure -title "" -hide no -color $fgColor \
	-ticklength 4 -tickfont $graph(font)
    $ds9(graph,horz) grid configure -mapy y -dashes ""
    $ds9(graph,horz) crosshairs configure -color green
    $ds9(graph,horz) element configure line1 -hide yes

    bind $ds9(graph,horz) <Enter> [list EnterGraph $ds9(graph,horz) 1]
    bind $ds9(graph,horz) <Leave> [list LeaveGraph $ds9(graph,horz)]
    bind $ds9(graph,horz) <Button-1> \
	[list MotionGraph $ds9(graph,horz) %x %y 1]
    bind $ds9(graph,horz) <B1-Motion> \
	[list MotionGraph $ds9(graph,horz) %x %y 1]
    bind $ds9(graph,horz) <Up> [list ArrowKeyGraph $ds9(graph,horz) 0 -1 1]
    bind $ds9(graph,horz) <Down> [list ArrowKeyGraph $ds9(graph,horz) 0 1 1]
    bind $ds9(graph,horz) <Left> [list ArrowKeyGraph $ds9(graph,horz) -1 0 1]
    bind $ds9(graph,horz) <Right> [list ArrowKeyGraph $ds9(graph,horz) 1 0 1]

    # Vertical Graph

    set ds9(graph,vert) [blt::graph $ds9(main).vert \
			     -width $graph(size) -height $canvas(height) \
			     -bd 0 -plotborderwidth 2 -plotrelief groove \
			     -title "" -invertxy yes \
			     -plotpadx 0 -plotpady 0 \
			     -leftmargin 8 -topmargin 1 \
			     -bottommargin $graph(sp,y) \
			     -rightmargin 4 -plotbackground $plotColor \
			     -takefocus 0 \
			    ]

    $ds9(graph,vert) element create line1 \
	-xdata graphVertX -ydata graphVertY -color $fgColor -symbol ""
    $ds9(graph,vert) legend configure -hide yes
    $ds9(graph,vert) xaxis configure -title "" -hide yes -descending 1
    $ds9(graph,vert) x2axis configure -title "" -hide yes -descending 1
    $ds9(graph,vert) yaxis configure -title "" -hide no \
	-descending yes -color $fgColor -ticklength 4 -tickfont $graph(font)
    $ds9(graph,vert) y2axis configure -title "" -hide yes -descending yes
    $ds9(graph,vert) grid configure -mapy y -dashes ""
    $ds9(graph,vert) crosshairs configure -color green
    $ds9(graph,vert) element configure line1 -hide yes

    bind $ds9(graph,vert) <Enter> [list EnterGraph $ds9(graph,vert) 0]
    bind $ds9(graph,vert) <Leave> [list LeaveGraph $ds9(graph,vert)]
    bind $ds9(graph,vert) <Button-1> \
	[list MotionGraph $ds9(graph,vert) %x %y 0]
    bind $ds9(graph,vert) <B1-Motion> \
	[list MotionGraph $ds9(graph,vert) %x %y 0]
    bind $ds9(graph,vert) <Up> [list ArrowKeyGraph $ds9(graph,vert) 0 -1 0]
    bind $ds9(graph,vert) <Down> [list ArrowKeyGraph $ds9(graph,vert) 0 1 0]
    bind $ds9(graph,vert) <Left> [list ArrowKeyGraph $ds9(graph,vert) -1 0 0]
    bind $ds9(graph,vert) <Right> [list ArrowKeyGraph $ds9(graph,vert) 1 0 0]

    UpdateGraphGrid
}

proc UpdateGraphGrid {} {
    global ds9
    global graph

    $ds9(graph,horz) grid configure -hide [expr !$graph(horz,grid)]
    $ds9(graph,vert) grid configure -hide [expr !$graph(vert,grid)]
}

proc UpdateGraphXAxis {} {
    global ds9
    global view

    # if not xpa update, don't update
    if {!$ds9(xpa,idletasks)} {
	return
    }

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateGraphXAxis"
    }

    if {$view(graph,horz) || $view(graph,vert)} {
	global debug
	if {$debug(tcl,idletasks)} {
	    puts "UpdateGraphXAxis"
	}
	update idletasks
    }
    
    if {$view(graph,horz)} {
	UpdateGraphXAxisHV $ds9(graph,horz) graphHorzX graphHorzY 1
    }
    
    if {$view(graph,vert)} {
	UpdateGraphXAxisHV $ds9(graph,vert) graphVertX graphVertY 0
    }
}

proc UpdateGraphXAxisHV {which vectorX vectorY cut} {
    global current
    global graph
    global graphHorzX graphHorzY
    global graphVertX graphVertY

    if {$current(frame) != ""} {
	set xMin [expr "$$vectorX\(min\)"]
	set xMax [expr "$$vectorX\(max\)"]

	$which xaxis configure -min $xMin -max $xMax
	$which x2axis configure -min $xMin -max $xMax
    } else {
	$which xaxis configure -min $graph(x,min) -max $graph(x,max)
	$which x2axis configure -min $graph(x,min) -max $graph(x,max)
    }
}

proc UpdateGraphYAxis {} {
    global ds9
    global view
    global graph

    # if not xpa update, don't update
    if {!$ds9(xpa,idletasks)} {
	return
    }

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateGraphYAxis"
    }

    if {$view(graph,horz) || $view(graph,vert)} {
	global debug
	if {$debug(tcl,idletasks)} {
	    puts "UpdateGraphYAxis"
	}
	update idletasks
    }
    
    if {$view(graph,horz)} {
	UpdateGraphYAxisHV $ds9(graph,horz) $graph(horz,log)
    }

    if {$view(graph,vert)} {
	UpdateGraphYAxisHV $ds9(graph,vert) $graph(vert,log)
    }
}

proc UpdateGraphYAxisHV {which log} {
    global current
    global graph

    if {$current(frame) != ""} {

	set minmax [$current(frame) get clip]
	set yMin [lindex $minmax 0]
	set yMax [lindex $minmax 1]

	if {$yMin >= $yMax} {
	    set yMax [expr $yMin + 1]
	}

	$which yaxis configure -min $yMin -max $yMax -logscale $log
	$which y2axis configure -min $yMin -max $yMax -logscale $log
    } else {
	$which yaxis configure -min $graph(y,min) -max $graph(y,max) \
	    -logscale $log
	$which y2axis configure -min $graph(y,min) -max $graph(y,max) \
	    -logscale $log
    }
}

proc ShowGraphData {} {
    global ds9
    global view

    if {$view(graph,horz)} {
	ShowGraphDataHV $ds9(graph,horz)
    }
    if {$view(graph,vert)} {
	ShowGraphDataHV $ds9(graph,vert)
    }
}

proc ShowGraphDataHV {which} {
    global current

    if {$current(frame) != ""} {
	if {[$current(frame) has fits]} {
	    $which element configure line1 -hide no
	} else {
	    $which element configure line1 -hide yes
	}
    } else {
	$which element configure line1 -hide yes
    }
}

proc ClearGraphData {} {
    global ds9
    global view

    if {$view(graph,horz)} {
	$ds9(graph,horz) element configure line1 -hide yes
    }    

    if {$view(graph,vert)} {
	$ds9(graph,vert) element configure line1 -hide yes
    }
}

proc UpdateGraph {which x y sys} {
    global ds9
    global view

    if {[$which has fits]} {
	if {$view(graph,horz)} {
	    $which get horizontal cut graphHorzX graphHorzY $x $y $sys
	    $ds9(graph,horz) element configure line1 -hide no
	}

	if {$view(graph,vert)} {
	    $which get vertical cut graphVertX graphVertY $x $y $sys
	    $ds9(graph,vert) element configure line1 -hide no
	}
    }
}

proc EnterGraph {which horz} {
    global ds9
    global current

    focus $which
    $which crosshairs on

    if {$current(frame) != "" && $ds9(mode) == "crosshair"} {
	set cursor [$which crosshairs cget -position]
	scan $cursor "@%d,%d" x y

	set coord [$current(frame) get crosshair canvas]
	set X [lindex $coord 0]
	set Y [lindex $coord 1]

	if {$horz} {
	    EnterInfoBox $current(frame) $x $Y canvas
	    UpdatePixelTable $current(frame) $x $Y canvas
	} else {
	    EnterInfoBox $current(frame) $X $y canvas
	    UpdatePixelTable $current(frame) $X $y canvas
	}
    }
}

proc LeaveGraph {which} {
    focus {}
    $which crosshairs off

    LeaveInfoBox
    ClearPixelTable
}

proc MotionGraph {which x y horz} {
    global ds9
    global current

    $which crosshairs configure -position "@$x,$y"

    if {$current(frame) != "" && $ds9(mode) == "crosshair"} {

	set coord [$current(frame) get crosshair canvas]
	set X [lindex $coord 0]
	set Y [lindex $coord 1]

	if {$horz} {
	    MotionInfoBox $current(frame) $x $Y canvas
	    UpdatePixelTable $current(frame) $x $Y canvas
	} else {
	    MotionInfoBox $current(frame) $X $y canvas
	    UpdatePixelTable $current(frame) $X $y canvas
	}
    }    
}

proc ArrowKeyGraph {which x y horz} {
    set cursor [$which crosshairs cget -position]
    scan $cursor "@%d,%d" cx cy

    set cx [expr $cx+$x]
    set cy [expr $cy+$y]

    MotionGraph $which $cx $cy $horz
}
