#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseAnnulusRectDialog {frame id width height unit major minor} {
    global marker
    global ds9

    set w ".marker$id"
    set unit2 [string totitle $unit]

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    set marker($frame,$id,method) dist

    # base
    MarkerBaseAnnulusDialog $frame $id $width $height
    set which $marker($frame,$id,which)

    # menus
    MarkerBaseDistMenu $frame $id $unit $unit2 ${which}DistCB dcoord dformat
    MarkerBaseAnnulusMethodMenu $frame $id

    # callbacks
    $frame marker $id callback edit ${which}EditCB $frame
    $frame marker $id callback end edit ${which}EditCB $frame
    $frame marker $id callback rotate MarkerBaseCenterRotateCB $frame

    # Radius
    label $w.ref.left.bottom.f.majorTitle -text $major
    label $w.ref.left.bottom.f.minorTitle -text $minor

    label $w.ref.left.bottom.f.outerTitle -text "Outer $unit2"
    entry $w.ref.left.bottom.f.radius1 \
	-textvariable marker($frame,$id,radius1) \
	-width 13 
    entry $w.ref.left.bottom.f.radius2 \
	-textvariable marker($frame,$id,radius2) \
	-width 13 
    label $w.ref.left.bottom.f.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4

    label $w.ref.left.bottom.f.innerTitle -text "Inner $unit2"
    entry $w.ref.left.bottom.f.radius3 \
	-textvariable marker($frame,$id,radius3) -width 13 

    label $w.ref.left.bottom.f.annuliTitle -text "Annuli"
    entry $w.ref.left.bottom.f.annuli -textvariable marker($frame,$id,annuli) \
	-width 13 

    label $w.ref.left.bottom.f.angleTitle -text "Angle"
    entry $w.ref.left.bottom.f.angle -textvariable marker($frame,$id,angle) \
	-width 13 
    label $w.ref.left.bottom.f.angleUnit -relief groove -width 9 \
	-padx 4 -text "degrees"

    grid x $w.ref.left.bottom.f.majorTitle $w.ref.left.bottom.f.minorTitle \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.outerTitle $w.ref.left.bottom.f.radius1 \
	$w.ref.left.bottom.f.radius2 $w.ref.left.bottom.f.radiusformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.innerTitle $w.ref.left.bottom.f.radius3 \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.annuliTitle $w.ref.left.bottom.f.annuli \
	-padx 4 -sticky w

    grid $w.ref.left.bottom.f.angleTitle $w.ref.left.bottom.f.angle x \
	$w.ref.left.bottom.f.angleUnit -padx 4 -sticky w

    # Right
    frame $w.ref.right.title
    frame $w.ref.right.value
    pack $w.ref.right.title $w.ref.right.value -side top -padx 4 -pady 4

    label $w.ref.right.title.title -text "Annuli"
    label $w.ref.right.title.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4

    grid $w.ref.right.title.title $w.ref.right.title.radiusformat \
	-padx 4 -sticky news

    set txtscr $w.ref.right.value.yscroll
    set marker($frame,$id,annulitxt) $w.ref.right.value.txt
    text $marker($frame,$id,annulitxt) -height 10 -width 15 -wrap none \
	-font {courier 12} -yscrollcommand "$txtscr set"
    scrollbar $txtscr -command [list $marker($frame,$id,annulitxt) yview] \
	-orient vertical

    grid $marker($frame,$id,annulitxt) $txtscr -sticky news

    # init - do this last
    ${which}DistCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}

# actions

proc MarkerBaseAnnulusRectClose {frame id} {
    global marker
    set which $marker($frame,$id,which)

    $frame marker $id delete callback edit ${which}EditCB
    $frame marker $id delete callback end edit ${which}EditCB
    $frame marker $id delete callback rotate MarkerBaseCenterRotateCB
    MarkerBaseCenterClose $frame $id
}

proc MarkerBaseAnnulusRectApply {frame id} {
    global marker
    set which $marker($frame,$id,which)

    set levels ""
    regsub -all "\n" "[$marker($frame,$id,annulitxt) get 1.0 end]" " " levels
    # and trim any trailing spaces
    set levels [string trimright $levels " "]

    if {$levels != {}} {
	$frame marker $id $which radius "\{$levels\}" \
	    $marker($frame,$id,dcoord) $marker($frame,$id,dformat)
    }

    MarkerBaseCenterRotate $frame $id
    MarkerBaseCenterApply $frame $id
}

# callbacks

proc MarkerBaseAnnulusRectCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}

proc MarkerBaseAnnulusRectEditCB {frame id} {
    global marker
    set which $marker($frame,$id,which)

    set t [$frame get marker $id $which radius \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set last [llength $t]
    set marker($frame,$id,annuli) [expr $last/2-1]
    set marker($frame,$id,radius1) [lindex $t [expr $last-2]]
    set marker($frame,$id,radius2) [lindex $t [expr $last-1]]
    set marker($frame,$id,radius3) [lindex $t 0]

    $marker($frame,$id,annulitxt) delete 1.0 end
    $marker($frame,$id,annulitxt) insert end "$t"
}

proc MarkerBaseAnnulusRectDistCB {frame id} {
    global marker
    set which $marker($frame,$id,which)

    MarkerBaseDistCB $frame $id
    ${which}EditCB $frame $id
}

proc MarkerBaseAnnulusRectDefaultDialog {which unit major minor} {
    global marker
    global ed

    set w ".${which}"

    set ed(ok) 0
    set ed(radius1) $marker($which,radius1)
    set ed(radius2) $marker($which,radius2)
    set ed(radius3) $marker($which,radius3)
    set ed(annuli) $marker($which,annuli)

    DialogCreate $w "Default $which" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.majorTitle -text $major
    label $w.ed.minorTitle -text $minor

    label $w.ed.innerTitle -text "Inner $unit"
    entry $w.ed.radius1 -textvariable ed(radius1) -width 10 	
    entry $w.ed.radius2 -textvariable ed(radius2) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8

    label $w.ed.outerTitle -text "Outer $unit"
    entry $w.ed.radius3 -textvariable ed(radius3) -width 10 

    label $w.ed.annuliTitle -text "Annuli"
    entry $w.ed.annuli -textvariable ed(annuli) -width 10 
    
    grid x $w.ed.majorTitle $w.ed.minorTitle -padx 4 -sticky w
    grid $w.ed.innerTitle $w.ed.radius1 $w.ed.radius2 $w.ed.unit \
	-padx 4 -sticky w
    grid $w.ed.outerTitle $w.ed.radius3 -padx 4 -sticky w
    grid $w.ed.annuliTitle $w.ed.annuli -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius1 select range 0 end
    DialogWait $w ed(ok) $w.ed.radius1
    DialogDismiss $w

    if {$ed(ok)} {
	set marker($which,radius1) $ed(radius1)
	set marker($which,radius2) $ed(radius2)
	set marker($which,radius3) $ed(radius3)
	set marker($which,annuli) $ed(annuli)
    }

    unset ed
}
