#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseLineDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    # variables - some may already initialized
    if {![info exists marker($frame,$id,dcoord)]} {
	set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    }
    set marker($frame,$id,dlabel) $marker($frame,$id,dcoord)
    if {![info exists marker($frame,$id,dformat)]} {
	set marker($frame,$id,dformat) $marker(dialog,dist,format)
    }

    # base
    MarkerBaseDialog $frame $id $width $height
    set which $marker($frame,$id,which)

    # init
    ${which}DistCB $frame $id

    # callbacks
    $frame marker $id callback move "${which}EditCB" $frame
    $frame marker $id callback edit "${which}EditCB" $frame

    # menus
    MarkerBaseDistMenu $frame $id dist Length ${which}DistCB dcoord dformat

    # dialog
    frame $w.dist -relief groove -borderwidth 2
    frame $w.dist.f
    pack $w.dist -fill x 
    pack $w.dist.f -anchor w -padx 4 -pady 4

    # Points
    label $w.ref.f.title -text "Points"
    entry $w.ref.f.x -textvariable marker($frame,$id,x) -width 13
    entry $w.ref.f.y -textvariable marker($frame,$id,y) -width 13
    label $w.ref.f.coord -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,clabel)
    entry $w.ref.f.x2 -textvariable marker($frame,$id,x2) -width 13
    entry $w.ref.f.y2 -textvariable marker($frame,$id,y2) -width 13

    grid $w.ref.f.title $w.ref.f.x $w.ref.f.y $w.ref.f.coord -padx 4 -sticky w
    grid x $w.ref.f.x2 $w.ref.f.y2 -padx 4 -sticky w

    # Length
    label $w.dist.f.dtitle -text "Length"
    label $w.dist.f.dist -relief groove -width 12  \
	-textvariable marker($frame,$id,dist)
    label $w.dist.f.format -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,dlabel)
    grid $w.dist.f.dtitle $w.dist.f.dist $w.dist.f.format -padx 4 -sticky w

    # Angle
    label $w.dist.f.angtitle -text "Angle"
    label $w.dist.f.angle -relief groove -width 12  \
	-textvariable marker($frame,$id,angle)
    label $w.dist.f.angformat -text "degrees" -relief groove -width 9 -padx 4
    grid $w.dist.f.angtitle $w.dist.f.angle $w.dist.f.angformat -row 3 \
	-padx 4 -sticky w
}

proc MarkerBaseLineClose {frame id} {
    global marker

    set which $marker($frame,$id,which)
    $frame marker $id delete callback move "${which}EditCB"
    $frame marker $id delete callback edit "${which}EditCB"

    MarkerBaseClose $frame $id
}

proc MarkerBaseLineApply {frame id} {
    global marker

    MarkerBaseApply $frame $id
}

proc MarkerBaseLineEditCB {frame id} {
    global marker

    set which $marker($frame,$id,which)

    set p [$frame get marker $id $which point \
	       $marker($frame,$id,system) $marker($frame,$id,sky) \
	       $marker($frame,$id,skyformat)]

    set marker($frame,$id,x) [lindex $p 0]
    set marker($frame,$id,y) [lindex $p 1]
    set marker($frame,$id,x2) [lindex $p 2]
    set marker($frame,$id,y2) [lindex $p 3]

}

