#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBasePandaDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    set marker($frame,$id,method) dist
    set marker($frame,$id,init) 0

    # base
    MarkerBaseAnnulusDialog $frame $id $width $height
    set which $marker($frame,$id,which)

    # menus
    MarkerBaseAnnulusMethodMenu $frame $id
    MarkerBaseDistMenu $frame $id radius Radius ${which}DistCB dcoord dformat

    # callbacks
    $frame marker $id callback edit ${which}EditCB $frame
    $frame marker $id callback end edit ${which}EditCB $frame

    # Angles
    label $w.ref.left.bottom.f.ang1Title -text "Start"
    label $w.ref.left.bottom.f.ang2Title -text "End"
    label $w.ref.left.bottom.f.anglesTitle -text "Angles"
    entry $w.ref.left.bottom.f.ang1 -textvariable marker($frame,$id,ang1) \
	-width 13
    entry $w.ref.left.bottom.f.ang2 -textvariable marker($frame,$id,ang2) \
	-width 13
    label $w.ref.left.bottom.f.anglesformat -text "degrees" \
	-relief groove -width 9 -padx 4
    label $w.ref.left.bottom.f.angnumTitle -text "Number"
    entry $w.ref.left.bottom.f.angnum -textvariable marker($frame,$id,angnum) \
	-width 13

    grid x $w.ref.left.bottom.f.ang1Title $w.ref.left.bottom.f.ang2Title \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.anglesTitle $w.ref.left.bottom.f.ang1 \
	$w.ref.left.bottom.f.ang2 $w.ref.left.bottom.f.anglesformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.angnumTitle $w.ref.left.bottom.f.angnum \
	-padx 4 -sticky w

    # Right
    frame $w.ref.right.radius -relief groove -borderwidth 2
    frame $w.ref.right.angles -relief groove -borderwidth 2
    pack $w.ref.right.radius $w.ref.right.angles -side left

    # Radius
    frame $w.ref.right.radius.title
    frame $w.ref.right.radius.value
    pack $w.ref.right.radius.title $w.ref.right.radius.value \
	-side top -padx 4 -pady 4

    label $w.ref.right.radius.title.title -text "Radius"
    label $w.ref.right.radius.title.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4

    grid $w.ref.right.radius.title.title \
	$w.ref.right.radius.title.radiusformat \
	-padx 4 -sticky news

    set txtscr $w.ref.right.radius.value.yscroll
    set marker($frame,$id,annulitxt) $w.ref.right.radius.value.txt
    text $marker($frame,$id,annulitxt) -height 15 -width 15 -wrap none \
	-font {courier 12} -yscrollcommand "$txtscr set"
    scrollbar $txtscr -command [list $marker($frame,$id,annulitxt) yview] \
	-orient vertical

    grid $marker($frame,$id,annulitxt) $txtscr -sticky news

    # Angles
    frame $w.ref.right.angles.title
    frame $w.ref.right.angles.value
    pack $w.ref.right.angles.title $w.ref.right.angles.value \
	-side top -padx 4 -pady 4

    label $w.ref.right.angles.title.title -text "Angles"
    label $w.ref.right.angles.title.anglesformat -text "degrees" \
	-relief groove -width 9 -padx 4

    grid $w.ref.right.angles.title.title \
	$w.ref.right.angles.title.anglesformat \
	-padx 4 -sticky news

    set txtscr $w.ref.right.angles.value.yscroll
    set marker($frame,$id,angtxt) $w.ref.right.angles.value.txt
    text $marker($frame,$id,angtxt) -height 15 -width 15 -wrap none \
	-font {courier 12} -yscrollcommand "$txtscr set"
    scrollbar $txtscr -command [list $marker($frame,$id,angtxt) yview] \
	-orient vertical

    grid $marker($frame,$id,angtxt) $txtscr -sticky news

    set marker($frame,$id,init) 1
}

# actions

proc MarkerBasePandaClose {frame id} {
    global marker

    set which $marker($frame,$id,which)
    $frame marker $id delete callback edit ${which}EditCB
    $frame marker $id delete callback end edit ${which}EditCB
    MarkerBaseCenterClose $frame $id
}

proc MarkerBasePandaApply {frame id} {
    global marker

    set which $marker($frame,$id,which)
    set levels ""
    regsub -all "\n" "[$marker($frame,$id,annulitxt) get 1.0 end]" " " levels
    # and trim any trailing spaces
    set levels [string trimright $levels " "]

    set angles ""
    regsub -all "\n" "[$marker($frame,$id,angtxt) get 1.0 end]" " " angles
    # and trim any trailing spaces
    set angles [string trimright $angles " "]

    if {($levels != {}) && ($angles != {})} {
	$frame marker $id $which edit "\{$angles\}" "\{$levels\}" \
	    $marker($frame,$id,system) $marker($frame,$id,sky) \
	    $marker($frame,$id,dcoord) $marker($frame,$id,dformat)
    }

    MarkerBaseCenterApply $frame $id
}

proc MarkerBasePandaGenerateAngles {frame id} {
    global marker

    $marker($frame,$id,angtxt) delete 1.0 end

    set ang1 $marker($frame,$id,ang1)
    set ang2 $marker($frame,$id,ang2)
    set angnum $marker($frame,$id,angnum)

    if {($ang1 != {}) && ($ang2 != {}) && ($angnum != {})} {
	set s1 $ang1
	set s2 $ang2

	if {$s1 < 0} {
	    set s1 [expr $s1+360]
	    set s2 [expr $s2+360]
	}
	if {$s1 > 360} {
	    set s1 [expr $s1-360]
	    set s2 [expr $s2-360]
	}

	if {$s1 >= $s2} {
	    set s2 [expr $s2+360]
	}

	for {set i 0} {$i<=$angnum} {incr i} {
	    set v [expr ((($s2-$s1)/double($angnum))*$i)+$s1]
	    if {$v > 360} {
		set v [expr $v-360]
	    }
	    $marker($frame,$id,angtxt) insert end "$v\n"
	}
    }
}

# callbacks


proc MarkerBasePandaCoordCB {frame id} {
    global marker

    set which $marker($frame,$id,which)
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
    if {$marker($frame,$id,init)} {
	${which}EditCB $frame $id
    }
}

proc MarkerBasePandaDistCB {frame id} {
    global marker

    set which $marker($frame,$id,which)
    MarkerBaseDistCB $frame $id
    ${which}EditCB $frame $id
}

