.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "reggeometry n"
.TH reggeometry n "August 12, 2005" "version 1.3.0b9" "SAORD Documentation"
.SH "NAME"
\&\fBRegGeometry: Geometric Shapes in Spatial Region Filtering\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document describes the geometry of regions available for spatial
filtering in \s-1IRAF/PROS\s0 analysis.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBGeometric shapes\fR
.PP
Several   geometric shapes are  used to   describe  regions. The valid
shapes are:
.PP
.Vb 11
\&  shape:        arguments:
\&  -----         ---------
\&  ANNULUS       xcenter ycenter inner_radius outer_radius
\&  BOX           xcenter ycenter xwidth yheight (angle)
\&  CIRCLE        xcenter ycenter radius
\&  ELLIPSE       xcenter ycenter xwidth yheight (angle)
\&  FIELD         none
\&  LINE          x1 y1 x2 y2
\&  PIE           xcenter ycenter angle1 angle2
\&  POINT         x1 y1
\&  POLYGON       x1 y1 x2 y2 ... xn yn
.Ve
.PP
All arguments are real values; integer values are automatically
converted to real where necessary.  All angles are in degrees and
specify angles that run counter-clockwise from the positive y\-axis.
.PP
Shapes can be specified using \*(L"command\*(R" syntax:
.PP
.Vb 1
\&  [shape] arg1 arg2 ...
.Ve
.PP
or using \*(L"routine\*(R" syntax:
.PP
.Vb 1
\&  [shape](arg1, arg2, ...)
.Ve
.PP
or by any combination of the these. (Of course, the parentheses must
balance and there cannot be more commas than necessary.) The shape
keywords are case\-insensitive.  Furthermore, any shape can be
specified by a three-character unique abbreviation.  For example, one
can specify three circular regions as:
.PP
.Vb 1
\&  "foo.fits[CIRCLE 512 512 50;CIR(128 128, 10);cir(650,650,20)]"
.Ve
.PP
(Quotes generally are required to protect the region descriptor
from being processed by the Unix shell.)
.PP
The  \fBannulus\fR    shape  specifies  annuli, centered  at  xcenter,
ycenter, with inner and outer radii (r1, r2). For example,
.PP
.Vb 1
\&  ANNULUS 25 25 5 10
.Ve
.PP
specifies an annulus centered at 25.0 25.0 with an inner radius of 5.0 and
an outer radius of 10. Assuming (as will be done for all examples in this
document, unless otherwise noted) this shape is used in a mask of size 40x40,
it will look like this:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:....................111111111...........
\&      33:...................11111111111..........
\&      32:.................111111111111111........
\&      31:.................111111111111111........
\&      30:................11111111111111111.......
\&      29:...............1111111.....1111111......
\&      28:...............111111.......111111......
\&      27:...............11111.........11111......
\&      26:...............11111.........11111......
\&      25:...............11111.........11111......
\&      24:...............11111.........11111......
\&      23:...............11111.........11111......
\&      22:...............111111.......111111......
\&      21:...............1111111.....1111111......
\&      20:................11111111111111111.......
\&      19:.................111111111111111........
\&      18:.................111111111111111........
\&      17:...................11111111111..........
\&      16:....................111111111...........
\&      15:........................................
\&      14:........................................
\&      13:........................................
\&      12:........................................
\&      11:........................................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:........................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
The \fBbox\fR shape specifies an orthogonally oriented box,
centered at xcenter, ycenter, of size xwidth, yheight. It requires four
arguments and accepts an optional fifth argument to specify a rotation angle.
When the rotation angle is specified (in degrees), the box is rotated by
an angle that runs counter-clockwise from the positive y\-axis.
.PP
The \fBbox\fR shape specifies a rotated box, centered at
xcenter, ycenter, of size xwidth, yheight. The box is rotated by an angle
specified in degrees that runs counter-clockwise from the positive y\-axis.
If the angle argument is omitted, it defaults to 0.
.PP
The \fBcircle\fR shape specifies a circle, centered at xcenter,
ycenter, of radius r.  It requires three arguments.
.PP
The \fBellipse\fR shape specifies an ellipse, centered at
xcenter, ycenter, with y\-axis width a and the y\-axis length b defined such
that:
.PP
.Vb 1
\&  x**2/a**2 + y**2/b**2 = 1
.Ve
.PP
Note that a can be less than, equal to, or greater than b. The ellipse
is rotated the specified number of degrees.  The rotation is done according
to astronomical convention, counter-clockwise from the positive y\-axis.
An ellipse defined by:
.PP
.Vb 1
\&  ELLIPSE 20 20 5 10 45
.Ve
.PP
will look like this:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:........................................
\&      29:........................................
\&      28:........................................
\&      27:............111111......................
\&      26:............11111111....................
\&      25:............111111111...................
\&      24:............11111111111.................
\&      23:............111111111111................
\&      22:............111111111111................
\&      21:.............111111111111...............
\&      20:.............1111111111111..............
\&      19:..............111111111111..............
\&      18:...............111111111111.............
\&      17:...............111111111111.............
\&      16:................11111111111.............
\&      15:..................111111111.............
\&      14:...................11111111.............
\&      13:.....................111111.............
\&      12:........................................
\&      11:........................................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:........................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
The \fBfield\fR shape specifies the entire field as a
region.  It is not usually specified explicitly, but is used implicitly in the
case where no regions are specified, that is, in cases where either a null
string or some abbreviation of the string \*(L"none\*(R" is input.
\&\fBField\fR takes no arguments.
.PP
The \fBpie\fR shape specifies an angular wedge of the entire field,
centered at xcenter, ycenter.  The wedge runs between the two specified angles.
The angles are given in degrees, running counter-clockwise from the positive
y\-axis. For example,
.PP
.Vb 1
\&  PIE 20 20 90 180
.Ve
.PP
defines a region from 90 degrees to 180 degrees, i.e., quadrant 3 of the
Cartesian plane. The display of such a region looks like this:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:........................................
\&      29:........................................
\&      28:........................................
\&      27:........................................
\&      26:........................................
\&      25:........................................
\&      24:........................................
\&      23:........................................
\&      22:........................................
\&      21:........................................
\&      20:11111111111111111111....................
\&      19:11111111111111111111....................
\&      18:11111111111111111111....................
\&      17:11111111111111111111....................
\&      16:11111111111111111111....................
\&      15:11111111111111111111....................
\&      14:11111111111111111111....................
\&      13:11111111111111111111....................
\&      12:11111111111111111111....................
\&      11:11111111111111111111....................
\&      10:11111111111111111111....................
\&       9:11111111111111111111....................
\&       8:11111111111111111111....................
\&       7:11111111111111111111....................
\&       6:11111111111111111111....................
\&       5:11111111111111111111....................
\&       4:11111111111111111111....................
\&       3:11111111111111111111....................
\&       2:11111111111111111111....................
\&       1:11111111111111111111....................
.Ve
.PP
The pie slice specified is always a counter-clockwise sweep between
the angles, starting at the first angle and ending at the second.  Thus:
.PP
.Vb 1
\&  PIE 10 15 30 60
.Ve
.PP
describes a 30 degree sweep from 11 o'clock to 10 o'clock, while:
.PP
.Vb 1
\&  PIE 10 15 60 30
.Ve
.PP
describes a 330 degree counter-clockwise sweep from 10 o'clock to 11 o'clock
passing through 12 o'clock (0 degrees). Note in both of these examples that
the center of the slice can be anywhere on the plane.  The second mask looks
like this:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:1111111111111111111111111111111111111111
\&      39:1111111111111111111111111111111111111111
\&      38:1111111111111111111111111111111111111111
\&      37:1111111111111111111111111111111111111111
\&      36:1111111111111111111111111111111111111111
\&      35:1111111111111111111111111111111111111111
\&      34:1111111111111111111111111111111111111111
\&      33:1111111111111111111111111111111111111111
\&      32:1111111111111111111111111111111111111111
\&      31:1111111111111111111111111111111111111111
\&      30:.111111111111111111111111111111111111111
\&      29:.111111111111111111111111111111111111111
\&      28:..11111111111111111111111111111111111111
\&      27:...1111111111111111111111111111111111111
\&      26:...1111111111111111111111111111111111111
\&      25:....111111111111111111111111111111111111
\&      24:....111111111111111111111111111111111111
\&      23:.....11111111111111111111111111111111111
\&      22:.....11111111111111111111111111111111111
\&      21:......1111111111111111111111111111111111
\&      20:1......111111111111111111111111111111111
\&      19:111....111111111111111111111111111111111
\&      18:1111....11111111111111111111111111111111
\&      17:111111..11111111111111111111111111111111
\&      16:11111111.1111111111111111111111111111111
\&      15:1111111111111111111111111111111111111111
\&      14:1111111111111111111111111111111111111111
\&      13:1111111111111111111111111111111111111111
\&      12:1111111111111111111111111111111111111111
\&      11:1111111111111111111111111111111111111111
\&      10:1111111111111111111111111111111111111111
\&       9:1111111111111111111111111111111111111111
\&       8:1111111111111111111111111111111111111111
\&       7:1111111111111111111111111111111111111111
\&       6:1111111111111111111111111111111111111111
\&       5:1111111111111111111111111111111111111111
\&       4:1111111111111111111111111111111111111111
\&       3:1111111111111111111111111111111111111111
\&       2:1111111111111111111111111111111111111111
\&       1:1111111111111111111111111111111111111111
.Ve
.PP
The pie slice goes to the edge of the field. To limit its scope, pie
usually is is combined with other shapes, such as circles and annuli,
using boolean operations. (See below and in \*(L"help regalgebra\*(R").
.PP
Pie Performance Notes: 
.PP
Pie region processing time is proportional to the size of the image,
and not the size of the region. This is because the pie shape is the
only infinite length shape, and we essentially must check all y rows
for inclusion (unlike other regions, where the y limits can be
calculated beforehand). Thus, pie can run very slowly on large images.
In particular, it will run \s-1MUCH\s0 more slowly than the panda shape in
image-based region operations (such as funcnts). We recommend use of
panda over pie where ever possible.
.PP
If you must use pie, always try to put it last in a boolean &&
expression.  The reason for this is that the filter code is optimized
to exit as soon as the result is know. Since pie is the slowest
region, it is better to avoid executing it if another region can decide
the result. Consider, for example, the difference in time required to
process a Chandra \s-1ACIS\s0 file when a pie and circle are combined in
two different orders:
.PP
.Vb 2
\&  time ./funcnts nacis.fits "circle 4096 4096 100 && pie 4096 4096 10 78"
\&2.87u 0.38s 0:35.08 9.2%
.Ve
.PP
.Vb 2
\&  time ./funcnts nacis.fits "pie 4096 4096 10 78 && circle 4096 4096 100 "
\&89.73u 0.36s 1:03.50 141.8%
.Ve
.PP
Black-magic performance note:
.PP
Panda region processing uses a \fBquick test\fR pie region instead of
the normal pie region when combining its annulus and pie shapes. This
\&\fBqtpie\fR shape differs from the normal pie in that it utilizes the
y limits from the previous region with which it is combined. In a
panda shape, which is a series of annuli combined with pies, the
processing time is thus reduced to that of the annuli.
.PP
You can use the qtpie shape instead of pie in cases where you are
combining pie with another shape using the && operator. This will
cause the pie limits to be set using limits from the other shape, and
will speed up the processing considerably.  For example, the above
execution of funcnts can be improved considerably using this technique:
.PP
.Vb 2
\&  time ./funcnts nacis.fits "circle 4096 4096 100 && qtpie 4096 4096 10 78"
\&4.66u 0.33s 0:05.87 85.0%
.Ve
.PP
We emphasize that this is a quasi-documented feature and might change in
the future. The qtpie shape is not recognized by ds9 or other programs.
.PP
The \fBline\fR shape allows single pixels in a line between (x1,y1) and
(x2,y2) to be included or excluded. For example:
.PP
.Vb 1
\&  LINE (5,6, 24,25)
.Ve
.PP
displays as:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:........................................
\&      29:........................................
\&      28:........................................
\&      27:........................................
\&      26:........................................
\&      25:.......................1................
\&      24:......................1.................
\&      23:.....................1..................
\&      22:....................1...................
\&      21:...................1....................
\&      20:..................1.....................
\&      19:.................1......................
\&      18:................1.......................
\&      17:...............1........................
\&      16:..............1.........................
\&      15:.............1..........................
\&      14:............1...........................
\&      13:...........1............................
\&      12:..........1.............................
\&      11:.........1..............................
\&      10:........1...............................
\&       9:.......1................................
\&       8:......1.................................
\&       7:.....1..................................
\&       6:....1...................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
The \fBpoint\fR shape allows single pixels to be included or
excluded.  Although the (x,y) values are real numbers, they are truncated
to integer and the corresponding pixel is included or excluded, as specified.
.PP
Several points can be put in one region declaration; unlike the
original \s-1IRAF\s0 implementation, each now is given a different region mask value.
This makes it easier, for example, for funcnts to determine the number of
photons in the individual pixels. For example,
.PP
.Vb 1
\&  POINT (5,6,  10,11,  20,20,  35,30)
.Ve
.PP
will give the different region mask values to all four points, as shown below:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:..................................4.....
\&      29:........................................
\&      28:........................................
\&      27:........................................
\&      26:........................................
\&      25:........................................
\&      24:........................................
\&      23:........................................
\&      22:........................................
\&      21:........................................
\&      20:...................3....................
\&      19:........................................
\&      18:........................................
\&      17:........................................
\&      16:........................................
\&      15:........................................
\&      14:........................................
\&      13:........................................
\&      12:........................................
\&      11:.........2..............................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:....1...................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
The \fBpolygon\fR shape specifies a polygon with vertices
(x1, y1) ... (xn, yn). The polygon is closed automatically: one should
not specify the last vertex to be the same as the first.  Any number of
vertices are allowed.  For example, the following polygon defines a
right triangle as shown below:
.PP
.Vb 1
\&  POLYGON (10,10,  10,30,  30,30)
.Ve
.PP
looks like this:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:..........11111111111111111111..........
\&      29:..........1111111111111111111...........
\&      28:..........111111111111111111............
\&      27:..........11111111111111111.............
\&      26:..........1111111111111111..............
\&      25:..........111111111111111...............
\&      24:..........11111111111111................
\&      23:..........1111111111111.................
\&      22:..........111111111111..................
\&      21:..........11111111111...................
\&      20:..........1111111111....................
\&      19:..........111111111.....................
\&      18:..........11111111......................
\&      17:..........1111111.......................
\&      16:..........111111........................
\&      15:..........11111.........................
\&      14:..........1111..........................
\&      13:..........111...........................
\&      12:..........11............................
\&      11:..........1.............................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:........................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
Note that polygons can get twisted upon themselves if edge lines
cross.  Thus:
.PP
.Vb 1
\&  POL (10,10,  20,20,  20,10,  10,20)
.Ve
.PP
will produce an area which is two triangles, like butterfly wings, as shown
below:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:........................................
\&      33:........................................
\&      32:........................................
\&      31:........................................
\&      30:........................................
\&      29:........................................
\&      28:........................................
\&      27:........................................
\&      26:........................................
\&      25:........................................
\&      24:........................................
\&      23:........................................
\&      22:........................................
\&      21:........................................
\&      20:........................................
\&      19:..........1........1....................
\&      18:..........11......11....................
\&      17:..........111....111....................
\&      16:..........1111..1111....................
\&      15:..........1111111111....................
\&      14:..........1111..1111....................
\&      13:..........111....111....................
\&      12:..........11......11....................
\&      11:..........1........1....................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:........................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
The following are combinations of pie with different shapes
(called \*(L"panda\*(R" for \*(L"Pie \s-1AND\s0 Annulus\*(R") allow for easy specification of
radial sections:
.PP
.Vb 6
\&  shape:        arguments:
\&  -----         ---------
\&  PANDA         xcen ycen ang1 ang2 nang irad orad nrad                 # circular
\&  CPANDA        xcen ycen ang1 ang2 nang irad orad nrad                 # circular
\&  BPANDA        xcen ycen ang1 ang2 nang xwlo yhlo xwhi yhhi nrad (ang) # box
\&  EPANDA        xcen ycen ang1 ang2 nang xwlo yhlo xwhi yhhi nrad (ang) # ellipse
.Ve
.PP
The \fBpanda\fR (\fBP\fRies \fB\s-1AND\s0\fR \fBA\fRnnuli) shape can be
used to create combinations of pie and annuli markers. It is analogous
to a Cartesian product on those shapes, i.e., the result is several
shapes generated by performing a boolean \s-1AND\s0 between pies and
annuli. Thus, the panda and cpanda specify combinations of annulus and
circle with pie, respectively and give identical results. The bpanda
combines box and pie, while epanda combines ellipse and pie.
.PP
Consider the example shown below:
.PP
.Vb 1
\&  PANDA(20,20, 0,360,3, 0,15,4)
.Ve
.PP
Here, 3 pie slices centered at 20, 20 are combined with 4 annuli, also
centered at 20, 20. The result is a mask with 12 regions (displayed in
base 16 to save characters):
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:..............444444ccccc...............
\&      33:............44444444ccccccc.............
\&      32:...........444444444cccccccc............
\&      31:.........44444444333bbcccccccc..........
\&      30:........444444333333bbbbbcccccc.........
\&      29:........444443333333bbbbbbccccc.........
\&      28:.......4444433333333bbbbbbbccccc........
\&      27:......44444333333222aabbbbbbccccc.......
\&      26:......44443333322222aaaabbbbbcccc.......
\&      25:.....444433333222222aaaaabbbbbcccc......
\&      24:.....444433332222222aaaaaabbbbcccc......
\&      23:.....44443333222211199aaaabbbbcccc......
\&      22:.....444333322221111999aaaabbbbccc......
\&      21:.....444333322221111999aaaabbbbccc......
\&      20:.....444333322221111999aaaabbbbccc......
\&      19:.....444333322221155599aaaabbbbccc......
\&      18:.....444333322225555555aaaabbbbccc......
\&      17:.....44443333266655555666abbbbcccc......
\&      16:.....444433336666666666666bbbbcccc......
\&      15:.....44443377766666666666777bbcccc......
\&      14:......444877777666666666777778ccc.......
\&      13:......48888777777666667777778888c.......
\&      12:.......8888877777777777777788888........
\&      11:........88888777777777777788888.........
\&      10:........88888877777777777888888.........
\&       9:.........888888887777788888888..........
\&       8:...........88888888888888888............
\&       7:............888888888888888.............
\&       6:..............88888888888...............
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
Several regions with different mask values can be combined in the 
same mask.  This supports comparing data from the different regions.  
(For information on how to combine different shapes into a single 
region, see \*(L"help regalgebra\*(R".)  For example, consider the following 
set of regions:
.PP
.Vb 3
\&  ANNULUS 25 25 5 10
\&  ELLIPSE 20 20 5 10 315 
\&  BOX 15 15 5 10
.Ve
.PP
The resulting mask will look as follows:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:........................................
\&      38:........................................
\&      37:........................................
\&      36:........................................
\&      35:........................................
\&      34:....................111111111...........
\&      33:...................11111111111..........
\&      32:.................111111111111111........
\&      31:.................111111111111111........
\&      30:................11111111111111111.......
\&      29:...............1111111.....1111111......
\&      28:...............111111.......111111......
\&      27:...............11111.222222..11111......
\&      26:...............111112222222..11111......
\&      25:...............111112222222..11111......
\&      24:...............111112222222..11111......
\&      23:...............111112222222..11111......
\&      22:...............111111222222.111111......
\&      21:..............211111112222.1111111......
\&      20:............322211111111111111111.......
\&      19:............32222111111111111111........
\&      18:............22222111111111111111........
\&      17:............222222211111111111..........
\&      16:............22222222111111111...........
\&      15:............222222222...................
\&      14:............22222222....................
\&      13:............222222......................
\&      12:............33333.......................
\&      11:............33333.......................
\&      10:........................................
\&       9:........................................
\&       8:........................................
\&       7:........................................
\&       6:........................................
\&       5:........................................
\&       4:........................................
\&       3:........................................
\&       2:........................................
\&       1:........................................
.Ve
.PP
Note that when a pixel is in 2 or more regions, it is arbitrarily
assigned to a one of the regions in question (often based on how a
give C compiler optimizes boolean expressions).
.PP
\&\fBRegion accelerators\fR
.PP
Two types of \efBaccelerators, to simplify region specification,
are provided as natural extensions to the ways shapes are described.
These are: extended lists of parameters, specifying multiple regions,
valid for annulus, box, circle, ellipse, pie, and points; and 
\&\fBn=\fR, valid for annulus, box, circle, ellipse, and pie (not
point).  In both cases, one specification is used to define several
different regions, that is, to define shapes with different mask
values in the region mask.
.PP
The following regions accept \fBaccelerator\fR syntax:
.PP
.Vb 13
\&  shape         arguments
\&  -----         ---------
\&  ANNULUS       xcenter ycenter radius1 radius2 ... radiusn
\&  ANNULUS       xcenter ycenter inner_radius outer_radius n=[number]
\&  BOX           xcenter ycenter xw1 yh1 xw2 yh2 ... xwn yhn (angle)
\&  BOX           xcenter ycenter xwlo yhlo xwhi yhhi n=[number] (angle)
\&  CIRCLE        xcenter ycenter r1 r2 ... rn              # same as annulus
\&  CIRCLE        xcenter ycenter rinner router n=[number]  # same as annulus
\&  ELLIPSE       xcenter ycenter xw1 yh1 xw2 yh2 ... xwn yhn (angle)
\&  ELLIPSE       xcenter ycenter xwlo yhlo xwhi yhhi n=[number] (angle)
\&  PIE           xcenter ycenter angle1 angle2 (angle3) (angle4) (angle5) ...
\&  PIE           xcenter ycenter angle1 angle2 (n=[number])
\&  POINT         x1 y1 x2 y2 ... xn yn
.Ve
.PP
Note that the circle accelerators are simply aliases for the annulus
accelerators.  
.PP
For example, several annuli at the same center can be specified in one
region expression by specifying more than two radii.  If \fBN\fR
radii are specified, then \fBN\fR\-1 annuli result, with the outer
radius of each preceding annulus being the inner radius of the
succeeding annulus.  Each annulus is considered a separate region, and
is given a separate mask value. For example,
.PP
.Vb 1
\&  ANNULUS 20 20 0 2 5 10 15 20
.Ve
.PP
specifies five different annuli centered at 20 20, and is equivalent to:
.PP
.Vb 5
\&  ANNULUS 20.0 20.0  0  2
\&  ANNULUS       20.0 20.0  2  5
\&  ANNULUS 20.0 20.0  5 10
\&  ANNULUS 20.0 20.0 10 15
\&  ANNULUS 20.0 20.0 15 20
.Ve
.PP
The mask is shown below:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:........................................
\&      39:.............5555555555555..............
\&      38:...........55555555555555555............
\&      37:.........555555555555555555555..........
\&      36:........55555555555555555555555.........
\&      35:......555555555555555555555555555.......
\&      34:.....55555555544444444444555555555......
\&      33:....5555555544444444444444455555555.....
\&      32:....5555555444444444444444445555555.....
\&      31:...555555444444444444444444444555555....
\&      30:..55555544444444444444444444444555555...
\&      29:..55555544444443333333334444444555555...
\&      28:.5555554444444333333333334444444555555..
\&      27:.5555544444433333333333333344444455555..
\&      26:555555444444333333333333333444444555555.
\&      25:555554444443333333333333333344444455555.
\&      24:555554444433333332222233333334444455555.
\&      23:555554444433333322222223333334444455555.
\&      22:555554444433333222222222333334444455555.
\&      21:555554444433333222111222333334444455555.
\&      20:555554444433333222111222333334444455555.
\&      19:555554444433333222111222333334444455555.
\&      18:555554444433333222222222333334444455555.
\&      17:555554444433333322222223333334444455555.
\&      16:555554444433333332222233333334444455555.
\&      15:555554444443333333333333333344444455555.
\&      14:555555444444333333333333333444444555555.
\&      13:.5555544444433333333333333344444455555..
\&      12:.5555554444444333333333334444444555555..
\&      11:..55555544444443333333334444444555555...
\&      10:..55555544444444444444444444444555555...
\&       9:...555555444444444444444444444555555....
\&       8:....5555555444444444444444445555555.....
\&       7:....5555555544444444444444455555555.....
\&       6:.....55555555544444444444555555555......
\&       5:......555555555555555555555555555.......
\&       4:........55555555555555555555555.........
\&       3:.........555555555555555555555..........
\&       2:...........55555555555555555............
\&       1:.............5555555555555..............
.Ve
.PP
For boxes and ellipses, if an odd number of arguments is specified,
then the last argument is assumed to be an angle. Otherwise, the
angle is assumed to be zero. For example:
.PP
.Vb 1
\&  ellipse 20 20 3 5 6 10 9 15 12 20 45
.Ve
.PP
specifies an 3 ellipses at a 45 degree angle:
.PP
.Vb 42
\&        1234567890123456789012345678901234567890
\&        ----------------------------------------
\&        40:........................................
\&        39:........................................
\&        38:........................................
\&        37:........................................
\&        36:........33333333........................
\&        35:......333333333333......................
\&        34:.....3333333333333333...................
\&        33:....333333333333333333..................
\&        32:....33333332222233333333................
\&        31:...3333332222222222333333...............
\&        30:...33333222222222222233333..............
\&        29:...333332222222222222223333.............
\&        28:...3333222222211112222223333............
\&        27:...33332222211111111222223333...........
\&        26:...333322222111111111122223333..........
\&        25:...3333222211111111111122223333.........
\&        24:....3332222111111.11111122223333........
\&        23:....333322211111.....11112222333........
\&        22:....33332222111.......11112223333.......
\&        21:.....33322221111.......11122223333......
\&        20:.....33332221111.......11112223333......
\&        19:.....33332222111.......11112222333......
\&        18:......33332221111.......11122223333.....
\&        17:.......33322221111.....111112223333.....
\&        16:.......33332222111111.1111112222333.....
\&        15:........3333222211111111111122223333....
\&        14:.........333322221111111111222223333....
\&        13:..........33332222211111111222223333....
\&        12:...........3333222222111122222223333....
\&        11:............333322222222222222233333....
\&        10:.............33333222222222222233333....
\&        9:..............3333332222222222333333....
\&        8:...............33333333222223333333.....
\&        7:.................333333333333333333.....
\&        6:..................3333333333333333......
\&        5:.....................333333333333.......
\&        4:.......................33333333.........
\&        3:........................................
\&        2:........................................
\&        1:........................................
.Ve
.PP
Note in the above example that the lower limit is not part of the
region for boxes, circles, and ellipses. This makes circles and annuli
equivalent, i.e.:
.PP
.Vb 2
\&  circle  20 20 5 10 15 20
\&  annulus 20 20 5 10 15 20
.Ve
.PP
both give the following region mask:
.PP
.Vb 42
\&        1234567890123456789012345678901234567890
\&        ----------------------------------------
\&        40:........................................
\&        39:.............3333333333333..............
\&        38:...........33333333333333333............
\&        37:.........333333333333333333333..........
\&        36:........33333333333333333333333.........
\&        35:......333333333333333333333333333.......
\&        34:.....33333333322222222222333333333......
\&        33:....3333333322222222222222233333333.....
\&        32:....3333333222222222222222223333333.....
\&        31:...333333222222222222222222222333333....
\&        30:..33333322222222222222222222222333333...
\&        29:..33333322222221111111112222222333333...
\&        28:.3333332222222111111111112222222333333..
\&        27:.3333322222211111111111111122222233333..
\&        26:333333222222111111111111111222222333333.
\&        25:333332222221111111111111111122222233333.
\&        24:33333222221111111.....11111112222233333.
\&        23:3333322222111111.......1111112222233333.
\&        22:333332222211111.........111112222233333.
\&        21:333332222211111.........111112222233333.
\&        20:333332222211111.........111112222233333.
\&        19:333332222211111.........111112222233333.
\&        18:333332222211111.........111112222233333.
\&        17:3333322222111111.......1111112222233333.
\&        16:33333222221111111.....11111112222233333.
\&        15:333332222221111111111111111122222233333.
\&        14:333333222222111111111111111222222333333.
\&        13:.3333322222211111111111111122222233333..
\&        12:.3333332222222111111111112222222333333..
\&        11:..33333322222221111111112222222333333...
\&        10:..33333322222222222222222222222333333...
\&        9:...333333222222222222222222222333333....
\&        8:....3333333222222222222222223333333.....
\&        7:....3333333322222222222222233333333.....
\&        6:.....33333333322222222222333333333......
\&        5:......333333333333333333333333333.......
\&        4:........33333333333333333333333.........
\&        3:.........333333333333333333333..........
\&        2:...........33333333333333333............
\&        1:.............3333333333333..............
.Ve
.PP
As a final example, specifying several angles in one pie slice
expression is equivalent to specifying several separate slices with
the same center.  As with the annulus, if \fBN\fR angles are
specified, then \fBN\fR\-1 slices result, with the ending angle of
each preceding slice being the starting angle of the succeeding slice.
Each slice is considered a separate region, and is given a separate
mask value. For example, 
.PP
.Vb 1
\&  PIE 12 12 315 45 115 270
.Ve
.PP
specifies three regions as shown below:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&      40:1111111111111111111111111111111111111111
\&      39:111111111111111111111111111111111111111.
\&      38:11111111111111111111111111111111111111..
\&      37:1111111111111111111111111111111111111...
\&      36:111111111111111111111111111111111111....
\&      35:11111111111111111111111111111111111.....
\&      34:1111111111111111111111111111111111......
\&      33:111111111111111111111111111111111.......
\&      32:11111111111111111111111111111111........
\&      31:1111111111111111111111111111111.........
\&      30:111111111111111111111111111111..........
\&      29:11111111111111111111111111111...........
\&      28:1111111111111111111111111111............
\&      27:111111111111111111111111111.............
\&      26:11111111111111111111111111..............
\&      25:1111111111111111111111111...............
\&      24:111111111111111111111111................
\&      23:21111111111111111111111.................
\&      22:2211111111111111111111..................
\&      21:222111111111111111111...................
\&      20:22221111111111111111....................
\&      19:2222211111111111111.....................
\&      18:222222111111111111......................
\&      17:22222221111111111.......................
\&      16:2222222211111111........................
\&      15:222222222111111.........................
\&      14:22222222221111..........................
\&      13:2222222222211...........................
\&      12:2222222222223333333333333333333333333333
\&      11:2222222223333333333333333333333333333333
\&      10:2222222333333333333333333333333333333333
\&       9:2222233333333333333333333333333333333333
\&       8:2223333333333333333333333333333333333333
\&       7:2333333333333333333333333333333333333333
\&       6:3333333333333333333333333333333333333333
\&       5:3333333333333333333333333333333333333333
\&       4:3333333333333333333333333333333333333333
\&       3:3333333333333333333333333333333333333333
\&       2:3333333333333333333333333333333333333333
\&       1:3333333333333333333333333333333333333333
.Ve
.PP
The annulus, box, circle, ellipse, and pie shapes also accept an
\&\fBn=[int]\fR syntax for specifying multiple regions. The
\&\fBn=[int]\fRsyntax interprets the previous (shape\-dependent)
arguments as lower and upper limits for the region and creates n
shapes with evenly spaced boundaries.  For example, if \fBn=[int]\fR
is specified in an annulus, the two immediately preceding radii
(\fBrn\fR and \fBrm\fR) are divided into \fBint\fR annuli, such
that the inner radius of the first is \fBrn\fR and the outer radius
of the last is \fBrm\fR. For example,
.PP
.Vb 1
\&  ANNULUS 20 20 5 20 n=3
.Ve
.PP
is equivalent to:
.PP
.Vb 1
\&  ANNULUS 20 20 5 10 15 20
.Ve
.PP
If this syntax is used with an ellipse or box, then the two preceding
pairs of values are taken to be lower and upper limits for a set of
ellipses or boxes. A circle uses the two preceding arguments for upper
and lower radii.  For pie, the two preceding angles are divided into n
wedges such that the starting angle of the first is the lower bound
and the ending angle of the last is the upper bound.  In all cases,
the \fBn=[int]\fR syntax allows any single alphabetic character
before the \*(L"=\*(R", i.e, i=3, z=3, etc. are all equivalent.
.PP
Also note that for boxes and ellipses, the optional angle argument is
always specified after the \fBn=[int]\fR syntax. For example:
.PP
.Vb 1
\&  ellipse 20 20 4 6 16 24 n=3 45
.Ve
.PP
specifies 3 elliptical regions at an angle of 45 degrees:
.PP
.Vb 42
\&  1234567890123456789012345678901234567890
\&  ----------------------------------------
\&  40:........33333333........................
\&  39:.....33333333333333.....................
\&  38:....33333333333333333...................
\&  37:...33333333333333333333.................
\&  36:..33333333333333333333333...............
\&  35:.3333333333222223333333333..............
\&  34:3333333322222222222233333333............
\&  33:33333332222222222222223333333...........
\&  32:333333222222222222222222333333..........
\&  31:3333322222222222222222222333333.........
\&  30:33333222222222111122222222333333........
\&  29:333332222222111111112222222333333.......
\&  28:3333222222211111111111222222333333......
\&  27:3333222222111111111111112222233333......
\&  26:33332222221111111111111112222233333.....
\&  25:33332222211111111.111111112222233333....
\&  24:333322222111111......111111222223333....
\&  23:333322222111111.......111112222233333...
\&  22:33333222221111.........11111222223333...
\&  21:333332222211111.........11112222233333..
\&  20:.33332222211111.........11111222223333..
\&  19:.33333222221111.........111112222233333.
\&  18:..33332222211111.........11112222233333.
\&  17:..333332222211111.......111111222233333.
\&  16:...333322222111111......111111222223333.
\&  15:...333332222211111111.111111112222233333
\&  14:....333332222211111111111111122222233333
\&  13:.....33333222221111111111111122222233333
\&  12:.....33333322222211111111111222222233333
\&  11:......3333332222222111111112222222333333
\&  10:.......333333222222221111222222222333333
\&  9:........33333322222222222222222222333333
\&  8:.........333333222222222222222222333333.
\&  7:..........33333332222222222222223333333.
\&  6:...........3333333322222222222233333333.
\&  5:.............3333333333222223333333333..
\&  4:..............33333333333333333333333...
\&  3:................33333333333333333333....
\&  2:..................33333333333333333.....
\&  1:....................33333333333333......
.Ve
.PP
Both the variable argument syntax and the \fBn=[int]\fR syntax must
occur alone in a region descriptor (aside from the optional angle for
boxes and ellipses).  They cannot be combined. Thus, it is not valid
to precede or follow an \fBn=[int]\fR accelerator with more angles or
radii, as in this example:
.PP
.Vb 3
\&  # INVALID -- one too many angles before a=5 ...
\&  # and no angles are allowed after a=5
\&  PIE 12 12 10 25 50 a=5 85 135
.Ve
.PP
Instead, use three separate specifications, such as:
.PP
.Vb 3
\&  PIE 12 12 10 25
\&  PIE 12 12 25 50 a=5
\&  PIE 12 12 85 135
.Ve
.PP
The original (\s-1IRAF\s0) implementation of region filtering permitted this
looser syntax, but we found it caused more confusion than it was worth
and therefore removed it.
.PP
\&\s-1NB:\s0 Accelerators may be combined with other shapes in a boolean
expression in any order. (This is a change starting with funtools
v1.1.1. Prior to this release, the accelerator shape had to be
specified last).  The actual region mask id values returned depend on the
order in which the shapes are specified, although the total number of
pixels or rows that pass the filter will be consistent. For this
reason, use of accelerators in boolean expressions is discouraged in
programs such as funcnts, where region mask id values are used
to count events or image pixels.
.PP
[All region masks displayed in this document were generated using the
\&\fBfundisp\fR routine and the undocumented \*(L"mask=all\*(R" argument (with
spaced removed using sed ):
.PP
.Vb 2
\&  fundisp "funtools/funtest/test40.fits[ANNULUS 25 25 5 10]" mask=all |\e
\&  sed 's/ //g'
.Ve
.PP
Note that you must supply an image of the appropriate size \*(-- in this case,
a \s-1FITS\s0 image of dimension 40x40 is used.]
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
