/*
 * sbox.h -- definitions for the script box
 * Copyright 1997-1998, Lincoln D. Stein
 * $Revision: 1.2 $
 */

#ifndef _SBOX_H
#define _SBOX_H
#define TRUE  1
#define FALSE 0
#define DIRECTORY 1
#define TARGET 0

/******        USER CONFIGURABLE DEFINES      ******/

/********************* GENERAL *******************/
/*
 * WEB_USER  -- user that the Web server runs as
 */
#ifndef WEB_USER
#define WEB_USER "nobody"
#endif

/*
 * WEB_GROUP  -- group that the Web server runs as
 */
#ifndef WEB_GROUP
#define WEB_GROUP "nogroup"
#endif

/*
 * ALLOW_WEB_OWNED_SCRIPTS  -- allows scripts to be executed if owned by WEB_USER or WEB_GROUP
 */
#ifndef ALLOW_WEB_OWNED_SCRIPTS
#define ALLOW_WEB_OWNED_SCRIPTS 1
#endif

/*
 * UID_MIN  -- lowest UID that we will suid to
 */
#ifndef UID_MIN
#define UID_MIN 100
#endif

/*
 * UID_MAX  -- highest UID that we will suid to
 */
#ifndef UID_MAX
#define UID_MAX 65535
#endif

/*
 * GID_MIN  -- lowest UID that we will sgid to
 */
#ifndef GID_MIN
#define GID_MIN 100
#endif

/*
 * GID_MAX  -- highest GID that we will sgid to
 */
#ifndef GID_MAX
#define GID_MAX 65535
#endif

/* SAFE_PATH -- this is the path that will be placed in the environment.
 * Script will be running chroot to the user's home directory, so these 
 * directories may not be available.
 */
#ifndef SAFE_PATH
#define SAFE_PATH "/bin:/usr/bin:/usr/local/bin"
#endif

/********************* LOGGING *******************/
/*
 * LOG_FILE  -- log what sbox does.  If undefined, won't log.
 *              If an empty string, logs to standard error.
 */
#ifndef LOG_FILE
#define LOG_FILE "/var/log/apache/sbox.log"
/* #define LOG_FILE "" */
#endif

/*
 * ECHO_FAILURES  -- If set to TRUE, will echo fatal error messages
 *              to the browser.  Set to FALSE to inhibit error messages.
 */
#ifndef ECHO_FAILURES
#define ECHO_FAILURES TRUE
#endif

/******************* CHROOT CONFIG ******************/
/* DO_CHROOT -- if set to TRUE, sbox will
 * do a chroot to the user's home directory.
 */
#ifndef DO_CHROOT
#define DO_CHROOT TRUE
#endif

/*
 * ROOT
 * Directory to which sbox will chroot(), relative to the author's
 * document root.
 */
#ifndef ROOT
#define ROOT ".."
#endif

/*
 * CGI_BIN
 * Directory in which users' executables must reside, relative to their
 * document root.  For best results, this must be contained within ROOT.
 */
#ifndef CGI_BIN
#define CGI_BIN "../cgi-bin"
#endif

/************** AbsolutePath ***************/
/* Added by Grant Kaufmann (grant@netizen.co.za) 28 March 2000
 *  In a case where you want to have sbox work on a directory
 *  not related to the webroot, you can define USE_ABSOLUTE_ROOT
 *  as that directory.
 * NOTE: the sbox binary you compile will work for that directory ONLY.
 * If you want to use it for another directory, recompile and use a
 * different binary
 */

#ifndef USE_ABSOLUTE_ROOT
/* #define USE_ABSOLUTE_ROOT "/home/myapp/html" */
#endif

/************** SUID/SGID CONFIG ***************/
/* DO_SUID and DO_SGID -- if set to TRUE, sbox
 * will SUID and/or SGID to the user and group ownership of
 * the _directory_ in which the target script is found
 */
#ifndef DO_SUID
#define DO_SUID TRUE
#endif

#ifndef DO_SGID
#define DO_SGID TRUE
#endif

/* Determine whether to use the ownerships of the script or the _directory_
 * that the script is found in for the SUID/SGID IDs.  Legal values are
 * DIRECTORY and TARGET
 */
#ifndef SID_MODE
#define SID_MODE DIRECTORY
/* #define SID_MODE TARGET */
#endif


/*
 * RESOURCE LIMITS -- hard and soft.  Set to RLIM_INFINITY for no limits.
 * Soft limits can be increased by the application.  Hard limits cannot be
 * changed.
 */

/* Whether or not you want to set limits at all.
 * If your sytem does not have <sys/resource.h>, then you will
 * need to set this to FALSE.
 */
#ifndef SET_LIMITS
#define SET_LIMITS TRUE
#endif

#define ONEK 1024

/* priority */
#ifndef PRIORITY
#define PRIORITY 10
#endif

/* maximum CPU time */
#ifndef LIMIT_CPU_HARD
#define LIMIT_CPU_HARD 120 /* CPU seconds */
#endif

#ifndef LIMIT_CPU_SOFT
#define LIMIT_CPU_SOFT 10 /* CPU seconds */
#endif

/* maximum size of a single file that can be created (blocks) */
#ifndef LIMIT_FSIZE_HARD
#define LIMIT_FSIZE_HARD 2048 * ONEK /* two megabytes */
#endif

#ifndef LIMIT_FSIZE_SOFT
#define LIMIT_FSIZE_SOFT 1024 * ONEK /* 100K */
#endif

/* maximum amount of in-memory data */
#ifndef LIMIT_DATA_HARD
#define LIMIT_DATA_HARD  8192 * ONEK /* eight megabytes */
#endif

#ifndef LIMIT_DATA_SOFT
#define LIMIT_DATA_SOFT  1024 * ONEK /* one megabyte */
#endif

/* maximum stack size */
#ifndef LIMIT_STACK_HARD
#define LIMIT_STACK_HARD 8192 * ONEK /* eight megabytes */
#endif

#ifndef LIMIT_STACK_SOFT
#define LIMIT_STACK_SOFT  1024 * ONEK /* one megabyte */
#endif

/* core dump size */
#ifndef LIMIT_CORE_HARD
#define LIMIT_CORE_HARD 0 /* don't allow core dumps */
#endif

#ifndef LIMIT_CORE_SOFT
#define LIMIT_CORE_SOFT 0 /* don't allow core dumps */
#endif

/* maximum memory ("resident set") usage */
#ifndef LIMIT_RSS_HARD
#define LIMIT_RSS_HARD 8192 * ONEK /* eight megs */
#endif

#ifndef LIMIT_RSS_SOFT
#define LIMIT_RSS_SOFT 1024 * ONEK /* one meg */
#endif

/* max number of processes script can spawn */
#ifndef LIMIT_NPROC_HARD
#define LIMIT_NPROC_HARD 256
#endif

#ifndef LIMIT_NPROC_SOFT
#define LIMIT_NPROC_SOFT 32
#endif

/* max number of open file descriptors */
#ifndef LIMIT_NOFILE_HARD
#define LIMIT_NOFILE_HARD 256
#endif

#ifndef LIMIT_NOFILE_SOFT
#define LIMIT_NOFILE_SOFT 32
#endif

#define SETLIMIT(a) limit.rlim_cur = LIMIT_##a##_SOFT; \
                    limit.rlim_max = LIMIT_##a##_HARD; \
                    if (setrlimit(RLIMIT_##a,&limit)<0) \
		       fatal_error("Couldn't set limit: %s",strerror(errno));

/* This is a canned error statement */
#ifndef CANNED_ERROR_TOP
#define CANNED_ERROR_TOP \
"<HTML><HEAD><TITLE>Sbox Error</TITLE></HEAD> <BODY>" \
"<H1>Sbox Error</H1>" \
"The <A HREF=\"http://stein.cshl.org/WWW/software/sbox/\">sbox</A> " \
"program encountered an error while processing this request. " \
"Please note the time of the error, anything you might have been " \
"doing at the time to trigger the problem, and forward the " \
"information to this site's Webmaster "
#endif

#ifndef CANNED_ERROR_BOTTOM
#define CANNED_ERROR_BOTTOM \
"<HR>" \
"</BODY></HTML>"
#endif

#define CANNED_ERROR CANNED_ERROR_TOP CANNED_ERROR_BOTTOM

#endif /* _SBOX_H */
