### move.tcl
### Functions for moving within a game.

namespace eval ::move {}

proc ::move::Start {} {
  if {$::tree(refresh)} { return }
  sc_move start
  updateBoard
}

proc ::move::End {} {
  if {$::tree(refresh)} { return }
  sc_move end
  updateBoard
}

proc ::move::Back {{count 1}} {
  if {$::tree(refresh)} { return }
  if {[sc_pos isAt start]  ||  [sc_pos isAt vstart]} { return }
  sc_move back $count
  if {$count == 1} {
    # Do animation and speech:
    updateBoard -animate
    ::utils::sound::AnnounceBack
  } else {
    updateBoard
  }
}

proc ::move::Forward {{count 1}} {
  if {$::tree(refresh)} { return }
  if {[sc_pos isAt end]  ||  [sc_pos isAt vend]} { return }
  set move [sc_game info next]
  sc_move forward $count
  if {$count == 1} {
    # Animate and speak this move:
    updateBoard -animate
    ::utils::sound::AnnounceForward $move
  } else {
    updateBoard
  }
}


