import time, sys

class Log:

    def __init__(self, logfile=None):
        if logfile:
            self.logfile = open(logfile, "a")
        else:
            self.logfile = sys.stderr
        
    def log(self, text):
        t = time.localtime()
        line = "%s %s\n" % (time.strftime("%Y-%m-%d %H:%M:%S", t), text)
        self.logfile.write(line)
        self.logfile.flush()

    def logr(self, ip, command): # ip, command
        self.log("%s: %s" % (ip, command))
        
    def closelog(self):
        self.logfile.close()

    def __del__(self):
        self.logfile.close()
        
