/*
 * Smart Gnome Control - interface callbacks file
 * Copyright (C) 2004 by Mark J. Fine <fineware@users.sourceforge.net>
 *
 * This program provides a graphical user interface to multiple
 * communications receivers using the Hamlib library.
 *
 * $Id: callbacks.c,v 1.30 2005/01/16 03:23:55 fineware Exp $
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA  02111-1307
 *      USA
 *
 */

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "extra.h"
#include "database.h"
#include "logfile.h"

void
on_open_database1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_database_file();
}


void
on_save_database1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save_database_as1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_dump_database1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_update_database1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_import_database1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_publish_database1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_printer_setup1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_visual_defaults();
  gtk_main_quit();
}


void
on_mark1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_delete1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keypad1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  toggle_visible(GTK_WIDGET(menuitem),"KeyPad");
}


void
on_band_plan1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  toggle_visible(GTK_WIDGET(menuitem),"BandPlanBox");
  set_visible(app1,"HistToolbar",get_visible(app1,"BandPlanBox"));
}


void
on_control_panel1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  toggle_visible(GTK_WIDGET(menuitem),"CPanelBox");
}

void
on_history1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  toggle_visible(GTK_WIDGET(menuitem),"HistoryBox");
}


void
on_pan_display1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_power1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_power();
}


void
on_noise_blanker1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_blanker();
}



void
on_noise_reduction1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_dnr();
}


void
on_attenuator1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_atten();
}


void
on_preamp1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_preamp();
}


void
on_notch1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_notch();
}


void
on_auto_notch1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_anf();
}


void
on_tape_vox1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_tape();
}


void
on_tuning1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_memory1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_query1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_tools1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_contents1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_topic_search1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_using_help1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_faceplate_operation1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_memory_management1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_logging_system1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget	*abt1;
  abt1 = create_AboutDlg();
  gtk_widget_show (abt1);
}


void
on_ExitBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_visual_defaults();
  gtk_main_quit();
}


void
on_app1_destroy                        (GtkObject       *object,
                                        gpointer         user_data)
{
  set_visual_defaults();
  gtk_exit(0);
}


void
on_PwrBtn_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  set_power();
}


void
on_togglebutton1_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_blanker();
}


void
on_DNRBtn_released                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_dnr();
}


void
on_attbtn_released                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_atten();
}


void
on_preampbtn_released                  (GtkButton       *button,
                                        gpointer         user_data)
{
  set_preamp();
}


void
on_togglebutton2_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_notch();
}


void
on_ANFBtn_released                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_anf();
}

void
on_togglebutton3_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_tape();
}


void
on_togglebutton4_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_mem();
}


void
on_togglebutton5_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_scan();
}


void
on_togglebutton6_released              (GtkButton       *button,
                                        gpointer         user_data)
{
  set_timer();
}


gboolean
on_eventbox1_enter_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_HAND2);
  return TRUE;
}


gboolean
on_eventbox1_leave_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_LEFT_PTR);
  return TRUE;
}


gboolean
on_eventbox1_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  set_display_mouse(widget,event);
  return TRUE;
}


void
on_hf_prediction1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_close_windows1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_options1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show (opt1);
}


void
on_CloseWinBtn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_OptionsBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_show (opt1);
}


void
on_PortBoxEdit_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar* list_str = gtk_editable_get_chars(editable,0,-1);
  gboolean show_item = (g_strcasecmp(list_str,"Other...") == 0);
  set_visible(opt1,"PortEdit",show_item);
}


void
on_OkBtn_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  hamlib_riglist_set_defaults();
}


void
on_ApplyBtn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  hamlib_riglist_set_defaults();
}


void
on_Local2Lbl_draw                      (GtkWidget       *widget,
                                        GdkRectangle    *area,
                                        gpointer         user_data)
{
  updateUTC(widget);
}


void
on_UTC2Lbl_realize                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  updateUTC(widget);
}


void
on_other1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_edit_step_sizes1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_memory_mode1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_mem();
}


void
on_scan_mode1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_scan_pause1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_scan_parameters1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_timer_mode1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_timer_parameters1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_update_display1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_all(FALSE);
}


void
on_disconnect1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_print1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_capture1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_memory_list();
}


void
on_show_list1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show (mem1);
}


void
on_fill_radio1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_insert_channel1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_swbc_programs1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_swbc_stations1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_stat_list(0);
}


void
on_utility_stations1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_stat_list(1);
}


void
on_am_bcb_cb_stations1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_stat_list(2);
}


void
on_find_current_freqs1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_query(2);
}


void
on_find_freq_usage1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_query(3);
}


void
on_full_station_sked1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_query(1);
}


void
on_print_station_sked1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_who_else_uses1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  set_query(4);
}


void
on_new2_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_log_file();
}


void
on_open2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_log_file();
}


void
on_save_as2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  put_log_file();
}


void
on_print2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_entry1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_log_entry(1,FALSE,-1);
}


void
on_show_log1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show (log1);
}


void
on_export1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_kp7_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp7");
  set_tuner_display(7);
}


void
on_kp8_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp8");
  set_tuner_display(8);
}


void
on_kp9_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp9");
  set_tuner_display(9);
}


void
on_kpBS_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kpBS");
  set_tuner_display(11);
}


void
on_kp4_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp4");
  set_tuner_display(4);
}


void
on_kp5_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp5");
  set_tuner_display(5);
}


void
on_kp6_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp6");
  set_tuner_display(6);
}


void
on_kpEnter_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kpEnter");
  set_tuner_display(13);
}


void
on_kp1_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp1");
  set_tuner_display(1);
}


void
on_kp2_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp2");
  set_tuner_display(2);
}


void
on_kp3_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp3");
  set_tuner_display(3);
}


void
on_kp0_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kp0");
  set_tuner_display(0);
}


void
on_kpDot_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  set_focus(app1,"kpDot");
  set_tuner_display(10);
}

void
on_HistBackBtn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  hist_index--;
  tune_from_history(hist_index,TRUE);
}


void
on_HistForwBtn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  hist_index++;
  tune_from_history(hist_index,TRUE);
}


gboolean
on_HistList_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  tune_from_history(in_row,FALSE);
  return TRUE;
}


void
on_OptionsDlg_show                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GtkWidget* gen_item = lookup_widget(opt1,"RadioList");
  if (gen_item) {
    gint sel_row = GPOINTER_TO_INT(GTK_CLIST(gen_item)->selection->data);
	gtk_clist_moveto(GTK_CLIST(gen_item),sel_row,0,0,0);
  }
}

void
on_ShowMemBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_show (mem1);
}

gboolean
on_MemList_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  select_from_memory_list(widget,event);
  return TRUE;
}


void
on_MemWindow_show                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GtkWidget* gen_item = lookup_widget(mem1,"MemList");
  if (gen_item) {
	gtk_clist_select_row(GTK_CLIST(gen_item),memch-min_mem_ch,0);
	gtk_clist_moveto(GTK_CLIST(gen_item),memch-min_mem_ch,0,1,1);
  }
}


gboolean
on_eventbox2_enter_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_HAND2);
  return TRUE;
}


gboolean
on_eventbox2_leave_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_LEFT_PTR);
  return TRUE;
}


gboolean
on_eventbox2_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  if ((event->button) == 1)
	gtk_widget_show (mem1);
  return TRUE;
}


void
on_OpenBtn_released                    (GtkButton       *button,
                                        gpointer         user_data)
{
  get_database_file();
}

void
on_button4_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_checked(app1,"control_panel1",FALSE);
}


void
on_button5_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_checked(app1,"history1",FALSE);
}


void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_checked(app1,"band_plan1",FALSE);
}


void
on_edit2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_view2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_filter1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_WhenBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_query(1);
}


void
on_FindBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  set_query(2);
}


void
on_UsageBtn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  set_query(3);
}


void
on_What1Btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  show_stat_list(0);
}


void
on_What2Btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  show_stat_list(1);
}


void
on_What3Btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  show_stat_list(2);
}


void
on_WhoBtn_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  set_query(4);
}


void
on_DBNotebook_switch_page              (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  set_visible(tun1,"FrequenciesBox",(page_num == 1));
  switch (page_num) {
	case 0 : if ((db_changed[0]) && (get_list_num_rows(tun1,"SkedList") > 0))
				refresh_sked_list(NULL);
			 break;
	case 1 : refresh_stat_list(-1); break;
	case 2 : refresh_who_list(NULL); break;
  }	  
}


void
on_StatNotebook_switch_page            (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  refresh_stat_list(page_num);
}


void
on_mark3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_modify1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_insert_above1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_insert_below1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_delete2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_select_all1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_select_marked1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_full_schedule1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_skeds_list(NULL);
}


void
on_stations1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
  show_freq_sidebar();
}


void
on_frequencies1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_freq_list(NULL);
}


void
on_time_filter1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int 	is_down;
	
  is_down = get_down(tun1,"TimeFiltBtn");
  set_down(tun1,"TimeFiltBtn",!is_down);
}


void
on_language_filter1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int 	is_down;
	
  is_down = get_down(tun1,"LangBtn");
  set_down(tun1,"LangBtn",!is_down);
}


gboolean
on_BCList_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  get_stat_list_items(widget,in_row);
  return TRUE;
}


gboolean
on_UteList_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  get_stat_list_items(widget,in_row); 
  return TRUE;
}


gboolean
on_BCBList_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  get_stat_list_items(widget,in_row);
  return TRUE;
}


gboolean
on_FreqList_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  tune_from_freq_list(widget,in_row);
  return TRUE;
}


gboolean
on_SkedList_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = get_list_clicked_row(widget,event);
  tune_from_freq_list(widget,in_row);
  return TRUE;
}


void
on_StationsRefreshBtn_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  refresh_stat_list(-1);
}


void
on_SkedClearBtn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  clear_sked_list();
}


void
on_SkedRefreshBtn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  refresh_sked_list(NULL);
}


void
on_TimeFiltBtn_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  set_time_filter();
}


void
on_new4_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_open4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_save_as4_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_print4_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_set3_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_modify3_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_move1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_insert1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_clear1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_channel1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_memory_set1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_frequency1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_name1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_original_order1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_capture2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_memory_list();
}


void
on_fill1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_edit_comment1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_LangBtn_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  set_time_filter();
}


void
on_FilterBtn_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  set_time_filter();
}


void
on_SkedList_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}


void
on_BCList_select_row                   (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}


void
on_UteList_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}


void
on_BCBList_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}


void
on_WhoList_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}


void
on_FreqList_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  update_tuning_buttons(clist,row);
}

void
on_TLeftBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  select_previous();
}


void
on_TRightBtn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  select_next();
}

gboolean
on_eventbox3_enter_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_HAND2);
  return TRUE;
}


gboolean
on_eventbox3_leave_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_display_cursor(widget,GDK_LEFT_PTR);
  return TRUE;
}


gboolean
on_eventbox3_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  if ((event->button) == 1)
	set_checked(app1,"band_plan1",!get_visible(app1,"BandPlanBox"));
  return TRUE;
}


void
on_Query_OkBtn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  do_query();
}


gboolean
on_BCBandList_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  do_BandPlan_clicked(widget,event);
  return TRUE;
}


gboolean
on_UteBandList_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  do_BandPlan_clicked(widget,event);
  return TRUE;
}


gboolean
on_Lookup_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  do_Lookup_clicked(widget,event);
  return TRUE;
}


void
on_MemDownBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  mem_up_down(-1.0);
}


void
on_MemUpBtn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  mem_up_down(1.0);
}


gboolean
on_LLeftBtn_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  handle_tuning(widget,event,-sml_step);
  return TRUE;
}


gboolean
on_LeftBtn_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  handle_tuning(widget,event,-lrg_step);
  return TRUE;
}


gboolean
on_RightBtn_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  handle_tuning(widget,event,lrg_step);
  return TRUE;
}


gboolean
on_RRightBtn_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  handle_tuning(widget,event,sml_step);
  return TRUE;
}


void
on_step010_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 0.10;
}


void
on_step050_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 0.50;
}


void
on_step1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 1.00;
}


void
on_step2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 2.00;
}


void
on_step3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 3.00;
}


void
on_step5_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 5.00;
}


void
on_step9_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 9.00;
}


void
on_step10_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 10.00;
}


void
on_step100_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 100.00;
}


void
on_step1000_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lrg_step = 1000.00;
}


void
on_lstep001_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.01;
}


void
on_lstep002_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.02;
}


void
on_lstep003_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.03;
}


void
on_lstep005_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.05;
}


void
on_lstep010_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.10;
}


void
on_lstep020_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.20;
}


void
on_lstep030_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.30;
}


void
on_lstep050_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 0.50;
}


void
on_lstep1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  sml_step = 1.00;
}

gboolean
on_LLeftBtn_enter_notify_event         (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(-sml_step);
  return TRUE;
}


gboolean
on_LLeftBtn_leave_notify_event         (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(0.00);
  return TRUE;
}


gboolean
on_LeftBtn_enter_notify_event          (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(-lrg_step);
  return TRUE;
}


gboolean
on_LeftBtn_leave_notify_event          (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(0.00);
  return TRUE;
}


gboolean
on_RightBtn_enter_notify_event         (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(lrg_step);
  return TRUE;
}


gboolean
on_RightBtn_leave_notify_event         (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(0.00);
  return TRUE;
}


gboolean
on_RRightBtn_enter_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(sml_step);
  return TRUE;
}


gboolean
on_RRightBtn_leave_notify_event        (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  set_tuning_help(0.00);
  return TRUE;
}


void
on_LogWindow_show                      (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_log_file_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_new_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_log_file();
}


void
on_log_open_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  get_log_file();
}


void
on_log_save_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  put_log_file();
}


void
on_log_export_all_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_export_selected_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_print_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_print_report_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_edit_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_modify_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_log_entry(2,FALSE,-1);
}


void
on_log_add_entry_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_log_entry(1,FALSE,-1);
}


void
on_log_delete_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_log_entry(3,FALSE,-1);
}


void
on_log_sort_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_frequency_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_time_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_date_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_mode_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_sinpo_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_call_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_country_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_station_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_original_order_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_format_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_export_format_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_log_report_format_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


gboolean
on_LogList_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gint in_row = 0;
  select_from_log_list(widget,event,in_row);
  return TRUE;
}


void
on_ShowLogBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_show (log1);
}


void
on_LogNewBtn_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  create_log_file();
}


void
on_LogOpenBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  get_log_file();
}


void
on_LogSaveBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  put_log_file();
}


void
on_LogExportBtn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_LogPrintBtn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_LogDownBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  change_log_selection(FALSE);
}


void
on_LogUpBtn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  change_log_selection(TRUE);
}


void
on_LogEditBtn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  show_log_entry(2,FALSE,-1);
}


void
on_LogInsertBtn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  show_log_entry(1,FALSE,-1);
}


void
on_LogDeleteBtn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  show_log_entry(3,FALSE,-1);
}


void
on_LEOkBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  process_log_entry();
}


gboolean
on_app1_key_press_event                (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  if ((event->keyval == GDK_BackSpace) ||
	(event->keyval == GDK_Left) ||
	(event->keyval == GDK_KP_Left) ||
	(event->keyval == GDK_Right) ||
	(event->keyval == GDK_KP_Right)) {
	process_keys(widget,event);
	event->keyval = GDK_BackSpace;
  }
  return TRUE;
}


void
on_HistBtn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  tune_from_hist_entry();
}

