/***************************************************************************
                          effect_table.h  -  description
                             -------------------
    begin                : Sun Sep 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EFFECT_TABLE_H
#define EFFECT_TABLE_H

#include "effect.h"
#include "effect_basic.h"
#include "effect_volume.h"
#include "effect_misc.h"
#include "effect_special.h"


/**
  *@author Juan Sebastian Linietsky
  */

class Effect_Table {

	Event_Queue *queue;
	Player_Data *data;
	Effect null_effect;

public:
	enum Names {

		COMMAND_A,
		COMMAND_B,
		COMMAND_C,
		COMMAND_D,
		COMMAND_E,
		COMMAND_F,
		COMMAND_G,
		COMMAND_H,
		COMMAND_I,
		COMMAND_J,
		COMMAND_K,
		COMMAND_L,
		COMMAND_M,
		COMMAND_N,
		COMMAND_O,
		COMMAND_P,
		COMMAND_Q,
		COMMAND_R,
		COMMAND_S,
		COMMAND_T,
		COMMAND_U,
		COMMAND_V,
		COMMAND_W,
		COMMAND_X,
		COMMAND_Y,
		COMMAND_Z,
		COMMAND_0,
		COMMAND_1,
		COMMAND_2,
		COMMAND_3,
		COMMAND_4,
		COMMAND_5,
		COMMAND_6,
		COMMAND_7,
		COMMAND_8,
		COMMAND_9,
		MAX_COMMANDS
	};

        static const char* effect_names[MAX_COMMANDS];

private:

	Effect_Tone_Portamento e_portamento;
        Effect_Rpq_Change e_rpq;
        Effect_Tempo_Change e_tempo;
        Effect_Pitch_Slide_Down e_pitch_down;
        Effect_Pitch_Slide_Up e_pitch_up;
        Effect_Pitch_Vibrato e_vibrato;
	Effect_Channel_Volume_Change e_channel_volume;
	Effect_Aftertouch_Set e_aftertouch_set;
	Effect_Pan_Slide e_pan_slide;
	Effect_Pan_Change e_pan_set;
        Effect_PanBrello e_panbrello;
        Effect_Retrigger e_retrigger;
        Effect_Arpegio e_arpegio;
	Effect_Special e_special;
        Effect_Volume_Slide e_volslide;
        Effect_Tremolo e_tremolo;

	Effect *table[MAX_COMMANDS];			
        int track;
	int column;
	Effect_Table();
 	void set_queue(Event_Queue *p_queue);
	void set_data(Player_Data *p_data);
	void set_track(int p_track);
	void set_column(int p_column);
	void register_effect(Effect *p_effect,int p_name);

public:

	
	Effect *get_effect(int p_name);


	Effect_Table(Event_Queue *p_queue,Player_Data *p_data,int p_track,int p_column);	
	~Effect_Table();
};

#endif
