/***************************************************************************
                          event_queue.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EVENT_QUEUE_H
#define EVENT_QUEUE_H

#include <list>

#include "event_basic.h"
#include "event_execute.h"


/**
  *@author Juan Sebastian Linietsky
  */

class Event_Queue {

	typedef list<Event*> Event_List;

	Event_List event_list;
	Event_Execute *runner;
public:

	void push(int p_time_offset,int p_track, int p_column,Event *p_event);
	void move_priorities(int p_time_amount);

        int get_head_time();
        bool is_empty();
	Event* pop();
        void clear();
        void delete_extra_events(int p_time,string p_event_name);

	void set_event_runner(Event_Execute *p_runner);

	Event_Queue();
	~Event_Queue();
};

#endif
