#ifndef _CONFIG_HPP_
#define _CONFIG_HPP_

#include "defaults.hpp"
#include "bwadm.hpp"
#include "classdef.hpp"
#include <stdio.h>

#define OPT_FW_NONE   1
#define OPT_FW_DIVERT 2
#define OPT_FW_IPQ    3

class ipv4_classifier_parser {
	public:
	int proto, uprio;
	char saddr[1024], smask[1024];
	char daddr[1024], dmask[1024];
	char inp_if[1024], out_if[1024];

	struct spt_list {
		struct spt_list *next;
		int lo, hi;
	} *spt, *dpt;

	int n_saddr, n_daddr;
	struct in_addr *v_saddr;
	struct in_addr *v_daddr;
	public:
		int parse(char *line);
		int parse_proto(char *line);
		int parse_sport(char *line);
		int parse_dport(char *line);
		int parse_saddr(char *line);
		int parse_daddr(char *line);
		int parse_prio(char *line);
		int parse_inp_if(char *line);
		int parse_out_if(char *line);
		int setup();
		int resolv(char *, struct in_addr **, int *);
		ipv4_classifier_parser();
		~ipv4_classifier_parser();
};

#ifdef WITH_IPQ
class nf_classifier_parser : public ipv4_classifier_parser {
	public:
	unsigned long mark, mask;
	public:
		int parse(char *line);
		int parse_fwmark(char *line);
		nf_classifier_parser();
		~nf_classifier_parser();
};
#endif

class shaper_config {
public:
	FILE *fptr;
	bwadm my_bw;
	int daemon;
	int divert_port;
	int catch_sighup;
	int packet_fw;

//	ANSI y la p... :-)
//	static int scan_seq = 0;
//	static char pidfile[MAXPATH] = DEFAULT_PIDFILE;

	int check_lenders();
	int check_classname(char *name);
	int check_config();
	int is_class(char *line, char *classid);
	int parse_opt_daemon(char *line);
	int parse_opt_catch_sighup(char *line);
	int parse_opt_loglevel(char *line);
	int parse_opt_packet_fw(char *line);
	int parse_opt_pidfile(char *line);
	int parse_divert_port(char *line);
	int parse_within_class(FILE *fp, char *classid, classdef *my_class);
	int parse_bandwidth(char *line, class classdef *cur_class);
	int parse_ipv4_classifier(char *line, classdef *cur_class);
	int setup_ipv4_classifier(
		ipv4_packet_classifier *,
		ipv4_classifier_parser *,
		int, int);
	int parse_borrow_from(char *line, classdef *cur_class);
	int parse_queue_limits(char *line, classdef *cur_class);
	int parse_divert_reinjection(char *line, classdef *pc);
	int parse_endofclass(char *line);
	int get_line(char *line, const int len);
	void set_divert_port(int port);
#ifdef WITH_IPQ
	int parse_nf_classifier(char *line, classdef *cur_class);
#endif
	public:
		int n_classes;
		classdef **v_classes;

		shaper_config(int fw=OPT_FW_NONE);
		~shaper_config();
		int add_class(classdef *new_class);
		int bw_init();
		int queues_init();
		int get_divert_port();
		char *get_pidfile();
		void show_config();
		classdef *get_classbyname(char *name);
		int read_config(char *fn);
};

#endif
