#include <assert.h>

#include <sigc++/slot.h>
#include <sigc++/object.h>

#include <sigcperl/slot.h>
#include <sigcperl/signal_base.h>

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

// don't confuse XSUB code with C++ namespace stuff
using namespace SigCPerl;
using SigC::Connection;
using SigC::Object;

// The destructor for SigC::Object as _ObjectCallback
// allows us to have perl call the destructor for an
// internal type in the sigcperl library, without having
// to put it in the headers.

// Similarly, Connection doesn't have a constructor, since it's never
// created directly, just returned from a signal's connect().

MODULE = SigC		PACKAGE = SigC::_ObjectCallback

void
Object::DESTROY()

MODULE = SigC		PACKAGE = SigC::Slot

Slot*
Slot::new(arg1, ...)
    SV *arg1 ; // The semicolon means don't init
  CODE:
    Data data;
    // The arg1 in the XSUB declaration means we have at least one SV,
    // since we need a function reference to create a slot
    assert(items >= 2); // The CLASS variable and arg1
    SIGCPERL_GET_STACK_DATA(data);
    try {
      RETVAL = new Slot(data);
    }
    catch(Slot::BadParams) {
      //std::cerr << "Bad parameters passed to Slot::new()\n";
      XSRETURN_UNDEF;
    }
  OUTPUT:
    RETVAL

void
Slot::call(...)
  PPCODE:
    //std::cerr << "Starting XSUB call\n";
    Data data;
    SIGCPERL_GET_STACK_DATA(data);

    PUTBACK;
    THIS->call(data, GIMME_V).push_stack();
    SPAGAIN;
    //std::cerr << "Finished XSUB call\n";

Slot*
Slot::bind(...)
  CODE:
    Data data;
    const char *CLASS = "SigC::Slot";
    SIGCPERL_GET_STACK_DATA(data);
    RETVAL = new Slot(THIS->bind(data));
  OUTPUT:
    RETVAL

void
Slot::DESTROY()

MODULE = SigC		PACKAGE = SigC::Connection

void
Connection::disconnect()

void
Connection::DESTROY()

MODULE = SigC		PACKAGE = SigC::Signal

SignalBase*
SignalBase::new()
  CODE:
    RETVAL = new SignalPerl();
  OUTPUT:
    RETVAL

Connection*
SignalBase::connect(arg1, ...)
    SV *arg1 ; // The semicolon means don't init
  CODE:
    const char *CLASS = "SigC::Connection";
    assert(items >= 2); // The THIS variable and arg1
    Data data;
    SIGCPERL_GET_STACK_DATA(data);
    try {
      RETVAL = new Connection(THIS->connect(ParseToSlot(data)));
    }
    catch(Slot::BadParams) {
      //std::cerr << "Bad parameters passed to SignalBase::connect()\n";
      XSRETURN_UNDEF;
    }
  OUTPUT:
    RETVAL

void
SignalBase::emit(...)
  PPCODE:
    Data data;
    SIGCPERL_GET_STACK_DATA(data);
    try {
      PUTBACK;
      THIS->emit(data, GIMME_V).push_stack();
      SPAGAIN;
    }
    catch(BadConvertVal) {
      XSRETURN_UNDEF;
    }

Slot*
SignalBase::slot()
  CODE:
    const char *CLASS = "SigC::Slot";
    RETVAL = new Slot(THIS->slot());
  OUTPUT:
    RETVAL

void
SignalBase::DESTROY()
