#ifndef NSAUTODRAWSPECBUFFER_INCLUDED
#define NSAUTODRAWSPECBUFFER_INCLUDED

//#include "nsIDeviceContext.h"
#include <X11/Xft/Xft.h>

// a helper class for Xft glyph drawings
class nsAutoDrawSpecBuffer {
public:
    enum {BUFFER_LEN=1024};
    nsAutoDrawSpecBuffer(XftDraw *aDraw, XftColor *aColor, Display *aDisplay) :
                         mDraw(aDraw), mColor(aColor), mSpecPos(0), mDisplay(aDisplay) 
                         {}

    ~nsAutoDrawSpecBuffer() {
        Flush();
    }

    void Flush();
    void Draw(nscoord x, nscoord y, XftFont *font, FT_UInt glyph);
    void SetColor(XftColor *aColor)
    {
      Flush();
      mColor = aColor;
    }
private:
    XftDraw         *mDraw;
    XftColor        *mColor;
    PRUint32         mSpecPos;
    XftGlyphFontSpec mSpecBuffer[BUFFER_LEN];
    Display         *mDisplay;
};
#endif
